#ifndef _LayoutTest_LayoutPane_h_
#define _LayoutTest_LayoutPane_h_

#include <CtrlLib/CtrlLib.h>
using namespace Upp;

template<class T>
class BoxLayout : public T
{
public:
    BoxLayout() {ishorz = false; border = 4; spacing = 4;}
    
    virtual void Layout();
    
    BoxLayout<T> &SetHorz(bool _ishorz = true)   {ishorz = _ishorz; return *this;}
    bool GetHorz() const                         {return ishorz;}
    
    BoxLayout<T> &SetBorder(int _border = 4)     {ASSERT(_border>=0); border = _border; return *this;}
    int  GetBorder() const                       {return border;}
    
    BoxLayout<T> &SetSpacing(int _spacing = 4)   {ASSERT(_spacing>=0); spacing = _spacing; return *this;}
    int  GetSpacing() const                      {return border;}
protected:
    int spacing;
    int border;
    bool ishorz;
};

template<class T>
void BoxLayout<T>::Layout()
{
    Size sz = T::GetSize();
    Ctrl::LogPos cp;
    int children = 0, total_space;
    Ctrl *c = T::GetFirstChild();   
    
    while (c) {
        children++;
        c = c->GetNext();   
    }
    if (!children) return;
    
    total_space = border*2+(children-1)*spacing;
    if (ishorz) {
        if (total_space > sz.cx) return;
        cp.x = Ctrl::Logc(LEFT, border, (sz.cx-total_space)/children);
        cp.y = Ctrl::Logc(SIZE, border, border);
    }
    else {
        if (total_space > sz.cy) return;
        cp.x = Ctrl::Logc(SIZE, border, border);
        cp.y = Ctrl::Logc(TOP, border, (sz.cy-total_space)/children);
    }
        
    c = T::GetFirstChild();
    while (c) {
        c->SetPos(cp);
        if (ishorz)
            cp.x.SetA(cp.x.GetA()+cp.x.GetB()+spacing); 
        else
            cp.y.SetA(cp.y.GetA()+cp.y.GetB()+spacing); 
        c = c->GetNext();   
    }   
}

typedef BoxLayout<LabelBox> LabelBoxPane;
typedef BoxLayout<StaticRect> StaticBoxPane;

#endif
