#include "LayerTree.h"

void LayerTree::ChildMouseEvent(Ctrl *child, int event, Point p, int zdelta, dword keyflags)
{
	int action = event & ACTION;
	Point lpos  = p + child->GetRect().TopLeft();
	
	if (keyflags & K_MOUSELEFT) {
		if (action == DOWN && !drag_wnd.IsOpen()) {
			// Start drag timer
			int id = GetNodeIDAt(lpos);
			if (id >= 0)
				SetTimeCallback(500, THISBACK1(StartDrag, id));
		}
		else if (action == UP)
			LeftUp(lpos, keyflags);
	}
	else if ((keyflags & K_MOUSERIGHT) && (action == UP))
		RightUp(lpos, keyflags);
	TreeCtrl::ChildMouseEvent(child, event, p, zdelta, keyflags);
}
/*
Image LayerTree::CursorImage(Point p, dword keyflags)
{
	return (drag_id >= 0) ? drag_img : TreeCtrl::CursorImage(p, keyflags);
}
*/
void LayerTree::LeftUp(Point p, dword keyflags)
{
	int id; 
	if (drag_id >= 0 && (id = GetNodeIDAt(p)) >= 0 && id != drag_id) {
		Drop(id);
	}
	StopDrag();
	TreeCtrl::LeftUp(p, keyflags);
}

void LayerTree::StartDrag(int id)
{
	if (drag_wnd.IsOpen()) return;

	Point lpos = GetMousePos();
	
	SetCapture();
	drag_id = id;
	
	Rect rc = GetNode(id).ctrl->GetRect();
	Size sz(rc.Width(),rc.Height());				
	ImageDraw w(sz);
	w.DrawRect(GetSize(), SWhite());
	GetNode(id).ctrl->DrawCtrl(w);
	drag_wnd.img = w;
	drag_wnd.IgnoreMouse(true);
	drag_wnd.PopUp(this, true, true, true, true);
	
	rc = GetScreenRect();
	SetDragPos(lpos);	
}

void LayerTree::StopDrag()
{
	ReleaseCapture();
	KillTimeCallback();
	drag_id = -1;
	drag_wnd.Close();
}

void LayerTree::SetDragPos(Point p)
{
	drag_wnd.SetRect(p.x, p.y, drag_wnd.img.GetWidth(), drag_wnd.img.GetHeight());
}

void LayerTree::MoveChildren(int src, int dest)
{
	// Move children
	while (GetChildCount(src)) {
		int child = GetChild(src, 0);
		TreeCtrl::Node node;
		
		node = GetNode(child);
		MoveChildren(child, Add(dest, node));
		Remove(child);
	}
}

int LayerTree::GetNodeIDAt(Point p)
{
	// step through all VISIBLE nodes in the tree 
	// and see if one of them contains p
	int id,ID = -1;
	int n=GetLineCount();	//all (visible) items
	Ctrl* ptr;
	Rect rc;
	
	for(int i=0;i<n;i++)
	{
		id = GetItemAtLine(i);
		TreeCtrl::Node node = GetNode(id);	
		ptr = node.ctrl;
		if(ptr)
		{
			rc = ptr->GetRect();

			if(rc.Contains(p))
				ID = id;
		}
	}
	
	return ID;
}

void LayerTree::Drop(int id)
{
	// Check that id is not a child of drag_id
	int parent,child=id;
	do{
		parent = GetParent(child);
		
		if(parent==drag_id)
			return;				
		
		child = parent;			
	}while(parent!=0);	
	parent = GetParent(id);
	TreeCtrl::Node node = GetNode(drag_id);
	MoveChildren(drag_id, Add(parent, node));
	Remove(drag_id);
	Refresh();	
}

