#ifndef _LayoutTest_InputWnd_h_
#define _LayoutTest_InputWnd_h_

#ifndef _Workstation_Windows_InputWnd_h_
#define _Workstation_Windows_InputWnd_h_

#include <CtrlLib/CtrlLib.h>
using namespace Upp;
#define LAYOUTFILE <LayoutTest/LayoutTest.Lay>
#include <CtrlCore/lay.h>

template<class T>
struct InputWnd : public WithInputWndLayout<TopWindow>
{
	typedef InputWnd CLASSNAME;
	T input;
	
	InputWnd(const char *title, const char *label_text, Value in = Value())
	{
		Init(title, label_text, in);
	}
	
	InputWnd(const char *title, const char *label_text, const char *button_text, Value in = Value()) 
	{
		Init(title, label_text, in);
		ok.SetLabel(button_text);
	}		

	void Init(const char *title, const char *label_text, const Value &in) 
	{
		CtrlLayoutOKCancel(*this, title);
		label.SetLabel(label_text);	
		input.HSizePosZ(4, 4).VSizePosZ(24, 32);
		if (!in.IsVoid()) input.SetData(in);	
		Add(input);
		SizeGuess();
	}

	Value GetInput() {return input.GetData();}
	void SizeSmallest() {
		Ctrl::LogPos lp = GetPos();
		lp.x.SetB(max(max(input.GetMinSize().cx, label.GetLabelSize().cx), ok.GetPos().x.GetA()*1 + ok.GetPos().x.GetB()*2) + ok.GetPos().x.GetA()*2);
		SetPos(lp);
		CenterScreen();
	}
	void SizeGuess() {
		Ctrl::LogPos lp = GetPos();
		lp.x.SetB(max(max(input.GetStdSize().cx, label.GetLabelSize().cx), ok.GetPos().x.GetA()*1 + ok.GetPos().x.GetB()*2) + ok.GetPos().x.GetA()*2);
		lp.y.SetB(InputPos().y.GetA() + input.GetStdSize().cy + ok.GetPos().y.GetB() + ok.GetPos().x.GetA()*2);
		SetPos(lp);
		CenterScreen();
	}
	void SetInputHeight(int height) {
		Ctrl::LogPos lp = GetPos();
		lp.y.SetB(InputPos().y.GetA() + height + ok.GetPos().y.GetB() + ok.GetPos().x.GetA()*2);
		SetPos(lp);
		CenterScreen();			
	}
	
private:
	Ctrl::LogPos InputPos() {return ((Ctrl *)&input)->GetPos();}
};

template<class T>
struct CharInputWnd : public InputWnd<T>
{
	typedef CharInputWnd CLASSNAME;
	CharInputWnd(const char *title, const char *label_text, Value input = Value(), int max_chars = -1)
	: InputWnd<T>(title, label_text, input)
	{if (max_chars > 0) InputWnd<T>::input.MaxChars(max_chars);}
	CharInputWnd(const char *title, const char *label_text, const char *button_text, Value input = Value(), int max_chars = -1)
	: InputWnd<T>(title, label_text, button_text, input)
	{if (max_chars > 0) InputWnd<T>::input.MaxChars(max_chars);}	
};

/*typedef CharInputWnd<EditString> TextInputWnd;
typedef CharInputWnd<EditLTCTime> LTCInputWnd;
typedef CharInputWnd<EditLTCDur> DurationInputWnd;
typedef CharInputWnd<EditLTCDate> DateInputWnd;
typedef CharInputWnd<EditInt> IntInputWnd;
*/
#endif


#endif
