#include "HtmlDemo.h"

class HtmlParser
{
public:
  HtmlParser(String html);
  void readTag();
  void readEncodedChar();
  void startTag(String htmlTag, String qtfTag);
  void closeTag(String tag);  
  
  int pos;
  String htmlText, qtfText;
  Vector<String> tagStack;
};


HtmlParser::HtmlParser(String html) :
  htmlText(html), pos(0)
{
  while(pos < htmlText.GetCount())
  {
    switch(htmlText[pos])
    {
      case '<':
        pos++;
        readTag();
        break;
        
      case '&':
        pos++;
        readEncodedChar();
        break;
      
      case '[': case ']':  case '_':
        qtfText += '`';
        // FALLTHROUGH
      
      default:
        qtfText += htmlText[pos++];
    }
  }
}


void HtmlParser::readTag()
{
  if(pos >= htmlText.GetCount())
    return;
  
  bool isClosing = (htmlText[pos] == '/');
  if(isClosing)
    pos++;
    
  String tag;  
  while(   pos < htmlText.GetCount() 
        && htmlText[pos] != ' '
        && htmlText[pos] != '>')
  {
    tag += htmlText[pos++];
  }

  if(isClosing) {
    closeTag(tag);
  }
  else {
    if     (tag == "br") qtfText += '&';
    else if(tag == "b")  startTag(tag, "* ");
    else if(tag == "i")  startTag(tag, "/ ");
    else if(tag == "u")  startTag(tag, "_ ");
    else if(tag == "s")  startTag(tag, "- ");
  }
  
  while(   pos < htmlText.GetCount()
        && htmlText[pos-1] != '>')
    pos++;
  return;
}


void HtmlParser::readEncodedChar()
{
  while(   pos < htmlText.GetCount()
        && htmlText[pos-1] != ';')
  {
    pos++;
  }
}


void HtmlParser::startTag(String htmlTag, String qtfTag)
{
  qtfText << "[" << qtfTag;
  tagStack << htmlTag;
}


void HtmlParser::closeTag(String tag)
{
  int i;
  for(i = tagStack.GetCount()-1;
      i >= 0 && tagStack[i] != tag;
      i--)
  {
    tagStack.Drop();
    qtfText += ']';
  }
  
  if(i >= 0 && tagStack.GetCount()) {
    tagStack.Drop();
    qtfText += ']';
  }
}


String HtmlToQtf(String html)
{
  return HtmlParser(html).qtfText;
}


HtmlDemo::HtmlDemo()
{
	CtrlLayout(*this, "Html demo");
	htmlEdit <<= THISBACK(htmlChanged);
	qtfEdit <<= THISBACK(qtfChanged);
	htmlEdit <<= 
	  "<b>Bold</b> text is marked by [* text] in QTF<br><i>Italic</b> is marked by [/ text]";
	htmlChanged();  
}


void HtmlDemo::htmlChanged()
{
  String qtf = HtmlToQtf(~htmlEdit);
	qtfEdit <<= qtf;
	preview <<= qtf;
}

void HtmlDemo::qtfChanged()
{
  //htmlEdit <<= QtfToHtml(~qtfEdit);
  preview  <<= ~qtfEdit;
}


GUI_APP_MAIN
{
	HtmlDemo().Run();
}

