#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <ButtonlistTest/ButtonlistTest.lay>
#include <CtrlCore/lay.h>

void MakeButton(One<Ctrl>& ctrl)
{
	ctrl.Create<Button>();
	ctrl->WantFocus(false);
	ctrl->SizePos();
}

class ButtonlistTest : public WithButtonlistTestLayout<TopWindow> {
public:
	typedef ButtonlistTest CLASSNAME;
	ButtonlistTest()
	{
		CtrlLayout(*this, "Buttonlist test");
		Setup();
		Fill();
	}
	void Setup()
	{
		array.SetLineCy(30);
		array.AddIndex();
		array.AddColumn("Nr");
		array.AddColumn("").HeaderTab().Fixed(60);
		array.ColumnAt(1).Ctrls(MakeButton);
	}
	void Fill()
	{
		int i;
		
		// Fill list
		for (i=0; i<5; i++)
			array.Add(i, Format(t_("Element %d"), i));
			
		// Set buttons
		for (i=0; i<array.GetCount(); i++)
		{
			Button* b = (Button*)array.GetCtrl(i, 1);
			if (b)
			{
				b->SetLabel(t_("Delete"));
				b->WhenPush=THISBACK1(Click,i);
			}
		}
	}
	void Click(int i)
	{
		int pos = array.Find(i);
		if (pos>=0)
			array.Remove(pos);
	}
};

GUI_APP_MAIN
{
	ButtonlistTest().Run();
}
