#include "ide.h"

EscIde::EscIde(AppConfig& cfg) : config(cfg)
{
	Title(ESCIDE_TITLE);
	CenterScreen().Sizeable().MinimizeBox().MaximizeBox();
	SetRect(Size(640, 480));

	AddFrame(menu);
	AddFrame(TopSeparatorFrame());
	menu.Set(THISBACK(MainBar));

	codeEditor.DisableBreakpointing();
	codeEditor.BarLine(false);
	codeEditor.LineNumbers(true);
	codeEditor.Highlight("usc");
#if 0
	Font font;
	int index = font.FindFaceNameIndex("Consolas");
	if (index >= 0)
	{
		font.Height(17);
		font.Face(index);
		codeEditor.SetFont(font);
	}
#endif
	Add(codeEditor.SizePos());

	AddFrame(status);
	AddFrame(BottomSeparatorFrame());

	fileSel.Type("Esc files (*.bsc, *.esc, *.usc)", "*.bsc *.esc *.usc")
		.AllFilesType().DefaultExt("esc");

	Escape(global, "Print(x)", SIC_Print);
	StdLib(global);
}

// Functions
void EscIde::Serialize(Stream& s)
{
	int version = 1;
	s / version;

	SerializePlacement(s);
}

void EscIde::SyncIdeTitle()
{
	if (config.pathToFile.IsEmpty())
		return;

	Title(String().Cat() << config.pathToFile << " - " << ESCIDE_TITLE);
}
// Bars
void EscIde::MainBar(Bar& bar)
{
	bar.Add(t_("File"), THISBACK(FileBar));
	//bar.Add(t_("Edit"), THISBACK(EditBar));
	bar.Add(t_("Debug"), THISBACK(DebugBar));
	//bar.Add(t_("Help"), THISBACK(HelpBar));
}

void EscIde::FileBar(Bar& bar)
{
	bar.Add(t_("New"), THISBACK(OnFileNew)).Key(K_CTRL_N);
	bar.Add(t_("Open.."), CtrlImg::open(), THISBACK(OnFileOpen)).Key(K_CTRL_O);
	bar.Add(t_("Save"), CtrlImg::save(), THISBACK(OnFileSave)).Key(K_CTRL_S);
	bar.Add(t_("Save as.."), CtrlImg::save_as(), THISBACK(OnFileSaveAs)).Key(K_CTRL_W);
	bar.Separator();
	bar.Add(t_("Exit"), THISBACK(Close)).Key(K_CTRL_Q);
}

void EscIde::EditBar(Bar& bar)
{

}

void EscIde::DebugBar(Bar& bar)
{
	bar.Add(t_("Execute"), THISBACK(OnDebugExecute)).Key(K_F5);
}

void EscIde::HelpBar(Bar& bar)
{
	
}
// GUI Events
void EscIde::OnFileNew()
{
	config.pathToFile = UNNAMED_FILE;
	codeEditor.Clear();
	SyncIdeTitle();
}

void EscIde::OnFileOpen()
{
	String pathDir(GetFileDirectory(config.pathToFile));

	if (IsNull(pathDir))
	{
		fileSel.ActiveDir(GetCurrentDirectory());
	}
	else
	{
		fileSel.ActiveDir(pathDir);
	}

	if (fileSel.ExecuteOpen())
	{
		String filePath(~fileSel);
		String data(LoadFile(filePath));

		if (data.IsVoid())
		{
			Exclamation(Format("File '%s' doesn't exists", DeQtf(filePath)));
		}
		else
		{
			config.pathToFile = filePath;
			status.Temporary(t_("Opened.."));
			codeEditor.SetData(data);
			SyncIdeTitle();
		}
	}
}

void EscIde::OnFileSave()
{
	if (SaveFile(config.pathToFile, ~codeEditor))
	{
		status.Temporary(t_("Saved.."));
	}
	else
	{
		Exclamation(Format("Can't save the file '%s'", DeQtf(config.pathToFile)));
	}
}

void EscIde::OnFileSaveAs()
{
	String pathDir(GetFileDirectory(config.pathToFile));

	if (IsNull(pathDir))
	{
		fileSel.ActiveDir(GetCurrentDirectory());
	}
	else
	{
		fileSel.ActiveDir(pathDir);
	}

	if (fileSel.ExecuteSaveAs())
	{
		String filePath(~fileSel);

		if (!SaveFile(filePath, ~codeEditor))
		{
			Exclamation(Format("Can't save the file '%s'", DeQtf(filePath)));
		}
		else
		{
			config.pathToFile = filePath;
			status.Temporary(t_("Saved.."));
			SyncIdeTitle();
		}
	}
}

void EscIde::OnDebugExecute()
{
	String data(~codeEditor);

	status.Temporary(t_("Executed.."));
	// Copy global functions to local
	ArrayMap<String, EscValue> localScript;
	localScript <<= global;

	try {
		Scan(localScript, data);
		EscExecute(localScript, "main", INT_MAX);
	}
	catch (CParser::Error e) {
		resultData << "Error: " << e << '\n';
	}

	if (resultData.GetCount() == 0)
		return;

	WithCommentLayout<TopWindow> dlg;
	dlg.Sizeable().MaximizeBox();
	CtrlLayoutOKCancel(dlg, "Result");
	dlg.text <<= ~resultData;
	resultData.Clear();
	dlg.Execute();
}
