#ifndef _EscIde_EscIde_h
#define _EscIde_EscIde_h

#define ESCIDE_TITLE "EscIDE"
#define UNNAMED_FILE "Unnamed.esc"

class EscIde : public TopWindow {
private:
	AppConfig& config;
public:
	typedef EscIde CLASSNAME;
	EscIde(AppConfig& cfg);

	MenuBar menu;
	StatusBar status;

	CodeEditor codeEditor;
	FileSel fileSel;
	// Functions
	void Serialize(Stream& s);
	void SyncIdeTitle();
	// Bars
	void MainBar(Bar& bar);
	void FileBar(Bar& bar);
	void EditBar(Bar& bar);
	void DebugBar(Bar& bar);
	void HelpBar(Bar& bar);
	// GUI Events
	void OnFileNew();
	void OnFileOpen();
	void OnFileSave();
	void OnFileSaveAs();
	void OnDebugExecute();
	// Esc values
	StringBuffer resultData;
	ArrayMap<String, EscValue> global;
};

#endif
