#include "ide.h"

StringBuffer *result;

EscValue EscExecute(ArrayMap<String, EscValue>& global, const char *name, int op_limit)
{
	return Execute(global, name, op_limit);
}

void SIC_Print(EscEscape& e)
{
	if (e[0].IsArray())
		*result << String(e[0]);
	else if (e[0].IsNumber())
		*result << e[0].GetNumber();
	else if (!e[0].IsVoid())
		*result << "invalid argument to 'Print'";
}

GUI_APP_MAIN
{
	SetDefaultCharset(CHARSET_UNICODE);

	const Vector<String>& cmdLine = CommandLine();
	const int count = cmdLine.GetCount();

	AppConfig config;
	EscIde escIde(config);
	LoadFromFile(escIde);
	result = &escIde.resultData;

	if (count > 0)
	{
		String path(NormalizePath(cmdLine[0]));

		if (FileExists(path))
		{
			config.pathToFile = path;
			escIde.SyncIdeTitle();
			String data(LoadFile(config.pathToFile));
			escIde.codeEditor.SetData(data);
		}
	}

	if (config.pathToFile.IsEmpty())
		escIde.OnFileNew();

	escIde.Run();
	StoreToFile(escIde);
}
