#include <CtrlLib/CtrlLib.h>
#include <Job/Job.h>

using namespace Upp;

struct AnimatedHelloMT : public TopWindow {
	Image image;
	Job<void> worker;	// Job is a single, scope-bound worker thread that is initalized once
	                    // and it can be re-used throughout it's life-time. IT does not require
	                    // a pre-allocated thread-pool.
	
	AnimatedHelloMT()
	{
		Sizeable().Zoomable().CenterScreen().SetRect(0, 0, 640, 480);
		Title("CTRL + D: Start animation, CTRL + C: Stop animation");
	}

	~AnimatedHelloMT()
	{
		StopThread();
	}

	void SetImage(const Image& img)	// Sets the image and refreshes the screen.
	{
		GuiLock __;
		image = img;
		Refresh();
	}
	
	void StartThread()
	{
		// If a work is already in progress, then Job::Do method will simply return false.
		// Namely, no "latch" is required.
		
		worker.Do([=]()
		{
			const String& text = "Ultimate++ rocks!";
			Size sz = GetSize();
		    static int sin_tbl[16] = {
		        0, 38, 71, 92, 100, 92, 71, 38, 0, -38, -71, -92, -100, -92, -71, -38
			};
			SetImage(Null);
			while(!Job<void>::IsCanceled()) {
				ImageDraw w(sz);
				w.DrawRect(sz, White);
				Size tsz = GetTextSize(text, Roman(32));
				Point pos = (sz - tsz) / 2;
				for(int i = 0; i < text.GetLength(); i++) {
					int q = (i + GetTickCount() / 40) & 15;
					w.DrawText(pos.x, pos.y + sin_tbl[q] * (sz.cy - 32) / 200,
					           ~text + i, Roman(32), HsvColorf(q / 15.0, 1, 0.5), 1);
					pos.x += Roman(32).Info()[text[i]];
				}
				SetImage(w);
				Sleep(40);
			}
		});
	}
	
	void StopThread()
	{
		try {
			GuiUnlock __;		// This is to unlock the gui-mutex in case the worker still has the gui lock.
			worker.Cancel();
		}
		catch(const Exc& e) {	// All exceptions are propagated.
			ErrorOK(DeQtf(e));
		}
		catch(...) {
			ErrorOK("Unhandled exception");
		}
	}

	void Paint(Draw& w) override
	{
		if(!IsNull(image))
			w.DrawImage(GetSize(), image);
	}
	
	bool Key(dword key, int count) override
	{
		switch(key) {
		case K_CTRL_C:
			StopThread();
			break;
		case K_CTRL_D:
			StartThread();
			break;
		default:
			return false;
		}
		return true;
	}
	
};

GUI_APP_MAIN
{
	AnimatedHelloMT().Run();
}
