#include "plug_one.h"
#include <dlfcn.h>

#include "../../libs/plug_one/plug_one.h"
#include "../../libs/plug_ctrl/plug_ctrl.h"
#include <string>

const char *STDPLUGINPATH="/home/mais/plug_in_libs/libplug_one.so";
const char *CTRLPLUGINPATH="/home/mais/plug_in_libs/libmyctrl.so";

typedef PlugBase* (*GetPlug)();
typedef void (*KillPlug)(PlugBase*);

typedef CtrlBase* (*GetMyCtrl)();
typedef void (*KillMyCtrl)(CtrlBase*);


void test_plug_one::killplugins()
{
	if (pP)
	{
		KillPlug f=(KillPlug)dlsym(HPlug, "destroy_plug_one");
		f(pP);
		pP=nullptr;
	}
	if (HPlug) { dlclose(HPlug); HPlug=nullptr; }
	
	if (pC)
	{
		RemoveChild(pC);
		KillMyCtrl f=(KillMyCtrl)dlsym(HCtrl, "destroy_myctrl");
		f(pC);
		pC=nullptr;
	}
	if (HCtrl) { dlclose(HCtrl); HCtrl=nullptr; }
}

test_plug_one::~test_plug_one()
{
	killplugins();
}

test_plug_one::test_plug_one()
{
	Title("Plug_One").Sizeable().CenterScreen();

	HPlug=nullptr;
	pP=nullptr;
	
	Add(btnTest.SetLabel("Test").LeftPosZ(10,60).TopPosZ(10,20));
	Add(btnCheck.SetLabel("Check").LeftPosZ(10,60).TopPosZ(35,20));
	Add(btnUse.SetLabel("Use").LeftPosZ(10,60).TopPosZ(60,20));
	Add(lblCheck.SetLabel("?").LeftPosZ(150,100).TopPosZ(35,20));
	
	btnTest.WhenAction=THISFN(ontest);
	btnCheck.WhenAction=THISFN(oncheck);
	btnUse.WhenAction=THISFN(onuse);

	HCtrl=nullptr;
	pC=nullptr;
	
	Add(btnCtrl.SetLabel("Ctrl").LeftPosZ(10,60).TopPosZ(90,20));
	Add(btnEVal.SetLabel("Eval").LeftPosZ(10,60).TopPosZ(115,20));
	Add(btnChg.SetLabel("Change").LeftPosZ(10,60).TopPosZ(140,20));

	btnCtrl.WhenAction=THISFN(onctrl);
	btnEVal.WhenAction=THISFN(oneval);
	btnChg.WhenAction=THISFN(onchg);

	Add(btnKids.SetLabel("Kids").LeftPosZ(10,60).TopPosZ(170,20));
	btnKids.WhenAction=THISFN(onkids);
	
}

void test_plug_one::ontest()
{
	if (HPlug) return;
	HPlug=dlopen(STDPLUGINPATH, RTLD_LAZY);
	if (!HPlug) PromptOK(dlerror());
	else
	{
		GetPlug f=(GetPlug)dlsym(HPlug, "create_plug_one");
		if (!f) PromptOK(dlerror());
		else pP=f();
	}
}

void test_plug_one::oncheck()
{
	if (pP)
	{
		int v=pP->get_val();
		std::string s=pP->get_sval();
		s=says("val=", v, ", sval=", s);
		lblCheck.SetLabel(s.c_str());
	}
	else lblCheck.SetLabel("click Test first..");
}

void test_plug_one::onuse()
{
	if (pP)
	{
		pP->set_sval("wazzup!");
		pP->use_val(5);
		oncheck();
	}
}

void test_plug_one::onctrl()
{
	if (HCtrl) return;
	HCtrl=dlopen(CTRLPLUGINPATH, RTLD_LAZY);
	if (!HCtrl) PromptOK(dlerror());
	else
	{
		GetMyCtrl f=(GetMyCtrl)dlsym(HCtrl, "create_myctrl");
		if (!f) PromptOK(dlerror());
		else
		{
			pC=f();
			if (pC)
			{
				pC->init(this);
				//AddChild((MyCtrl*)pC);
				//Add((*pC).LeftPosZ(100,115).TopPosZ(100,20));
				pC->SetRect(150, 115, 100, 20);
				pC->Refresh(); // - no-show!
//				pC->Name("desrever"); --- invalid mem access
				Refresh();
			}
		}
	}
}

void test_plug_one::oneval()
{
	if (pC)
	{
		((MyCtrl*)pC)->EVal(7);
		int v=pC->Val();
		lblCheck.SetLabel(says("eval=", v).c_str());
	}
}

void test_plug_one::onchg()
{
	if (pC)
	{
		std::string s=pC->Name();
		lblCheck.SetLabel(says(">", s, "<").c_str());
		pC->Change();
	}
}

void reverse(std::string &s)
{
	char c;
	int i=0, n=(s.size()/2);
	while (i<n)
	{
		c=s[i];
		s[i]=s[s.size()-i-1];
		s[s.size()-i-1]=c;
		i++;
	}
}

void test_plug_one::onkids()
{
	std::string s="abcdefghij";
	reverse(s);
	lblCheck.SetLabel(s.c_str());
	bShowKids=!bShowKids;
	Refresh();
}

void test_plug_one::Paint(Draw &drw)
{
	drw.DrawRect(GetSize(), White());
	if (bShowKids)
	{
		int i=0, n=GetChildCount();
		int x=400, y=5;
		std::string s;
		Ctrl *pk;
		while (i<n)
		{
			pk=GetIndexChild(i);
			pk->Show();
			pk->Refresh();
			Rect r=pk->GetRect();
				drw.DrawLine(r.left-2, r.top-2, r.right+2, r.top-2, 2, Green());
				drw.DrawLine(r.left-2, r.top-2, r.left-2, r.bottom+2, 2, Green());
				drw.DrawLine(r.left-2, r.bottom+2, r.right+2, r.bottom+2, 2, Green());
				drw.DrawLine(r.right+2, r.top-2, r.right+2, r.bottom+2, 2, Green());
			s=says(i, ". ", r.ToString().ToStd());
			drw.DrawText(x, y, s.c_str(), StdFont().Height(13), Black());
			y+=16;
			i++;
		}
	}
}
