
#include "testplugs.h"

const char *PLAINPLUGPATH="/home/mais/plug_in_libs/libplainplug.so";
const char *CTRLPLUGPATH="/home/mais/plug_in_libs/libctrlplug.so";


void TestPlugs::killplugins()
{
	if (HPlainPlug)
	{
		KillPlug(HPlainPlug, pP);
		dlclose(HPlainPlug);
		HPlainPlug=nullptr;
		pP=nullptr;
	}
	if (HCtrlPlug)
	{
		if (pC) RemoveChild(pC);
		KillPlug(HCtrlPlug, pC);
		dlclose(HCtrlPlug);
		HCtrlPlug=nullptr;
		pC=nullptr;
	}
}

TestPlugs::~TestPlugs()
{
	killplugins();
}

TestPlugs::TestPlugs()
{
	Title("TestPlugs").Sizeable().CenterScreen();

	HPlainPlug=nullptr;
	HPlainPlug=dlopen(PLAINPLUGPATH, RTLD_NOW);
	if (!HPlainPlug) say(dlerror());
	pP=nullptr;
	
	Add(btnPlainPlug.SetLabel("PlainPlug").LeftPosZ(10,60).TopPosZ(10,20));
	Add(btnPPCheck.SetLabel("PP-Check").LeftPosZ(10,60).TopPosZ(35,20));
	Add(btnPPUse.SetLabel("PP-Use").LeftPosZ(10,60).TopPosZ(60,20));
	
	Add(lblCheck.SetLabel("?").LeftPosZ(150,100).TopPosZ(35,20));
	
	btnPlainPlug.WhenAction=THISFN(onplainplug);
	btnPPCheck.WhenAction=THISFN(onppcheck);
	btnPPUse.WhenAction=THISFN(onppuse);

	HCtrlPlug=nullptr;
	HCtrlPlug=dlopen(CTRLPLUGPATH, RTLD_NOW);
	if (!HCtrlPlug) say(dlerror());
	pC=nullptr;
	
	Add(btnCtrl.SetLabel("Ctrl").LeftPosZ(10,60).TopPosZ(90,20));
	Add(btnEVal.SetLabel("Eval").LeftPosZ(10,60).TopPosZ(115,20));
	Add(btnChg.SetLabel("Change").LeftPosZ(10,60).TopPosZ(140,20));

	btnCtrl.WhenAction=THISFN(onctrl);
	btnEVal.WhenAction=THISFN(oneval);
	btnChg.WhenAction=THISFN(onchg);

	Add(btnKids.SetLabel("Kids").LeftPosZ(10,60).TopPosZ(170,20));
	btnKids.WhenAction=THISFN(onkids);
	
}

void TestPlugs::onplainplug()
{
	if (!HPlainPlug) { sayerr("plain plug lib not open"); return; }
	if (!pP) { if ((pP=GetPlug<PlainBase>(HPlainPlug))) onppcheck(); }
}

void TestPlugs::onppcheck()
{
	if (pP)
	{
		int v=pP->get_val();
		std::string s=pP->get_sval();
		s=says("val=", v, ", sval=", s);
		lblCheck.SetLabel(s.c_str());
	}
	else lblCheck.SetLabel("click Test first..");
}

void TestPlugs::onppuse()
{
	static int n=0;
	if (pP)
	{
		std::string s=pP->get_sval();
		if (!s.empty()) s=says(++n, ":", s); else s="AbC";
		pP->set_sval(s.c_str());
		pP->use_val(5);
		onppcheck();
	}
}

void TestPlugs::onctrl()
{
	if (!HCtrlPlug) { sayerr("ctrl plug lib not open"); return; }
	if (!pC)
	{
		if ((pC=GetPlug<CtrlBase>(HCtrlPlug)))
		{
			AddChild(pC);
			//pC->dosetup(this, Rect(200, 115, 100, 20)); --crashes
			pC->SetRect(200, 115, 100, 20);
			pC->Refresh();
			Refresh();
		}
	}
}

void TestPlugs::oneval()
{
	if (pC)
	{
		int v=7;
		pC->doeval(v);
		v=pC->getval();
		lblCheck.SetLabel(says("eval=", v).c_str());
	}
}

void TestPlugs::onchg()
{
	if (pC)
	{
		std::string s="desrever";
		pC->setname(s);
		pC->makechange();
		//pC->Refresh();
	}
}

void TestPlugs::onkids()
{
	bShowKids=!bShowKids;
	Refresh();
}

void TestPlugs::Paint(Draw &drw)
{
	drw.DrawRect(GetSize(), White());
	if (bShowKids)
	{
		int i=0, n=GetChildCount();
		int x=400, y=5;
		std::string s;
		Ctrl *pk;
		while (i<n)
		{
			pk=GetIndexChild(i);
			pk->Show();
			pk->Refresh();
			Rect r=pk->GetRect();
				drw.DrawLine(r.left-2, r.top-2, r.right+2, r.top-2, 2, Green());
				drw.DrawLine(r.left-2, r.top-2, r.left-2, r.bottom+2, 2, Green());
				drw.DrawLine(r.left-2, r.bottom+2, r.right+2, r.bottom+2, 2, Green());
				drw.DrawLine(r.right+2, r.top-2, r.right+2, r.bottom+2, 2, Green());
			s=says(i, ". ", r.ToString().ToStd());
			drw.DrawText(x, y, s.c_str(), StdFont().Height(13), Black());
			y+=16;
			i++;
		}
	}
}
