#ifndef _testplugs_h_
#define _testplugs_h_

#include <CtrlLib/CtrlLib.h>
using namespace Upp;

#include <string>
#include <sstream>
#include <dlfcn.h>
#include "plainbase.h"
#include "ctrlbase.h"


template<typename...P> void say(P...p) { std::string r{}; std::stringstream ss(""); (ss<<...<<p); r=ss.str(); PromptOK(DeQtf(r.c_str())); }
template<typename...P> std::string says(P...p) { std::string r{}; std::stringstream ss(""); (ss<<...<<p); r=ss.str(); return r; }
template<typename...P> void sayss(std::string &s, P...p) { std::string r{}; std::stringstream ss(""); (ss<<...<<p); r=ss.str();  s+=r; } //APPENDS! to s!
template<typename...P> bool sayerr(P...p) { std::string r{}; std::stringstream ss("ERROR: "); (ss<<...<<p); r=ss.str();  PromptOK(DeQtf(r.c_str())); return false; }

using HLIB=void*;

template<typename P> P* GetPlug(HLIB lib)
{
	typedef P* ff();
	P *p{nullptr};
	ff *pf=(ff*)dlsym(lib, "CreatePlug");
	if (!pf) sayerr(dlerror()); else p=pf();
	return p;
};

template<typename P> void KillPlug(HLIB lib, P *p)
{
	typedef void ff(P*);
	ff *pf=(ff*)dlsym(lib, "DestroyPlug");
	if (!pf) sayerr(dlerror()); else pf(p);
};


struct TestPlugs : public TopWindow
{
	typedef TestPlugs CLASSNAME;

	HLIB HPlainPlug{nullptr};
	HLIB HCtrlPlug{nullptr};
	
	PlainBase* pP{nullptr};
	Button btnPlainPlug;
	Button btnPPCheck;
	Button btnPPUse;
	
	Label lblCheck;
	
	CtrlBase* pC{nullptr};
	Button btnCtrl;
	Button btnEVal;
	Button btnChg;
	
	Button btnKids;
	void killplugins();
	
	~TestPlugs();
	TestPlugs();

	bool bShowKids{false};

	void Paint(Draw &drw);

	void onplainplug();
	void onppcheck();
	void onppuse();
	
	void onctrl();
	void oneval();
	void onchg();
	
	void onkids();
};

#endif
