#include "EditSecretText.h"

#define IMAGECLASS Images
#define IMAGEFILE <EditSecretText/EditSecretText.iml>
#include <Draw/iml_source.h>


void sSyncLabel(Label *lbl, const char *label, EditString *text)
{
	lbl->SetLabel(String().Cat() << label << " (" << text->GetLength() << "/" << text->GetMaxLength() << ")");
}

bool EditSecret(String& s, const char *title, const char *label, const char *instructions,
					Event<const String&> WhenLink, int (*filter)(int), int maxlen, bool notnull)
{
	struct sToggle : ButtonOption {
		void Paint(Draw& w) override
		{
			w.DrawImage(GetView().Deflated(2, 4), Get() ? Images::PwdShown() : Images::PwdHidden());
		}
	};
	
	WithEditSecretLayout<TopWindow> dlg;
	CtrlLayoutOKCancel(dlg, title);
	FrameRight<sToggle> toggle;
	RichTextCtrl qtf;
	dlg.CenterOwner();
	dlg.lbl = label;
	dlg.text <<= s.ToWString();
	dlg.text.NotNull(notnull);
	dlg.text.Password();
	if(filter)
		dlg.text.SetFilter(filter);
	if(maxlen > 0) {
		dlg.text.MaxLen(maxlen);
		dlg.text << [&] { sSyncLabel(&dlg.lbl, label, &dlg.text); };
		dlg.text.WhenAction();
	}
	dlg.text.AddFrame(toggle);
	toggle << [&dlg] { dlg.text.Password(!dlg.text.IsPassword()); };
	if(instructions) {
		qtf.SetQTF("[G1 " + String(instructions), GetRichTextStdScreenZoom());
		qtf.WhenLink = WhenLink;
		Size sz = dlg.GetSize();
		Rect rd = dlg.GetRect();
		Rect rt = dlg.text.GetRect();
		dlg.SetMinSize(sz);
		dlg.Add(qtf.HSizePos(4 , 4).VSizePos(4,  rd.bottom - rt.top - 4));
		sz.cx =  qtf.GetWidth() + Zx(8);
		sz.cy += max(qtf.GetHeight(), 0);
		rd.SetSize(min(sz, Size(1920, 1080)));
		dlg.SetRect(rd);
	}

	if(dlg.ExecuteOK()) {
		s = ~dlg.text;
		return true;
	}
	return false;
}

bool EditSecret(WString& s, const char *title, const char *label, const char *instructions,
					Event<const String&> hyperlink, int (*filter)(int), int maxlen, bool notnull)
{
	String ss = s.ToString();
	if(EditSecret(ss, title, label, instructions, hyperlink, filter, maxlen, notnull)) {
		s = ss.ToWString();
		return true;
	}
	return false;
}
									
bool EditSecret(String& s, const char *title, const char *label, const char *instructions = nullptr, int maxlen = 0)
{
	return EditSecret(s, title, label, instructions, Null, CharFilterUnicode, maxlen, false);
}

bool EditSecret(WString& s, const char *title, const char *label, const char *instructions = nullptr, int maxlen = 0)
{
	return EditSecret(s, title, label, instructions, Null, CharFilterUnicode, maxlen, false);
}

bool EditSecretNotNull(String& s, const char *title, const char *label, const char *instructions = nullptr, int maxlen = 0)
{
	return EditSecret(s, title, label, instructions, Null, CharFilterUnicode,  maxlen, true);
}

bool EditSecretNotNull(WString& s, const char *title, const char *label, const char *instructions = nullptr, int maxlen = 0)
{
	return EditSecret(s, title, label, instructions, Null, CharFilterUnicode,  maxlen, true);
}

GUI_APP_MAIN
{
	String qtf =	"[ [= @@rawimage:100&100(iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTU"
					"EAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAJ3SURBVDjLpZNt"
					"SNNRFIcNKunF1rZWBMJqKaSiX9RP1dClsjldA42slW0q5oxZiuHrlqllLayoaJa2jbm1Lc3QUZpKFm"
					"maTMsaRp+kMgjBheSmTL2//kqMBJlFHx44XM7vOfdyuH4A/P6HFQ9zo7cpa/mM6RvCrVDzaVDy6C5J"
					"JKv6rwSnIhlFd0R0Up/GwF2KWyl01CTSkM/dQoQRzAurCjRCGnRUUE2FaoSL0HExiYVzsQwcj6RNrS"
					"qo4W5Gh6Yc4+1qDDTkIy+GhYK4nTgdz0H2PrrHUJzs71NQn86enPn+CVN9GnzruoYR63mMPbkC59gQ"
					"zDl7pt7rc9f7FNyUhPY6Bx9gwt4E9zszhWWpdg6ZcS8j3O7zCTuEpnXB+3MNZkUUZu0NmHE8XsL91o"
					"SWwiiEc3MeseLrN6woYCWa/Zl8ozyQ3w3Hl2lYy0SwlCUvsVi/Gv2JwITnYPDun2Hy6jYuEzAF1jUB"
					"CVYpO6kXo+NuGMeBAgcgfwNkvgBOPgUqXgKvP7rBFvRhE1crp8Vq1noFYSlacVyqGk0D86gbART9BD"
					"k9BFnPCNJbCY5aCFL1Cyhtp0RWAp74MsKSrkq9guHyvfMTtmLc1togpZoyqYmyNoITzVTYRJCiXYBI"
					"Q3CwFqi83o3JDhX6C0M8XsGIMoQ4OyuRlq1DdZcLkmbgGDX1iIEKNxAcbgTEOqC4ZRaJ6Ub86K7CYF"
					"Eo8Qo+GBQlQyXBczLZpbloaQ9k1NUz/kD2myBBKxRZpa5hVcQslalatoUxizxAVVrN3CW21bFj9F85"
					"8Q9dnIRmDyeuybM71uxmH9BNBB1q6zybV7H9s1Ue4PM3/gu/AEbfqfWy2twsAAAAAElFTkSuQmCC)&"
					"][= This is a [*/_@3 qtf`-based] authentication dialog for [^https`:`/`/www`.u"
					"ltimatepp`.org`/index`.html^ U`+`+].]]";
					
	String txt =	"This is the first line.\n"
					"This is the second line.\n"
					"This is the third line.";
					
	String pwd =	"password";

	auto OnHyperlink = [](const String& s) { Upp::LaunchWebBrowser(s); };

	EditSecret(pwd, "Title", "Prompt", qtf, OnHyperlink, nullptr, 16, false);
	EditSecret(pwd, "Title", "Prompt", DeQtf(txt));
	EditSecret(pwd, "Title", "Prompt");
}
