#ifndef _GraphCtrl_Demo_CustomDataSource_WF_h_
#define _GraphCtrl_Demo_CustomDataSource_WF_h_

namespace Upp {
namespace GraphDraw_ns {
	// =========================================================
	//    TEST CLASSES
	// =========================================================
	class CustomData_WF : public CustomData {
		public:
			double dateDebut;
			double dateFin;
			double hauteur;
			int priorite;
			Value rectStyle;
			RectGraph rectGraphBound;
			
			CustomData_WF(int deb, int fin, int prio=0, int haut=10, Value style=Color(113, 255, 255) )
			: dateDebut(deb)
			, dateFin(fin)
			, hauteur(haut)
			, priorite(prio)
			, rectStyle(style)
			{
				rectGraphBound.left = dateDebut;
				rectGraphBound.right = dateFin;
				rectGraphBound.bottom = 0;
				rectGraphBound.top = 1000;
			}
			
			CustomData_WF() {
				hauteur = .5;
				priorite = 0;
				rectStyle = GraphDrawImg::FW_IMG();
				rectGraphBound.SetNull();
			}
			virtual ~CustomData_WF() {}

			virtual bool Intersects(const RectGraph& graphView) const
			{
				//RLOG( "CustomData_WF::Intersects()=" << graphView.Intersects(rectGraphBound) << " : "<< graphView <<  "  --  " << rectGraphBound);
				if ( !rectGraphBound.IsNullInstance() || !rectGraphBound.IsEmpty() ) return graphView.Intersects(rectGraphBound);
				return true;
			}
			
			virtual bool Contains(const PointGraph& pt) const
			{
//				RLOG("CustomData_WF::Contains()["<< priorite << "]="<< rectGraphBound.Contains(pt) << " : " << pt << "  -- "  << rectGraphBound);
				return rectGraphBound.Contains(pt);
			}
			
			virtual void PaintDataPoint(BufferPainter& dw, int scale, const CoordinateConverter* xCoordConv, const CoordinateConverter* yCoordConv )
			{
				double start = dateDebut;
				double end = dateFin;
				
				//RectGraph rectGraphBound2;
				rectGraphBound.left = start/10;
				rectGraphBound.right = end/10;
				rectGraphBound.top = priorite/10;
				rectGraphBound.bottom = priorite/10 + hauteur;
				
				const TypeScreenCoord left = xCoordConv->toScreen(rectGraphBound.left);
				const TypeScreenCoord right = xCoordConv->toScreen(rectGraphBound.right);
				const TypeScreenCoord bottom = yCoordConv->toScreen(rectGraphBound.top);
				const TypeScreenCoord top = yCoordConv->toScreen(rectGraphBound.bottom);
				Rect r(left,top, right, bottom);
				
//				RLOGBLOCK( "CustomData_WF::PaintDataPoint()" );
//				RLOG( "Graph: " << rectGraphBound << " ==> Screen: " << r );
//				RLOG( "Graph: " << rectGraphBound.left << " ==> Screen: " << left << " ==> Graph: " << xCoordConv->toGraph(left) );
				
				ChPaint(dw, r, rectStyle);
			}
	};
	
	class CustomDataSource_WF : public CustomDataSource
	{
		enum {DATA_COUNT=6};
		CustomData_WF data[DATA_COUNT];
		public:
			CustomDataSource_WF() {}
			virtual ~CustomDataSource_WF() {}
			
			virtual unsigned int GetCount() const {return DATA_COUNT;};
			virtual const CustomData& Get(unsigned int dataIndex) const { return data[dataIndex]; }
			virtual       CustomData& Get(unsigned int dataIndex)       { return data[dataIndex]; }
			
			CustomData_WF& operator[](int dataIndex) { return data[dataIndex]; }

			virtual bool IsCtrlable() { return true; }

			virtual bool LeftDouble (unsigned int pIndex, PointGraph p, dword keyflags) {
				RLOG( "CustomDataSource_WF::LeftDouble() [" << pIndex << "] : " << data[pIndex].dateDebut);
				return true;
			}
			
			virtual bool CursorImage(unsigned int pIndex, PointGraph p, dword keyflags, Image& outImg ) {
				outImg = GraphDrawImg::CROSS();
				return true;
			}

	};
};
};

#endif
