#ifndef _GraphDraw_GraphDrawCRTP_h_
#define _GraphDraw_GraphDrawCRTP_h_


namespace GraphDraw_ns
{

template<class TYPES, class DERIVED>
class GD_XYLTMM_GraphDraw   : public CRTP_EmptyGraphDraw<TYPES, DERIVED>
{
	public:
	typedef GD_XYLTMM_GraphDraw<TYPES, DERIVED> CLASSNAME;
	typedef CRTP_EmptyGraphDraw<TYPES, DERIVED> _B;
	
	typedef typename TYPES::X_TypeCoordConverter TypeCoordConverterX;
	typedef typename TYPES::X_TypeGridAxisDraw   TypeGridAxisX1;
	typedef typename TYPES::TypeLabelElement     TypeLabelX1;
	typedef typename TYPES::Y_TypeCoordConverter TypeCoordConverterY1;
	typedef typename TYPES::Y_TypeGridAxisDraw   TypeGridAxisY1;
	typedef typename TYPES::TypeLabelElement     TypeLabelY1;
	typedef typename TYPES::TypeLegendElement    TypeLegend;
	typedef typename TYPES::TypeLabelElement     TypeLabelTitle;
	typedef typename TYPES::TypeMarkerElement    TypeMarkerX1;
	typedef typename TYPES::TypeMarkerElement    TypeMarkerY1;
	
	
	protected:
		TypeCoordConverterX   _xConverter;
		TypeGridAxisX1        _xGridDraw;
		TypeLabelX1           _xLabel;
		TypeCoordConverterY1  _yConverter;
		TypeGridAxisY1        _yGridDraw;
		TypeLabelY1          _yLabel;
		TypeLegend           _legend;
		TypeLabelTitle       _title;
		TypeMarkerX1         _xMarkerGraphElement;
		TypeMarkerY1         _yMarkerGraphElement;

	public:
		DERIVED& setGraphSize(Rectf r) {
			_xConverter.updateGraphSize(r.TopLeft().x, r.BottomRight().x);
			_yConverter.updateGraphSize(r.TopLeft().y, r.BottomRight().y);
			_B::updateSizes();
			return *static_cast<DERIVED*>(this);
		}

		DERIVED& setGraphSize(TypeGraphCoord x0, TypeGraphCoord x1, TypeGraphCoord y0, TypeGraphCoord y1) {
			_xConverter.updateGraphSize( x0, x1);
			_yConverter.updateGraphSize( y0, y1);
			_B::updateSizes();
			return *static_cast<DERIVED*>(this);
		}

	// X1
	public:
		virtual ~GD_XYLTMM_GraphDraw() {}

		GD_XYLTMM_GraphDraw()
		: _xConverter(*this)
		, _xGridDraw(_xConverter)
		, _yConverter(*this)
		, _yGridDraw(_yConverter)
		, _xMarkerGraphElement(_xConverter)
		, _yMarkerGraphElement(_yConverter)
		{
			//SetStyle( StyleDefault() );
			_B::AddXConverter(_xConverter);
			_B::AddBottomElement(_xGridDraw, 20);
			_B::AddBottomElement(30, _xLabel, 25);
			_xGridDraw.SetName( t_("X axis") );
			_xGridDraw.SetElementWidth(25);
			_xLabel.SetName( t_("X label") );
			_xLabel.SetLabel("X Axis label");

			_B::AddYConverter(_yConverter);
			_B::AddLeftElement(_yGridDraw, 20);
			_B::AddLeftElement(30, _yLabel, 25);
			_yGridDraw.SetName( t_("Y axis") );
			_yGridDraw.SetElementWidth(40);
			_yLabel.SetName( t_("Y label") );
			_yLabel.SetLabel("Y Axis label");
			
			_legend.SetName(t_("Legend"));
			RGBA rgba;
			rgba.r=90; rgba.g=90; rgba.b=0;	rgba.a=90;
			_legend.SetBackGroundStyle( Color(rgba) );
			_legend.SetFloatFrame(RectScreen(PointScreen(40,20), Size(80, 30)));
			_B::AddFloatElement(30, _legend, 150);
			
			_B::AddTopElement(40, _title, 200);
			_title.SetName( t_("Title") );
			_title.SetLabel("TITLE");

			_B::AddTopElement(30, _xMarkerGraphElement, -1);
			_xMarkerGraphElement.SetAllowedPosMask(BOTTOM_OF_GRAPH | TOP_OF_GRAPH);

			_B::AddRightElement(30, _yMarkerGraphElement, -1);
			_yMarkerGraphElement.SetAllowedPosMask(LEFT_OF_GRAPH | RIGHT_OF_GRAPH);
		};


		TypeCoordConverterX& GetX1CoordConverter()  { return _xConverter; }
		TypeGridAxisX1& GetX1GridAxisDraw()         { return _xGridDraw; }
		MAKE_GRAPHDRAW_AXIS_FN(X,x);
		
		TypeLabelX1& GetX1Label()                   { return _xLabel; }
		MAKE_GRAPHDRAW_LABEL_FN(X,x);

		TypeCoordConverterY1& GetY1CoordConverter() { return _yConverter; }
		TypeGridAxisY1& GetY1GridAxisDraw()         { return _yGridDraw; }
		MAKE_GRAPHDRAW_AXIS_FN(Y,y);
		
		TypeLabelY1& GetY1Label()                   { return _yLabel; }
		MAKE_GRAPHDRAW_LABEL_FN(Y,y);
		
		TypeLegend& GetLegendElement()                      { return _legend; }
		DERIVED& HideLegend(bool v)                         { _legend.Hide(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendPosition(const ElementPosition v) { _legend.SetElementPos(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendFont(const Font v)                { _legend.SetFont(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendWidth(int v)                      { _legend.SetElementWidth(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendBackGroundStyle(const Value& v)   { _legend.SetBackGroundStyle(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendXSize(int v)                      { RectScreen r = _legend.GetFloatFrame();r.right = r.left+v; _legend.SetFloatFrame(r); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendYSize(int v)                      { RectScreen r = _legend.GetFloatFrame();r.bottom = r.top+v; _legend.SetFloatFrame(r); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendXPos(int v)                       { RectScreen r = _legend.GetFloatFrame();r.right = v+r.Width(); r.left=v; _legend.SetFloatFrame(r); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendYPos(int v)                       { RectScreen r = _legend.GetFloatFrame();r.bottom = v+r.Height(); r.top=v; _legend.SetFloatFrame(r); return *static_cast<DERIVED*>(this); }

		TypeLabelTitle& GetTitleElement()  { return _title; }
		MAKE_GRAPHDRAW_TITLE_FN;

		TypeMarkerX1& GetX1MarkersElement()                   { return _xMarkerGraphElement; }
		DERIVED& HideX1Markers(bool v)                        { _xMarkerGraphElement.Hide(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetX1MarkerPosition(const ElementPosition v) { _xMarkerGraphElement.SetElementPos(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetX1MarkerWidth(int v)                      { _xMarkerGraphElement.SetElementWidth(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetX1MarkerBackgroundStyle(Value v)          { _xMarkerGraphElement.SetBackGroundStyle(v); return *static_cast<DERIVED*>(this); }
		
		TypeMarkerY1& GetY1MarkersElement()                   { return _yMarkerGraphElement; }
		DERIVED& HideY1Markers(bool v)                        { _yMarkerGraphElement.Hide(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetY1MarkerPosition(const ElementPosition v) { _yMarkerGraphElement.SetElementPos(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetY1MarkerWidth(int v)                      { _yMarkerGraphElement.SetElementWidth(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetY1MarkerBackgroundStyle(Value v)          { _yMarkerGraphElement.SetBackGroundStyle(v); return *static_cast<DERIVED*>(this); }
};









template<class TYPES, class DERIVED>
class GD_XYY2LTMM_GraphDraw   : public CRTP_EmptyGraphDraw<TYPES, DERIVED>
{
	public:
	typedef GD_XYLTMM_GraphDraw<TYPES, DERIVED> CLASSNAME;
	typedef CRTP_EmptyGraphDraw<TYPES, DERIVED> _B;
	
	typedef typename TYPES::X_TypeCoordConverter TypeCoordConverterX;
	typedef typename TYPES::X_TypeGridAxisDraw   TypeGridAxisX1;
	typedef typename TYPES::TypeLabelElement     TypeLabelX1;

	typedef typename TYPES::Y_TypeCoordConverter TypeCoordConverterY1;
	typedef typename TYPES::Y_TypeGridAxisDraw   TypeGridAxisY1;
	typedef typename TYPES::TypeLabelElement     TypeLabelY1;

	typedef typename TYPES::Y_TypeCoordConverter TypeCoordConverterY2;
	typedef typename TYPES::Y_TypeGridAxisDraw   TypeGridAxisY2;
	typedef typename TYPES::TypeLabelElement     TypeLabelY2;

	typedef typename TYPES::TypeLegendElement    TypeLegend;
	typedef typename TYPES::TypeLabelElement     TypeLabelTitle;
	typedef typename TYPES::TypeMarkerElement    TypeMarkerX1;
	typedef typename TYPES::TypeMarkerElement    TypeMarkerY1;
	typedef typename TYPES::TypeMarkerElement    TypeMarkerY2;
	
	
	protected:
		TypeCoordConverterX  _xConverter;
		TypeGridAxisX1        _xGridDraw;
		TypeLabelX1           _xLabel;

		TypeCoordConverterY1 _yConverter;
		TypeGridAxisY1       _yGridDraw;
		TypeLabelY1          _yLabel;

		TypeCoordConverterY2 _y2Converter;
		TypeGridAxisY2       _y2GridDraw;
		TypeLabelY2          _y2Label;

		TypeLegend           _legend;
		TypeLabelTitle       _title;
		TypeMarkerX1         _xMarkerGraphElement;
		TypeMarkerY1         _y1MarkerGraphElement;
		TypeMarkerY1         _y2MarkerGraphElement;

	private:
		// forbid usage of following methods in this case
		DERIVED& setGraphSize(Rectf r) {}
		DERIVED& setGraphSize(TypeGraphCoord x0, TypeGraphCoord x1, TypeGraphCoord y0, TypeGraphCoord y1) {}
		
	public:
		DERIVED& setGraphSize(TypeGraphCoord x0, TypeGraphCoord x1, TypeGraphCoord y0, TypeGraphCoord y1, TypeGraphCoord y20, TypeGraphCoord y21 )
		{
			_xConverter.updateGraphSize( x0, x1);
			_yConverter.updateGraphSize( y0, y1);
			_y2Converter.updateGraphSize( y20, y21);
			_B::updateSizes();
			return *static_cast<DERIVED*>(this);
		}

	// X1
	public:
		virtual ~GD_XYY2LTMM_GraphDraw() {}

		GD_XYY2LTMM_GraphDraw()
		: _xConverter(*this)
		, _xGridDraw(_xConverter)
		, _yConverter(*this)
		, _yGridDraw(_yConverter)
		, _y2Converter(*this)
		, _y2GridDraw(_y2Converter)
		, _xMarkerGraphElement(_xConverter)
		, _y1MarkerGraphElement(_yConverter)
		, _y2MarkerGraphElement(_y2Converter)
		{
			//SetStyle( StyleDefault() );
			_B::AddXConverter(_xConverter);
			_B::AddBottomElement(_xGridDraw, 20);
			_B::AddBottomElement(30, _xLabel, 25);
			_xGridDraw.SetName( t_("X axis") );
			_xGridDraw.SetElementWidth(25);
			_xLabel.SetName( t_("X label") );
			_xLabel.SetLabel("X Axis label");

			_B::AddYConverter(_yConverter);
			_B::AddLeftElement(_yGridDraw, 20);
			_B::AddLeftElement(30, _yLabel, 25);
			_yGridDraw.SetName( t_("Y1 axis") );
			_yGridDraw.SetElementWidth(40);
			_yLabel.SetName( t_("Y1 label") );
			_yLabel.SetLabel("Y1 Axis label");

			_B::AddYConverter(_y2Converter);
			_B::AddRightElement(_y2GridDraw, 20);
			_B::AddRightElement(30, _y2Label, 25);
			_y2GridDraw.SetName( t_("Y2 axis") );
			_y2GridDraw.SetElementWidth(40);
			_y2Label.SetName( t_("Y2 label") );
			_y2Label.SetLabel("Y2 Axis label");
			
			_legend.SetName(t_("Legend"));
			RGBA rgba;
			rgba.r=90; rgba.g=90; rgba.b=0;	rgba.a=90;
			_legend.SetBackGroundStyle( Color(rgba) );
			_legend.SetFloatFrame(RectScreen(PointScreen(40,20), Size(80, 30)));
			_B::AddFloatElement(30, _legend, 150);
			
			_B::AddTopElement(40, _title, 200);
			_title.SetName( t_("Title") );
			_title.SetLabel("TITLE");

			_B::AddTopElement(30, _xMarkerGraphElement, -1);
			_xMarkerGraphElement.SetAllowedPosMask(BOTTOM_OF_GRAPH | TOP_OF_GRAPH);

			_B::AddRightElement(30, _y1MarkerGraphElement, -1);
			_y1MarkerGraphElement.SetAllowedPosMask(LEFT_OF_GRAPH | RIGHT_OF_GRAPH);

			_B::AddRightElement(30, _y2MarkerGraphElement, -1);
			_y2MarkerGraphElement.SetAllowedPosMask(LEFT_OF_GRAPH | RIGHT_OF_GRAPH);
		};


		TypeCoordConverterX& GetX1CoordConverter() { return _xConverter; }
		TypeGridAxisX1& GetX1GridAxisDraw()         { return _xGridDraw; }
		MAKE_GRAPHDRAW_AXIS_FN(X,x);
		MAKE_GRAPHDRAW_LABEL_FN(X,x);

		TypeCoordConverterY1& GetY1CoordConverter() { return _yConverter; }
		TypeGridAxisY1& GetY1GridAxisDraw()          { return _yGridDraw; }
		MAKE_GRAPHDRAW_AXIS_FN(Y,y);
		MAKE_GRAPHDRAW_LABEL_FN(Y,y);

		TypeCoordConverterY2& GetY2CoordConverter() { return _y2Converter; }
		TypeGridAxisY2& GetY2GridAxisDraw()         { return _y2GridDraw; }
		MAKE_GRAPHDRAW_AXIS_FN(Y2,y2);
		MAKE_GRAPHDRAW_LABEL_FN(Y2,y2);

		TypeLegend& GetLegendElement()                      { return _legend; }
		DERIVED& HideLegend(bool v)                         { _legend.Hide(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendPosition(const ElementPosition v) { _legend.SetElementPos(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendFont(const Font v)                { _legend.SetFont(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendWidth(int v)                      { _legend.SetElementWidth(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendBackGroundStyle(const Value& v)   { _legend.SetBackGroundStyle(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendXSize(int v)                      { RectScreen r = _legend.GetFloatFrame();r.right = r.left+v; _legend.SetFloatFrame(r); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendYSize(int v)                      { RectScreen r = _legend.GetFloatFrame();r.bottom = r.top+v; _legend.SetFloatFrame(r); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendXPos(int v)                       { RectScreen r = _legend.GetFloatFrame();r.right = v+r.Width(); r.left=v; _legend.SetFloatFrame(r); return *static_cast<DERIVED*>(this); }
		DERIVED& SetLegendYPos(int v)                       { RectScreen r = _legend.GetFloatFrame();r.bottom = v+r.Height(); r.top=v; _legend.SetFloatFrame(r); return *static_cast<DERIVED*>(this); }

		TypeLabelTitle& GetTitleElement()  { return _title; }
		MAKE_GRAPHDRAW_TITLE_FN;

		TypeMarkerX1& GetX1MarkersElement()                   { return _xMarkerGraphElement; }
		DERIVED& HideX1Markers(bool v)                        { _xMarkerGraphElement.Hide(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetX1MarkerPosition(const ElementPosition v) { _xMarkerGraphElement.SetElementPos(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetX1MarkerWidth(int v)                      { _xMarkerGraphElement.SetElementWidth(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetX1MarkerBackgroundStyle(Value v)          { _xMarkerGraphElement.SetBackGroundStyle(v); return *static_cast<DERIVED*>(this); }
		
		TypeMarkerY1& GetY1MarkersElement()                   { return _y1MarkerGraphElement; }
		DERIVED& HideY1Markers(bool v)                        { _y1MarkerGraphElement.Hide(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetY1MarkerPosition(const ElementPosition v) { _y1MarkerGraphElement.SetElementPos(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetY1MarkerWidth(int v)                      { _y1MarkerGraphElement.SetElementWidth(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetY1MarkerBackgroundStyle(Value v)          { _y1MarkerGraphElement.SetBackGroundStyle(v); return *static_cast<DERIVED*>(this); }

		TypeMarkerY2& GetY2MarkersElement()                   { return _y2MarkerGraphElement; }
		DERIVED& HideY2Markers(bool v)                        { _y2MarkerGraphElement.Hide(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetY2MarkerPosition(const ElementPosition v) { _y2MarkerGraphElement.SetElementPos(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetY2MarkerWidth(int v)                      { _y2MarkerGraphElement.SetElementWidth(v); return *static_cast<DERIVED*>(this); }
		DERIVED& SetY2MarkerBackgroundStyle(Value v)          { _y2MarkerGraphElement.SetBackGroundStyle(v); return *static_cast<DERIVED*>(this); }
};

}; // namespace GraphDraw_ns


#endif
