#include "GraphCtrl.h"

namespace Upp {
namespace GraphDraw_ns {

#define MAKE_STYLE_METH(STYLETYPE, STYLENAME)\
STYLETYPE Make__##STYLENAME##___##STYLETYPE();\
const STYLETYPE& STYLETYPE::STYLENAME() {\
	static const STYLETYPE s = Make__##STYLENAME##___##STYLETYPE(); \
	return s;\
}\
STYLETYPE Make__##STYLENAME##___##STYLETYPE()


MAKE_STYLE_METH( StdGridAxisDrawECtrl_GEStyle, StyleDefault) {
	StdGridAxisDrawECtrl_GEStyle s;

	// GED
	s.lmntBackgnd = Null;
	s.axisWidth     = 2;
	s.axisColor     = SBlue();
	s.axisTextFont  = StdFont();
	s.axisTextColor = SColorText();
	s.axisTickColor = SColorText();
	s.gridColor     = SGray();
	s.primaryTickFactory    << []() ->TickMark* { TickMark* t = new LineTickMark();  t->SetTickLength(3); return t; };
	s.secondaryTickFactory  << []() ->TickMark* { TickMark* t = new LineTickMark();  t->SetTickLength(1); return t; };

	// GEC
	s.vSelectStyle     = GraphCtrlImg::VSELECT();
	s.vAxisSelectStyle = GraphCtrlImg::VAXISSELECT();
	s.hSelectStyle     = GraphCtrlImg::HSELECT();
	s.hAxisSelectStyle = GraphCtrlImg::HAXISSELECT();
	return s;
}

MAKE_STYLE_METH( StdGridAxisDrawECtrl_GEStyle, StyleDefault2) {
	StdGridAxisDrawECtrl_GEStyle s;

	// GED
	s.lmntBackgnd = Null;
	s.axisWidth     = 2;
	s.axisColor     = SBlue();
	s.axisTextFont  = StdFont();
	s.axisTextColor = SRed();
	s.axisTickColor = SRed();
	s.gridColor     = Null;
	s.primaryTickFactory    << []() ->TickMark* { TickMark* t = new LineTickMark();  t->SetTickLength(3); return t; };
	s.secondaryTickFactory  << []() ->TickMark* { TickMark* t = new LineTickMark();  t->SetTickLength(1); return t; };

	// GEC
	s.vSelectStyle     = GraphCtrlImg::VSELECT();
	s.vAxisSelectStyle = GraphCtrlImg::VAXISSELECT();
	s.hSelectStyle     = GraphCtrlImg::HSELECT();
	s.hAxisSelectStyle = GraphCtrlImg::HAXISSELECT();
	return s;
}




}; // namespace GraphDraw_ns
}; // namespace Upp
