
//  original value
//============== TIMING STATS ==================
//paint() > Max=1329.746841ms   Min=2.867295ms   Average=965.929757238096ms   ( count:21 )   Current=2.867295ms
//paintBckGnd() > Max=2.466571ms   Min=0.804033ms   Average=1.0768489047619ms   ( count:21 )   Current=1.135828ms
//initBackGndPaint() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_chPaint() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_copyImage() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_paintImage() > Max=2.463987ms   Min=0.801239ms   Average=1.07378280952381ms   ( count:21 )   Current=1.132406ms
//fastPaintPlotDataTiming() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//fullPaintPlotDataTiming() > Max=1324.265968ms   Min=870.768265ms   Average=1008.8922327ms   ( count:20 )   Current=989.617592ms
//paintPlotDataGlobalTiming() > Max=1328.003781ms   Min=0.879945ms   Average=964.145892238095ms   ( count:21 )   Current=0.879945ms
//===============================================

//============== TIMING STATS ==================
//paint() > Max=1287.478781ms   Min=896.161725ms   Average=999.55251925ms   ( count:20 )   Current=948.067743ms
//paintBckGnd() > Max=2.476068ms   Min=0.808223ms   Average=1.00738025ms   ( count:20 )   Current=0.81807ms
//initBackGndPaint() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_chPaint() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_copyImage() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_paintImage() > Max=2.473275ms   Min=0.80543ms   Average=1.0031307ms   ( count:20 )   Current=0.815136ms
//fastPaintPlotDataTiming() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//fullPaintPlotDataTiming() > Max=1282.787416ms   Min=891.61555ms   Average=994.51122855ms   ( count:20 )   Current=943.572829ms
//paintPlotDataGlobalTiming() > Max=1285.935804ms   Min=894.718615ms   Average=997.78401765ms   ( count:20 )   Current=946.619186ms
//===============================================

// Current value
//============== TIMING STATS ==================
//paint() > Max=976.663341ms   Min=894.470825ms   Average=917.40618125ms   ( count:20 )   Current=956.964307ms
//paintBckGnd() > Max=1.031282ms   Min=0.817511ms   Average=0.8992827ms   ( count:20 )   Current=1.01047ms
//initBackGndPaint() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_chPaint() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_copyImage() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_paintImage() > Max=1.028139ms   Min=0.814927ms   Average=0.89634975ms   ( count:20 )   Current=1.006978ms
//fastPaintPlotDataTiming() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//fullPaintPlotDataTiming() > Max=971.537382ms   Min=889.978357ms   Average=912.74580075ms   ( count:20 )   Current=951.944571ms
//paintPlotDataGlobalTiming() > Max=974.996264ms   Min=893.002016ms   Average=915.88122265ms   ( count:20 )   Current=955.299395ms
//===============================================

//
//============== TIMING STATS ==================
//paint() > Max=1265.325814ms   Min=3.000614ms   Average=931.440110238095ms   ( count:21 )   Current=3.000614ms
//paintBckGnd() > Max=2.388424ms   Min=0.831199ms   Average=1.12552538095238ms   ( count:21 )   Current=1.278086ms
//initBackGndPaint() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_chPaint() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_copyImage() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_paintImage() > Max=2.38556ms   Min=0.827777ms   Average=1.12227957142857ms   ( count:21 )   Current=1.274454ms
//_preparePaintPlotPointsListTiming() > Max=9.906021ms   Min=6.495603ms   Average=7.9167766ms   ( count:40 )   Current=6.563835ms
//_fullPaintPlotDataTiming() > Max=653.193082ms   Min=431.75795ms   Average=478.301954425ms   ( count:40 )   Current=434.420902ms
//fastPaintPlotDataTiming() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//totalFullPaintPlotDataTiming() > Max=1258.949421ms   Min=879.674143ms   Average=972.63936075ms   ( count:20 )   Current=934.165812ms
//paintPlotDataGlobalTiming() > Max=1263.040121ms   Min=0.888675ms   Average=929.621419904762ms   ( count:21 )   Current=0.888675ms
//===============================================

//============== TIMING STATS ==================
//paint() > Max=985.044567ms   Min=2.585503ms   Average=79.9070829047619ms   ( count:42 )   Current=14.78064ms
//paintBckGnd() > Max=136.421719ms   Min=0.79223ms   Average=5.52855507142857ms   ( count:42 )   Current=7.414448ms
//initBackGndPaint() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_chPaint() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_copyImage() > Max=0ms   Min=1e21ms   Average=?ms   ( count:0 )   Current=0ms
//paintBackGndTiming_paintImage() > Max=10.123214ms   Min=0.789158ms   Average=1.41763347619048ms   ( count:42 )   Current=7.411516ms
//_preparePaintPlotPointsListTiming() > Max=11.063079ms   Min=6.711261ms   Average=8.1327915ms   ( count:6 )   Current=6.711261ms
//_fullPaintPlotDataTiming() > Max=476.838408ms   Min=388.679044ms   Average=425.5401815ms   ( count:6 )   Current=399.362978ms
//fastPaintPlotDataTiming() > Max=11.57729ms   Min=7.301243ms   Average=9.52202679411765ms   ( count:34 )   Current=10.800004ms
//totalFullPaintPlotDataTiming() > Max=929.909418ms   Min=801.78314ms   Average=867.534436ms   ( count:3 )   Current=801.78314ms
//paintPlotDataGlobalTiming() > Max=933.405315ms   Min=0.798586ms   Average=73.4578389047619ms   ( count:42 )   Current=5.895565ms
//===============================================
//

#include "GraphCtrl_Demo.h"

namespace Upp {
	#define IMAGECLASS GraphCtrl_DemoImg
	#define IMAGEFILE <GraphCtrl_Demo/GraphCtrl_Demo.iml>
	#include <Draw/iml_source.h>
}

using namespace Upp::GraphDraw_ns;

namespace Upp {


class ExclusionAreaDraw : public GraphElement
{
	private:
	CoordinateConverter& _xConverter;
	CoordinateConverter& _yConverter;
	typedef  GraphElement _B;

	public:
	typedef ExclusionAreaDraw   CLASSNAME;
	ExclusionAreaDraw(CoordinateConverter& xConv, CoordinateConverter& yConv) :  _xConverter(xConv), _yConverter(yConv) {};
	~ExclusionAreaDraw() {};


	virtual void PaintElement(Draw& dw, int scale) { /* do noting */}
	virtual void PaintOnPlot_underData(Draw& dw, int otherWidth, int scale)
	{
		int xMin = _xConverter.getScreenMin();
		int xMax = _xConverter.getScreenMax();
		int yMin = _yConverter.getScreenMin();
		int yMax = _yConverter.getScreenMax();
		int zXMin = _xConverter.toScreen(5);
		int zXMax = _xConverter.toScreen(7);
		int zYMin = _yConverter.toScreen(4);
		int zYMax = _yConverter.toScreen(8);


		Vector<Point> zone1;
		Vector<Point> zone2;
		zone1 << Point(xMin, zYMin) << Point(zXMin, zYMin) << Point(zXMin, yMax) << Point(xMin, yMax);
		zone2 << Point(xMax, zYMax) << Point(zXMax, zYMax) << Point(zXMax, yMin) << Point(xMax, yMin);
		dw.DrawPolygon(zone1, Color(148, 235, 242), 2, Black());
		dw.DrawPolygon(zone2, Color(250, 150, 150), 2, Black());
	}
};



Pointf opara1(double t) {return Pointf(0.5*cos(2*M_PI*t), 0.5*sin(2*M_PI*t));}

void para1(Pointf& xy, double t) {xy = Pointf(cos(2*M_PI*t), sin(2*M_PI*t));}
void para2(Pointf& xy, double t) {xy = Pointf(0.5*cos(6*M_PI*t)+3*t-1, 1.5+0.5*sin(6*M_PI*t));}
void para3(Pointf& xy, double t) {xy = Pointf(3+(0.5+t)*cos(6*M_PI*t), (0.5+t)*sin(6*M_PI*t));}
void para4(Pointf& xy, double t) {xy = Pointf(0, -0.25+0.5*t);}
void para5(Pointf& xy, double t) {xy = Pointf(-0.25+0.5*t, 0);}

void para1p(Pointf& xy, double t, double a, double b) 	{xy = Pointf(a*cos(2*M_PI*t),b*sin(2*M_PI*t));}
void para3p(Pointf& xy, double t, double a) 			{xy = Pointf(a+(0.5+t)*cos(6*M_PI*t),(0.5+t)*sin(6*M_PI*t));}


double funct1(double x)	{return 3;}
double funct2(double x)	{return (x*x-5);}
double funct3(double x)	{return (-x*x-5);}
void   vfunct1(double& y, double x) {y = 0;}
void   vfunct2(double& y, double x) {y = x*x;}
void   vfunct3(double& y, double x) {y = -x*x;}

void   vfunct1_(double& y, double x) {y = (x-1000100);}



void paraXY(Pointf& xy, double t) {xy = Pointf(0.5*cos(6*M_PI*t)+3*t-1, 1.5+0.5*sin(6*M_PI*t));}
double functx(double t)	{return (0.5*cos(6*M_PI*t)+3*t-1); }
double functy(double t)	{return (1.5+0.5*sin(6*M_PI*t) ); }



typedef DynamicMarkerECtrl< XYY2LT_GraphCtrl::Types >  MarkerElementType;
typedef DynamicMarkerCtrl_MarkerContains< XYY2LT_GraphCtrl::Types >  MarkerElementType2;

#define LINKED_MARKER_ID1 101
#define LINKED_MARKER_ID2 102
#define LINKED_MARKER_ID3 103

#define MARKER_X1_ID 125
#define MARKER_X2_ID 126
#define MARKER_Y1_ID 45000
#define MARKER_Y2_ID 1000


MarkerElementType& SetDynMarkerGraph(XY_GraphCtrl& g) {
	g.SetCtrlBackgroundStyle(GraphCtrl_DemoImg::CTRL_BACKGND() );
	g.GetX1CoordConverter().updateGraphSize(-5,5);
	g.GetY1CoordConverter().updateGraphSize(-20,20);

	MarkerElementType& markerElem = g.CreateElement1< MarkerElementType , TOP_OF_GRAPH>(30, -1, g.GetX1CoordConverter() );
	SmartTextTickMark& marker = markerElem.AddMarker(LINKED_MARKER_ID1, "\1[ [ [*0 Linked]]]" );
	marker.SetBackGroundStyle(GraphCtrl_DemoImg::MARKER_BACKGND());
	
	g.AddSeries(&funct1).PlotStyle<LineSeriesPlot>().Legend("3");
	g.AddSeries(&funct2).PlotStyle<LineSeriesPlot>().Legend("x*x-5");
	g.AddSeries(&vfunct3).PlotStyle<LineSeriesPlot>().Legend("y = -x*x");
	
	return markerElem;
}



void GraphCtrl_Demo::onXMarkerMoveCBK( const GraphDraw_ns::MarkerPosList& markers, int ID,  void* m) {
	if (ID >=0) { tabFullDemo.xMarkerPos.SetData(markers.Get(ID).GetPos()); }
}

void GraphCtrl_Demo::onXMarkerSelectCBK( const GraphDraw_ns::MarkerPosList& markers, int ID,  void* m) {
	//if (ID == MARKER_X1_ID)	{ tabFullDemo.xMarkerPos.SetStyle(markerActiveStyle); }
	tabFullDemo.xMarkerPos.SetStyle(markerActiveStyle);
}

void GraphCtrl_Demo::onXMarkerReleaseCBK( const GraphDraw_ns::MarkerPosList& markers, int ID,  void* m) {
	tabFullDemo.xMarkerPos.SetStyle(EditField::StyleDefault());
}

void GraphCtrl_Demo::onY1MarkerMoveCBK( const GraphDraw_ns::MarkerPosList& markers, int ID,  void* m) {
	if (ID >=0) { tabFullDemo.y1MarkerPos.SetData(markers.Get(ID).GetPos()); }
}

void GraphCtrl_Demo::onY2MarkerMoveCBK( const GraphDraw_ns::MarkerPosList& markers, int ID,  void* m) {
	if (ID >=0) { tabFullDemo.y2MarkerPos.SetData(markers.Get(ID).GetPos()); }
}


void GraphCtrl_Demo::onMarkerMoveCBK_tabDyn( const GraphDraw_ns::MarkerPosList& markers, int ID, void* elemnt )
{
	if (ID >=0) {
		tabDynMarker.markerPos.SetData(markers.Get(ID).GetPos());
	}
}

void GraphCtrl_Demo::DoDrawPerfTest() {
	tabBigData.graph.DoDataDrawPerfTest(20);
}

struct sChLook_LabelBox {
	Image img;
};

Value Make_ChLook_LabelBox(const Image& img)
{
	sChLook_LabelBox x;
	x.img = MakeButton(8, img, 2, Blue());
	return RawToValue(x);
}

Value ChLookFn_LabelBox(Draw& w, const Rect& r, const Value& v, int op, Color ink) {
	
	if( v.Is<sChLook_LabelBox>() )
	{
		const sChLook_LabelBox& e = v.To<sChLook_LabelBox>();
		ChPaint(w, r, e.img);
		return 1;
	}
	return Null;
}

INITBLOCK {
	ChLookFn(ChLookFn_LabelBox);
}



GraphCtrl_Demo::GraphCtrl_Demo()
{
	VALIDATE_IML(GraphCtrl_DemoImg);
	
//	GUI_GlobalStyle_Write(GUISTYLE_X);
	//LabelBox::SetLook(GraphCtrl_DemoImg::CTRL_BACKGND());
//	LabelBox::SetLook(White());
//	LabelBox::SetLook(WithHotSpots(MakeButton(8, GraphCtrl_DemoImg::CTRL_BACKGND(), 5, Blue()), DPI(8), DPI(8), 0, 0));
//	LabelBox::SetLook( MakeButton(4, GraphCtrl_DemoImg::CTRL_BACKGND(), 2, Null) );

	static const Value myLabelBoxLook = Make_ChLook_LabelBox(GraphCtrl_DemoImg::CTRL_BACKGND());
	LabelBox::SetLook( myLabelBoxLook );
	
	markerActiveStyle = EditField::StyleDefault();
	markerActiveStyle.disabled = Color(255, 255, 0);

	CtrlLayout(*this, "GraphCtrl DEMO");
	Sizeable();
	MinimizeBox();
	MaximizeBox();
	
	addAsTab(tabFullDemo, "Full Demo");
	addAsTab(tabChameleon, "Chameleon");
	addAsTab(tabOpenGL, "OpenGL");
	addAsTab(tabBigData, "BIG DATA SET");
	addAsTab(tabLogTimeScale, "LOG & TIME scale");
	addAsTab(tabDynMarker, "Dynamic Markers");
	addAsTab(tabLinkedGraphs, "Linked Graphs");
	addAsTab(tabScatterCompat, "ScatterDraw comptibility");
	addAsScatterTab(tabScatterCompat.tabBasic, "Basic");
	addAsScatterTab(tabScatterCompat.tabFunctions, "Functions");
	addAsScatterTab(tabScatterCompat.tabParam, "Parametric");
	addAsScatterTab(tabScatterCompat.tabTrendLines, "Trend Lines");
	XYLTM_GraphCtrl* g = &(tabChameleon.graph);
	tabChameleon.butStyle1 << [g]() ->void { GraphCtrl_Demo::SetStyle1(*g); };
	tabChameleon.butStyle2 << [g]() ->void { GraphCtrl_Demo::SetStyle2(*g); };
	tabChameleon.butStyle3 << [g]() ->void { GraphCtrl_Demo::SetStyle3(*g); };
	tabChameleon.butStyleDefault << [g]() ->void { GraphCtrl_Demo::SetStyleDefault(*g); };

	XYY2LT_GraphCtrl* g2 = &(tabFullDemo.graph);
	tabFullDemo.butStyle1 << [g2]() ->void { GraphCtrl_Demo::SetStyle1(*g2); };
	tabFullDemo.butStyle2 << [g2]() ->void { GraphCtrl_Demo::SetStyle2(*g2); };
	tabFullDemo.butStyle3 << [g2]() ->void { GraphCtrl_Demo::SetStyle3(*g2); };
	tabFullDemo.butStyleDefault << [g2]() ->void { GraphCtrl_Demo::SetStyleDefault(*g2); };
	
	Sizeable();
	
	
	// ====================================================
	// FULL DEMO
	// ====================================================
	{
		
//		Upp::GraphDraw_ns::CustomDataSource_WF customDataSource
		customDataSource[0].dateDebut=0;
		customDataSource[0].dateFin=100;
		customDataSource[0].priorite=0;
		
		customDataSource[1].dateDebut=10;
		customDataSource[1].dateFin=80;
		customDataSource[1].priorite=10;
		
		customDataSource[2].dateDebut=20;
		customDataSource[2].dateFin=110;
		customDataSource[2].priorite=20;
		
		customDataSource[3].dateDebut=25;
		customDataSource[3].dateFin=350;
		customDataSource[3].priorite=30;
		
		customDataSource[4].dateDebut=30;
		customDataSource[4].dateFin=130;
		customDataSource[4].priorite=40;
		
		customDataSource[5].dateDebut=40;
		customDataSource[5].dateFin=180;
		customDataSource[5].priorite=50;

		fullDemo_points << Pointf(0.5,1) << Pointf(1, 3.5)<< Pointf(2,1.8)<< Pointf(4, 3)<< Pointf(5.5, 2.5) << Pointf(6,7) << Pointf(7, 9)<< Pointf(8,10)<< Pointf(10, 15)<< Pointf(15, 15);
		fullDemo_points2 << Pointf(0,0) << Pointf(1, 2)<< Pointf(2,3)<< Pointf(4, 3)<< Pointf(5.5, 4) << Pointf(6,5) << Pointf(7, 6)<< Pointf(8,10)<< Pointf(10, 9)<< Pointf(15, 8);

		//g4.debugTrace = true;
		XYY2LT_GraphCtrl& g4 = tabFullDemo.graph;
		g4.AddCustomSeries( customDataSource );
		
		//g4.debugTrace = true;
		g4.CreateElement2<ExclusionAreaDraw, FLOAT_OVER_GRAPH>(0, 0, g4.GetX1CoordConverter(), g4.GetY1CoordConverter() );
		{
			//MarkerElementType& markerElem = g4.CreateElement1< AutoHideElementCtrl<MarkerElementType>, TOP_OF_GRAPH>(30, 1, g4.GetX1CoordConverter() );
			MarkerElementType2& markerGElem = g4.CreateElement1< MarkerElementType2, TOP_OF_GRAPH>(30, 1, g4.GetX1CoordConverter() );
			markerGElem.whenMarkerMove = THISBACK(onXMarkerMoveCBK);
			markerGElem.whenMarkerSelected = THISBACK(onXMarkerSelectCBK);
			markerGElem.whenMarkerReleased = THISBACK(onXMarkerReleaseCBK);
			
			
			markerGElem.AddMarker(MARKER_X1_ID, "\1[ [ [*@4;1  X1 ]]]", 3.5);
			markerGElem.AddMarker(MARKER_X2_ID, "\1[ [ [*@4;1  X2 ]]]", 7.0);
		}

		g4.GetY1GridAxisDraw();//.SetElementWidth(1);
		{
			MarkerElementType2& markerElem = g4.CreateElement1< MarkerElementType2, LEFT_OF_GRAPH>(30, g4.GetY1GridAxisDraw().GetStackingPriority()+1, g4.GetY1CoordConverter() );
			markerElem.SetOverlapPrevious(true);
			markerElem.whenMarkerMove = THISBACK(onY1MarkerMoveCBK);
			SmartTextTickMark& mark1 = markerElem.AddMarker(MARKER_Y1_ID, 8.5);
			mark1.SetText("\1[ [ [*@(0.0.255)1  Y1 ]]]");
		}
		
		{
			MarkerElementType2& markerElem = g4.CreateElement1< MarkerElementType2, RIGHT_OF_GRAPH>(40, -1, g4.GetY2CoordConverter() );
			markerElem.whenMarkerMove = THISBACK(onY2MarkerMoveCBK);
			markerElem.SetOverlapPrevious(true);
			SmartTextTickMark& mark1 = markerElem.AddMarker<SmartTextTickMark>(MARKER_Y2_ID, 8.5);
			mark1.SetText("\1[ [ [*@6;1  Y2 ]]]");
		}
	
		g4.AddSeries(fullDemo_points).PlotStyle<LineSeriesPlot>().MarkStyle<XMarkPlot>().MarkWidth(3).Legend("S1");//.Fill(Color(28, 255, 200)).Opacity(.5);
	
		g4.SetCurrentYConverter(1); // set Y2 as current Y axis
		g4.AddSeries(fullDemo_points2).PlotStyle<LineSeriesPlot>().NoMark().Legend("S2"); // tied to last X/Y  coordConverters ==> X / Y2
		g4.SetCtrlBackgroundStyle(GraphCtrl_DemoImg::CTRL_BACKGND3() );
		g4.SetPlotBackgroundStyle(GraphCtrl_DemoImg::PLOT_BACKGND2() );
		g4.GetLegendElement().SetBackGroundStyle(GraphCtrl_DemoImg::LEGEND_BACKGND3new());
		g4.GetLegendElement().SetElementWidth(28);
		//g4.GetYGridAxisDraw().SetBackGroundStyle(GraphCtrl_DemoImg::LEGEND_BACKGND4());
		//g4.GetY1GridAxisDraw().SetVSelectStyle(GraphCtrl_DemoImg::VSELECT());
		g4.FitToData();
		g4.Refresh();

	}
	// ====================================================
	// CHAMELEON
	// ====================================================
	{
		XYLTM_GraphCtrl& g = tabChameleon.graph;
		g.GetX1MarkersElement().AddMarker(1, "\1[ [ [*@(0.0.255)1  M1 ]]]", 1);
		g.GetX1MarkersElement().AddMarker(2, "\1[ [ [*@(0.0.255)1  M2 ]]]", 3);
	}
	
	// ====================================================
	// BIG DATA
	// ====================================================

	double y;
	const int NB_POINTS_G3 = 100000;
	for (int t = 0; t < NB_POINTS_G3; ++t) {
		y = 20.0*sin(2.0*M_PI*t/100000);
		// create a "cloud" of points around the main line
		s1 <<Pointf(t, y);
		s2 <<Pointf(t, y + (Upp::Randomf()*5.0)-2.5);
		s3 <<Pointf(t, y+10);
	}
	tabBigData.graph.SetCtrlBackgroundStyle(GraphCtrl_DemoImg::CTRL_BACKGND() );
	tabBigData.graph.GetLegendElement().SetBackGroundStyle( GraphCtrl_DemoImg::MARKER_BACKGND());
	tabBigData.graph.AddSeries(s3).SetSequential(false).MarkStyle<FastMarkPlot>().Legend("S3 NOT sequential");
	tabBigData.graph.AddSeries(s2).SetSequential(true).MarkStyle<FastMarkPlot>().Legend("S2 sequential");
	tabBigData.graph.AddSeries(s1).SetSequential(true).MarkStyle<FastMarkPlot>().Legend("S1 sequential");
	tabBigData.graph.FitToData();
	tabBigData.doPerfTest.WhenPush << THISBACK(DoDrawPerfTest);
	MarkerElementType& tabBigData_markerElem_1 = tabBigData.graph.CreateElement1< AutoHideElementCtrl<MarkerElementType>, TOP_OF_GRAPH>(30, -1, tabBigData.graph.GetX1CoordConverter() );
	{	
		MarkerElementType& markerElem = tabBigData_markerElem_1;
		markerElem.SetBackGroundStyle(GraphCtrl_DemoImg::LEGEND_BACKGND());
		SmartTextTickMark* marker;

		marker = &markerElem.AddMarker<SmartTextTickMark>(LINKED_MARKER_ID1);
		marker->SetText("\1[ [ [*0 Linked]]]");
		marker->SetBackGroundStyle(GraphCtrl_DemoImg::MARKER_BACKGND());

		marker = &markerElem.AddMarker<SmartTextTickMark>(LINKED_MARKER_ID3);
		marker->SetText("\1[ [ [*0 Not Linked]]]");
		marker->SetBackGroundStyle(GraphCtrl_DemoImg::MARKER_BACKGND());
	}

	tabBigData.graph.debugTraceTimings = true;


	// ====================================================
	// LOG  &  TIME SCALE
	// ====================================================
	
	tabLogTimeScale.graph.SetCtrlBackgroundStyle(GraphCtrl_DemoImg::CTRL_BACKGND() );
	tabLogTimeScale.graph.GetY1GridAxisDraw().SetBackGroundStyle( GraphCtrl_DemoImg::HeatGradient_1());
	tabLogTimeScale.graph.GetLegendElement().SetBackGroundStyle( GraphCtrl_DemoImg::LEGEND_BACKGND());
	tabLogTimeScale.graph.AddSeries(&vfunct1_).PlotStyle<LineSeriesPlot>().Fill(Color(28, 255, 200)).Opacity(.4).Legend("y = (x-1000100)");
	tabLogTimeScale.graph.SetYMin(0.000001).SetYMax(720);
	tabLogTimeScale.graph.SetXMin(1000098.643); //GetSysTime().Get());
	tabLogTimeScale.graph.SetXMax(1000107.684); //GetSysTime().Get() + 60*60*24*90);
	
	// ====================================================
	// SCATTER CTRL COMPAT : BASIC
	// ====================================================
	{
		#define SERIE2 2
		scatterBasic_s1 << Pointf(10, 26) << Pointf(20, 37) << Pointf(30, 31) << Pointf(40, 33) << Pointf(50, 28);
		tabScatterCompat.tabBasic.graph.AddSeries(scatterBasic_s1).Legend("Series 1").PlotStyle<LineSeriesPlot>().Opacity(0.3).Fill();
		
		scatterBasic_s2y[0] = 22; scatterBasic_s2y[1] = 33; scatterBasic_s2y[2] = 27; scatterBasic_s2y[3] = 29; scatterBasic_s2y[4] = 24;
		tabScatterCompat.tabBasic.graph.AddSeries(scatterBasic_s2y, 5, 10, 10).Legend("Series 2").Id(SERIE2).PlotStyle<LineSeriesPlot>()
						.Dash("").MarkColor(Red()).Fill().Opacity(0.5);
		
		scatterBasic_s3y[0] = 18; scatterBasic_s3y[1] = 29; scatterBasic_s3y[2] = 23; scatterBasic_s3y[3] = 25; scatterBasic_s3y[4] = 20;
		scatterBasic_s3x[0] = 10; scatterBasic_s3x[1] = 20; scatterBasic_s3x[2] = 30; scatterBasic_s3x[3] = 40; scatterBasic_s3x[4] = 50;
		tabScatterCompat.tabBasic.graph.AddSeries(scatterBasic_s3x, scatterBasic_s3y, 5).Legend("Series 3").PlotStyle<LineSeriesPlot>();
		
		scatterBasic_s4y << 14 << 25 << 19 << 21 << 16;
		scatterBasic_s4x << 10 << 20 << 30 << 40 << 50;
		tabScatterCompat.tabBasic.graph.AddSeries(scatterBasic_s4x, scatterBasic_s4y).Legend("Series 4").PlotStyle<StaggeredSeriesPlot>().Dash("").NoMark().Fill().Stroke(3, LtRed());
		
		scatterBasic_s5.Add(10, 10);
		scatterBasic_s5.Add(20, 21);
		scatterBasic_s5.Add(30, 15);
		scatterBasic_s5.Add(40, 16);
		scatterBasic_s5.Add(50, 12);
		tabScatterCompat.tabBasic.graph.AddSeries(scatterBasic_s5).Legend("Series 5").PlotStyle<BarSeriesPlot>().Dash("").NoMark().Fill();
		tabScatterCompat.tabBasic.graph.setGraphSize(0,60,0,50);
	}

	// ====================================================
	// SCATTER CTRL COMPAT : FUNCTIONS
	// ====================================================
	
	tabScatterCompat.tabFunctions.graph.AddSeries(&funct1).PlotStyle<LineSeriesPlot>().Legend("0");
	tabScatterCompat.tabFunctions.graph.AddSeries(&funct2).PlotStyle<LineSeriesPlot>().Legend("x*x-5");
	tabScatterCompat.tabFunctions.graph.AddSeries(&funct3).PlotStyle<LineSeriesPlot>().Legend("-x*x-5");
	tabScatterCompat.tabFunctions.graph.AddSeries(&vfunct1).PlotStyle<LineSeriesPlot>().Legend("y = 0");
	tabScatterCompat.tabFunctions.graph.AddSeries(&vfunct2).PlotStyle<LineSeriesPlot>().Legend("y = x*x");
	tabScatterCompat.tabFunctions.graph.AddSeries(&vfunct3).PlotStyle<LineSeriesPlot>().Legend("y = -x*x");
	
	// ====================================================
	// SCATTER CTRL COMPAT : PARAMETER
	// ====================================================
	
	tabScatterCompat.tabParam.graph.AddSeries(&opara1, 20).Legend("Circle 1").NoMark().PlotStyle<LineSeriesPlot>();
	tabScatterCompat.tabParam.graph.AddSeries(STDBACK(para1), 100).Legend("Circle 2").NoMark().PlotStyle<LineSeriesPlot>();
	tabScatterCompat.tabParam.graph.AddSeries(STDBACK(para2), 100).Legend("Coil").NoMark().PlotStyle<LineSeriesPlot>().Fill(Color(28, 255, 255)).Opacity(.3);
	tabScatterCompat.tabParam.graph.AddSeries(STDBACK(para3), 150).Legend("Spiral 1").NoMark().PlotStyle<LineSeriesPlot>().Fill(Color(0, 0, 0)).Opacity(.2);
	tabScatterCompat.tabParam.graph.AddSeries(STDBACK1(para3p, 2.5), 150, 0, 1).Legend("Spiral 2").NoMark().PlotStyle<LineSeriesPlot>();
	tabScatterCompat.tabParam.graph.AddSeries(STDBACK(para4), 2).Legend("VLine").NoMark().PlotStyle<LineSeriesPlot>();
	tabScatterCompat.tabParam.graph.AddSeries(STDBACK(para5), 2).Legend("HLine").NoMark().PlotStyle<LineSeriesPlot>();
	tabScatterCompat.tabParam.graph.AddSeries(STDBACK2(para1p, 4.0, 0.25), 50, 0, 1).Legend("Ellipse 1").NoMark().PlotStyle<LineSeriesPlot>().Fill(Color(113, 42, 0)).Opacity(.2);
	tabScatterCompat.tabParam.graph.AddSeries(STDBACK2(para1p, 2.0, 0.5), 50, 0, 1).Legend("Ellipse 2").NoMark().PlotStyle<LineSeriesPlot>();

	// ====================================================
	// SCATTER CTRL COMPAT : TREND LINES
	// ====================================================
	
	trendLine_s1x << -3.067E0 << -2.981E0 << -2.921E0 << -2.912E0 << -2.840E0 << -2.797E0 << -2.702E0 << -2.699E0 << -2.633E0 << -2.481E0 << -2.363E0  << -2.322E0  << -1.501E0  << -1.460E0  << -1.274E0  << -1.212E0  << -1.100E0  << -1.046E0 << -0.915E0 << -0.714E0 << -0.566E0 << -0.545E0 << -0.400E0 << -0.309E0 << -0.109E0 << -0.103E0 << 0.010E0 << 0.119E0 << 0.377E0 << 0.790E0 << 0.963E0 << 1.006E0 << 1.115E0 << 1.572E0 << 1.841E0 << 2.047E0 << 2.200E0;
	trendLine_s1y << 80.574E0 << 84.248E0 << 87.264E0 << 87.195E0 << 89.076E0 << 89.608E0 << 89.868E0 << 90.101E0 << 92.405E0 << 95.854E0 << 100.696E0 << 101.060E0 << 401.672E0 << 390.724E0 << 567.534E0 << 635.316E0 << 733.054E0 << 759.087E0 << 894.206E0 << 990.785E0 << 1090.109E0 << 1080.914E0 << 1122.643E0 << 1178.351E0 << 1260.531E0 << 1273.514E0 << 1288.339E0 << 1327.543E0 << 1353.863E0 << 1414.509E0 << 1425.208E0 << 1421.384E0 << 1442.962E0 << 1464.350E0 << 1468.705E0 << 1447.894E0 << 1457.628E0;		
	{
		double l_r2, p2_r2, p4_r2, f_r2, exp_r2, rat1_r2;
		VectorDouble vs1(trendLine_s1y, trendLine_s1x);
		linear.Fit(vs1, l_r2);
		poly2.SetDegree(2);
		poly2.Fit(vs1, p2_r2);
		poly4.SetDegree(4);
		poly4.Fit(vs1, p4_r2);
		fourier.SetDegree(3);
		fourier.Fit(vs1, f_r2);
		exponential.Fit(vs1, exp_r2);
		rational1.Fit(vs1, rat1_r2);
	}
	
	tabScatterCompat.tabTrendLines.graph.AddSeries(trendLine_s1x, trendLine_s1y).Legend("Series 1").MarkStyle<RhombMarkPlot>().MarkWidth(10).NoPlot();
	tabScatterCompat.tabTrendLines.graph.AddSeries(linear).Legend(linear.GetFullName()).NoMark().Stroke(2).PlotStyle<LineSeriesPlot>();
	tabScatterCompat.tabTrendLines.graph.AddSeries(poly2).Legend(poly2.GetFullName()).NoMark().Stroke(2).PlotStyle<LineSeriesPlot>();
	tabScatterCompat.tabTrendLines.graph.AddSeries(poly4).Legend(poly4.GetFullName()).NoMark().Stroke(2).PlotStyle<LineSeriesPlot>();
	tabScatterCompat.tabTrendLines.graph.AddSeries(fourier).Legend(fourier.GetFullName()).NoMark().Stroke(2).PlotStyle<LineSeriesPlot>();
	tabScatterCompat.tabTrendLines.graph.AddSeries(exponential).Legend(exponential.GetFullName()).NoMark().Stroke(2).PlotStyle<LineSeriesPlot>();
	tabScatterCompat.tabTrendLines.graph.AddSeries(rational1).Legend(rational1.GetFullName()).NoMark().Stroke(2).PlotStyle<LineSeriesPlot>();
	tabScatterCompat.tabTrendLines.graph.FitToData();

	// ====================================================
	// DYNAMIC MARKER
	// ====================================================
	
	MarkerElementType& g1MarkerElem = SetDynMarkerGraph(tabDynMarker.g1);
	g1MarkerElem.whenMarkerMove = THISBACK(onMarkerMoveCBK_tabDyn);
	MarkerElementType& g2MarkerElem = SetDynMarkerGraph(tabDynMarker.g2);
	MarkerElementType& g3MarkerElem = SetDynMarkerGraph(tabDynMarker.g3);
//	MarkerElementType& g4MarkerElem = SetDynMarkerGraph(tabDynMarker.g4);
//	MarkerElementType& g5MarkerElem = SetDynMarkerGraph(tabDynMarker.g5);
	
	g1MarkerElem.Link(LINKED_MARKER_ID1, g2MarkerElem, LINKED_MARKER_ID1 );
	g2MarkerElem.Link(LINKED_MARKER_ID1, g3MarkerElem, LINKED_MARKER_ID1 );
//	g3MarkerElem.Link(LINKED_MARKER_ID1, g4MarkerElem, LINKED_MARKER_ID1 );
//	g4MarkerElem.Link(LINKED_MARKER_ID1, g5MarkerElem, LINKED_MARKER_ID1 );
//	g5MarkerElem.Link(LINKED_MARKER_ID1, g1MarkerElem, LINKED_MARKER_ID1 );
	
	{
		XYLT_GraphCtrl& g5 = tabDynMarker.g5;
		MarkerElementType& markerElemG5_1 = g5.CreateElement1< MarkerElementType, TOP_OF_GRAPH >(30, 0, g5.GetX1CoordConverter() );
		markerElemG5_1.AddMarker<SmartTextTickMark>(1, 3.8).SetText("\1[ [ [*_@6$(28.255.150)+59 M1]]]");
		
		MarkerElementType& markerElemG5_2 = g5.CreateElement1< MarkerElementType, RIGHT_OF_GRAPH >(40, 0, g5.GetY1CoordConverter() );
		markerElemG5_2.AddMarker<SmartTextTickMark>(2, 3.8).SetText("\1[ [ [*_@6$(28.255.150)+59 M2]]]");
		
		MarkerElementType& markerElemG5_3 = g5.CreateElement1< MarkerElementType, BOTTOM_OF_GRAPH >(30, 0, g5.GetX1CoordConverter() );
		SmartTextTickMark& sttm = markerElemG5_3.AddMarker<SmartTextTickMark>(3, 3.8);
			sttm.SetText("\1[ [ [@6$(255.255.192)2 `-`-][*_$(255.255.192)2 M3][@6$(255.255.192)2 `-`-]]]");
			sttm.SetBackGroundStyle(GraphCtrl_DemoImg::BACKGND());
		
		MarkerElementType& markerElemG5_4 = g5.CreateElement1< MarkerElementType, LEFT_OF_GRAPH >(40, 0, g5.GetY1CoordConverter() );
		SmartTextTickMark& sttm4 = markerElemG5_4.AddMarker<SmartTextTickMark>(4, 3.8);
			sttm4.SetText("---M4---");
			sttm4.SetBackGroundStyle(GraphCtrl_DemoImg::BACKGND());
	}

	{
		XYLT_GraphCtrl& g4 = tabDynMarker.g4;
			//MarkerElementType& markerElem = g4.CreateElement1< AutoHideElementCtrl<MarkerElementType>, TOP_OF_GRAPH>(30, 1, g4.GetX1CoordConverter() );
		MarkerElementType& markerElemG5_1 = g4.CreateElement1< AutoHideElementCtrl<MarkerElementType>, TOP_OF_GRAPH >(30, -1, g4.GetX1CoordConverter() );
		markerElemG5_1.SetBackGroundStyle(GraphCtrl_DemoImg::LEGEND_BACKGND4());
		markerElemG5_1.AddMarker<SmartTextTickMark>(1, 3.8).SetText("\1[ [ [*_@6$(28.255.150)+59 M1]]]");
		
		MarkerElementType& markerElemG5_2 = g4.CreateElement1< AutoHideElementCtrl<MarkerElementType>, RIGHT_OF_GRAPH >(40, -1, g4.GetY1CoordConverter() );
		markerElemG5_2.SetBackGroundStyle(GraphCtrl_DemoImg::LEGEND_BACKGND4());
		markerElemG5_2.AddMarker<SmartTextTickMark>(2, 3.8).SetText("\1[ [ [*_@6$(28.255.150)+59 M2]]]");
		
		MarkerElementType& markerElemG5_3 = g4.CreateElement1< AutoHideElementCtrl<MarkerElementType>, BOTTOM_OF_GRAPH >(30, -1, g4.GetX1CoordConverter() );
		markerElemG5_3.SetBackGroundStyle(GraphCtrl_DemoImg::LEGEND_BACKGND4());
		SmartTextTickMark& sttm = markerElemG5_3.AddMarker<SmartTextTickMark>(3, 3.8);
			sttm.SetText("\1[ [ [@6$(255.255.192)2 `-`-][*_$(255.255.192)2 M3][@6$(255.255.192)2 `-`-]]]");
			sttm.SetBackGroundStyle(GraphCtrl_DemoImg::BACKGND());
		
		MarkerElementType& markerElemG5_4 = g4.CreateElement1< AutoHideElementCtrl<MarkerElementType>, LEFT_OF_GRAPH >(40, -1, g4.GetY1CoordConverter() );
		markerElemG5_4.SetBackGroundStyle(GraphCtrl_DemoImg::LEGEND_BACKGND4());
		SmartTextTickMark& sttm4 = markerElemG5_4.AddMarker<SmartTextTickMark>(4, 3.8);
			sttm4.SetText("---M4---");
			sttm4.SetBackGroundStyle(GraphCtrl_DemoImg::BACKGND());
	}

	// ====================================================
	// LINKED GRAPHS
	// ====================================================
	#define T_MIN 0
	#define T_MAX 10
	tabLinkedGraphs.gxy.AddSeries(STDBACK(paraXY), 10000, T_MIN, T_MAX).Legend("Coil").NoMark().PlotStyle<LineSeriesPlot>();//.Fill(Color(28, 255, 255)).Opacity(.3);
	tabLinkedGraphs.gx.AddSeries(&functx).Legend("X(t) Coil").NoMark().PlotStyle<LineSeriesPlot>();//.Fill(Color(28, 255, 255)).Opacity(.3);
	tabLinkedGraphs.gy.AddSeries(&functy).Legend("Y(t) Coil").NoMark().PlotStyle<LineSeriesPlot>();//.Fill(Color(28, 255, 255)).Opacity(.3);
	tabLinkedGraphs.gx2.AddSeries(&functx).Legend("X(t) Coil").NoMark().PlotStyle<LineSeriesPlot>();//.Fill(Color(28, 255, 255)).Opacity(.3);
	tabLinkedGraphs.gy2.AddSeries(&functy).Legend("Y(t) Coil").NoMark().PlotStyle<LineSeriesPlot>();//.Fill(Color(28, 255, 255)).Opacity(.3);

	tabLinkedGraphs.gxy.SetCtrlBackgroundStyle(GraphCtrl_DemoImg::CTRL_BACKGND() );
	//tabLinkedGraphs.gx.SetCtrlBackgroundStyle(GraphCtrl_DemoImg::CTRL_BACKGND() );
	//tabLinkedGraphs.gy.SetCtrlBackgroundStyle(GraphCtrl_DemoImg::CTRL_BACKGND() );

	tabLinkedGraphs.gxy.Link( tabLinkedGraphs.gxy.GetX1CoordConverter(), tabLinkedGraphs.gx.GetY1CoordConverter());
	tabLinkedGraphs.gxy.Link( tabLinkedGraphs.gxy.GetY1CoordConverter(), tabLinkedGraphs.gy.GetY1CoordConverter());
	tabLinkedGraphs.gx.Link( tabLinkedGraphs.gx.GetX1CoordConverter(), tabLinkedGraphs.gy.GetX1CoordConverter());

	tabLinkedGraphs.gx2.Link( tabLinkedGraphs.gx2.GetX1CoordConverter(), tabLinkedGraphs.gx.GetX1CoordConverter());
	tabLinkedGraphs.gx2.Link( tabLinkedGraphs.gx2.GetY1CoordConverter(), tabLinkedGraphs.gx.GetY1CoordConverter());

	tabLinkedGraphs.gy2.Link( tabLinkedGraphs.gy2.GetX1CoordConverter(), tabLinkedGraphs.gy.GetX1CoordConverter());
	tabLinkedGraphs.gy2.Link( tabLinkedGraphs.gy2.GetY1CoordConverter(), tabLinkedGraphs.gy.GetY1CoordConverter());
	
	// Set limits and default range for each type of axis (once per type)
	tabLinkedGraphs.gx.SetXMin(3).SetXMinRangeLimit(T_MIN).SetXMax(7).SetXMaxRangeLimit(T_MAX);
	tabLinkedGraphs.gxy.SetXMin(0).SetXMinRangeLimit(-10).SetXMax(30).SetXMaxRangeLimit(40);
	tabLinkedGraphs.gxy.SetYMin(1).SetYMinRangeLimit(0).SetYMax(3).SetYMaxRangeLimit(4);

	// propagate axis config to all other axis !!
	tabLinkedGraphs.gxy.ForceUpdateAllLinks( LINK_UPDATE_RANGE_LIMITS );
	tabLinkedGraphs.gx.ForceUpdateAllLinks( LINK_UPDATE_RANGE_LIMITS );
}


// ============================================================================================
// ============================================================================================
void GLGraphCtrl::GLPaint() {
	StdView();

	double t = 13 * point.x;
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glLoadIdentity();
	glPushMatrix();
		glTranslatef(0, 0, -6);
		glRotated(t / 30.0, 0, 1, 0);
		glRotated(t / 40.0, 1, 0, 0);
		glRotated(t / 5.0, 0, 0, 1);
		glBegin(GL_TRIANGLE_FAN);
			glColor4d(0.8, 0.4, 0.2, 1);
			glVertex3f(0.0f, 0.0f, 0.0f);
			for(int i = 0; i < 50; i++) {
				double u = M_2PI * i / 49;
				glColor4d(i / 50.0, 0.5 + i / 100.0, 0.7 - i / 150.0, 1);
				glVertex3d(sin(u), cos(u), 1.0f);
			}
		glEnd();
		glBegin(GL_TRIANGLE_FAN);
			glColor4d(0.8, 0.4, 0.2, 1);
			glVertex3f(0.0f, 0.0f, 3.0f);
			for(int i = 0; i < 50; i++) {
				double u = M_2PI * i / 49;
				glColor4d(0.7, 0.5 - i / 100.0, 0.7 + i / 150.0, 1);
				glVertex3d(sin(u), cos(u), 1.0f);
			}
		glEnd();
	glPopMatrix();
	t = 13 * point.y;
	float sn = (float)sin(t / 300);
	float cs = (float)cos(t / 300);
	glTranslatef(sn + cs, sn, -6 - cs);
	glRotated(t / 12.0, 0, 0, 1);
	glRotated(t / 15.0, 0, 1, 0);
	glRotated(t / 17.0, 1, 0, 0);
	glBegin(GL_TRIANGLE_STRIP);
		glVertex3f(0.0f, 0.0f, 0.0f);
		glColor4d(1, 0, 0, 0.5);
		glVertex3d(-1, 0, 0);
		glVertex3d(1, 0, 0);
		glVertex3d(0, 0.87, 0);
		glColor4d(0, 1, 0, 0.5);
		glVertex3d(0, 0, 1.67);
	glEnd();
}

void GLGraphCtrl::GLResize(int w, int h) {
	glViewport(0, 0, (GLsizei)w, (GLsizei)h);
}

void GLGraphCtrl::MouseMove(Point p, dword) {
	point = p;
	Refresh();
}

};