#ifndef _GanttCtrl_GanttGridAxisDraw_h_
#define _GanttCtrl_GanttGridAxisDraw_h_


class GanttGridAxisDraw : public GridAxisDraw {
	public:
		typedef GridAxisDraw  _B;
		typedef GanttGridAxisDraw  CLASSNAME;
		
	protected:
		int gridThick;
		
	public:
		GanttGridAxisDraw(CoordinateConverter& coordConv)
		: GridAxisDraw(coordConv)
		, gridThick(10)
		{
			RLOGBLOCK("GanttGridAxisDraw::GanttGridAxisDraw()");
			SetGanttGridSteps();
		}

		virtual ~GanttGridAxisDraw() {}

		void SetGanttGridSteps() {
			setAxisTextFormat(THISBACK(FormatAsDateCbk));
			GetGridStepManager().setCustomGridSteps( THISBACK(GanttGridStepCalcCbk) );
		}
		
//		virtual void PrePaint( int scale ) {}
//		virtual void PaintAxisBottom(Draw& dw, const int scale)	{}

		virtual void PaintAxisTop(Draw& dw, const int scale, const_GridStepIterator iter, const_GridStepIterator endIter)
		{
			Font scaledAxisTextFont( style->axisTextFont );
			if (scale>1) scaledAxisTextFont.Height(scale*scaledAxisTextFont.GetHeight());
			dw.DrawLineOp(_coordConverter.getScreenMin(), _B::GetElementWidth()*scale, _coordConverter.getScreenMax(), _B::GetElementWidth()*scale, style->axisWidth*scale, style->axisColor );
			while ( iter != endIter)
			{
				if (iter->tickLevel >= NB_TICKMARKS || _tickMarks[iter->tickLevel].IsEmpty()) {
					PaintTickText<TOP_OF_GRAPH>(dw, iter, iter, (_B::GetElementWidth()-4)*scale, style->axisTextColor, scaledAxisTextFont, scale);
				} else {
					_tickMarks[iter->tickLevel]->Paint(dw, TOP_OF_GRAPH, scale, iter, _B::GetElementWidth()*scale, style->axisTickColor );
					PaintTickText<TOP_OF_GRAPH>(dw, iter, iter, (_B::GetElementWidth()-_tickMarks[0]->GetTickLength()-2)*scale, style->axisTextColor, scaledAxisTextFont, scale);
				}
				
				if (iter->tickLevel == 0) {
					const TypeScreenCoord x = iter + gridThick*scale/2;
					dw.DrawLineOp( x, 0, x, _B::GetElementWidth()*scale, 1, SBlack() );
				}
				++iter;
			}
		}

		virtual void PaintHGrid(Draw& dw, int yRange, const_GridStepIterator iter, const_GridStepIterator endIter) // draw grid of horizontal axis
		{
			if ( !style->gridColor.IsNullInstance())
			{
				while( iter != endIter)
				{
					if (iter->tickLevel <= 1 )	{
						dw.DrawLineOp( iter, 0, iter, yRange, gridThick, style->gridColor );
//						dw.DrawRect( iter, 0, gridThick, yRange, style->gridColor );
					}
					++iter;
				}
			}
		}


		void FormatAsDateCbk( const const_GridStepIterator& iter, String& output ) {
			static const char* dayChar[7] = { "Su", "Mo", "Tu", "We", "Th", "Fr", "Sa" };
			if (iter->drawTickText) {
				Date d;
				d.Set(int(iter->stepGraphValue));
				output = dayChar[ DayOfWeek(d) ];
				//int y;	output << "\1[1* " << d.year << " ][1 S" << GetWeek(d, y) << "]";
			}
		}

		void GanttGridStepCalcCbk(GridStepManager& gridStepManager, CoordinateConverter& coordConv) {
			Date graphStartDate; graphStartDate.Set((int)coordConv.getGraphMin());
			Date graphEndDate;   graphEndDate.Set((int)coordConv.getGraphMax());
			GridStepData* gridStepData = gridStepManager.GetGridStepData();
	
			gridThick = Upp::max(1, coordConv.toScreen((graphStartDate+1).Get()) - coordConv.toScreen(graphStartDate.Get()) - 1);
			
			int c=0;
			for (Date d=graphStartDate+1; ( (d<=(graphEndDate+1)) && (c<GridStepManager::NB_MAX_STEPS)); ++d)
			{
				int dw = DayOfWeek(d);
				if ( (dw==0) || (dw==6) ) {
					if (dw==0) {
						gridStepData[c].drawTickText = 1;
						gridStepData[c].tickLevel = 0;
					}
					else {
						gridStepData[c].drawTickText = 1;
						gridStepData[c].tickLevel = 1;
					}
				}
				else {
					gridStepData[c].drawTickText = 1;
					gridStepData[c].tickLevel = 2;
				}
				gridStepData[c].stepGraphValue = d.Get();
				++c;
			}
			
			gridStepManager.SetNbSteps(c-1);
		}

};


#endif
