#ifndef _GraphCtrl_GrapCtrl_h
#define _GraphCtrl_GrapCtrl_h


/*

ceci est un commentaire

*/
#include <GraphDraw/GraphDraw.h>

#include <CtrlLib/CtrlLib.h>

#include <DropLineDash/DropLineDash.h>
#include <DropFont/DropFont.h>

namespace Upp {

#define LAYOUTFILE <GraphCtrl/GraphCtrl.lay>
#include <CtrlCore/lay.h>
#define IMAGECLASS GraphCtrlImg
#define IMAGEFILE <GraphCtrl/GraphCtrl.iml>
#include <Draw/iml_header.h>

namespace GraphDraw_ns {

// ===============================================================================================================================
// ===============================================================================================================================


#include "SeriesCtrl.h"
#include "GraphCtrlBase.h"
#include "StdElementPropertiesDialogs.h"
#include "ElementCtrlBase.h"
#include "StdElementCtrls.h"



	template<class TYPES, class DERIVED>
	class GD_XYLTMM_GraphCtrl   : public CRTP_GraphCtrl_Base< TYPES, DERIVED, GD_XYLTMM_GraphDraw<TYPES, DERIVED> >
	{
		public:
		typedef GD_XYLTMM_GraphCtrl<TYPES, DERIVED> CLASSNAME;
		typedef TYPES Types;
		typedef CRTP_GraphCtrl_Base< TYPES, DERIVED, GD_XYLTMM_GraphDraw<TYPES, DERIVED> > _B;
	
		struct Style : ChStyle<Style> {
			typename _B::StyleGD               gdStyle;
			typename _B::TypeGridAxisX1::Style x1AxisStyle;
			typename _B::TypeLabelX1::Style    x1LabelStyle;
			typename _B::TypeGridAxisY1::Style y1AxisStyle;
			typename _B::TypeLabelY1::Style    y1LabelStyle;
			typename _B::TypeLegend::Style     legendStyle;
			typename _B::TypeLabelTitle::Style titleStyle;
			typename _B::TypeMarkerX1::Style   x1MarkerStyle;
			typename _B::TypeMarkerY1::Style   y1MarkerStyle;
		};
		protected:
			const Style*               style;
	
		public:
			virtual ~GD_XYLTMM_GraphCtrl() {}
			GD_XYLTMM_GraphCtrl() {}
	
			
			DERIVED&  SetStyle(const Style& s) {
				style = &s;
				_B::SetStyleGD(style->gdStyle);
				_B::_xGridDraw.SetStyle(style->x1AxisStyle);
				_B::_xLabel.SetStyle   (style->x1LabelStyle);
				_B::_yGridDraw.SetStyle(style->y1AxisStyle);
				_B::_yLabel.SetStyle   (style->y1LabelStyle);
				_B::_legend.SetStyle   (style->legendStyle);
				_B::_title.SetStyle    (style->titleStyle);
				_B::_xMarkerGraphElement.SetStyle(style->x1MarkerStyle);
				_B::_yMarkerGraphElement.SetStyle(style->y1MarkerStyle);
				return *static_cast<DERIVED*>(this);
			}
		
	};

	template<class TYPES, class DERIVED>
	class GD_XYY2LTMM_GraphCtrl   : public CRTP_GraphCtrl_Base< TYPES, DERIVED, GD_XYY2LTMM_GraphDraw<TYPES, DERIVED> >
	{
		public:
			typedef GD_XYY2LTMM_GraphCtrl<TYPES, DERIVED> CLASSNAME;
			typedef TYPES Types;
			typedef CRTP_GraphCtrl_Base< TYPES, DERIVED, GD_XYY2LTMM_GraphDraw<TYPES, DERIVED> > _B;
		
			struct Style : ChStyle<Style> {
				typename _B::StyleGD               gdStyle;
				typename _B::TypeGridAxisX1::Style  x1AxisStyle;
				typename _B::TypeLabelX1::Style     x1LabelStyle;
				typename _B::TypeGridAxisY1::Style y1AxisStyle;
				typename _B::TypeLabelY1::Style    y1LabelStyle;
				typename _B::TypeGridAxisY2::Style y2AxisStyle;
				typename _B::TypeLabelY2::Style    y2LabelStyle;
				typename _B::TypeLegend::Style     legendStyle;
				typename _B::TypeLabelTitle::Style titleStyle;
				typename _B::TypeMarkerX1::Style   x1MarkerStyle;
				typename _B::TypeMarkerY1::Style   y1MarkerStyle;
				typename _B::TypeMarkerY2::Style   y2MarkerStyle;
			};
	
		protected:
			const Style*               style;

		public:
			virtual ~GD_XYY2LTMM_GraphCtrl() {}
			GD_XYY2LTMM_GraphCtrl() {}

		
		DERIVED&  SetStyle(const Style& s) {
			style = &s;
			_B::SetStyleGD(style->gdStyle);
			_B::_xGridDraw.SetStyle(style->x1AxisStyle);
			_B::_xLabel.SetStyle   (style->x1LabelStyle);
			_B::_yGridDraw.SetStyle(style->y1AxisStyle);
			_B::_yLabel.SetStyle   (style->y1LabelStyle);

			_B::_y2GridDraw.SetStyle(style->y2AxisStyle);
			_B::_y2Label.SetStyle   (style->y2LabelStyle);

			_B::_legend.SetStyle   (style->legendStyle);
			_B::_title.SetStyle    (style->titleStyle);
			_B::_xMarkerGraphElement.SetStyle(style->x1MarkerStyle);
			_B::_y1MarkerGraphElement.SetStyle(style->y1MarkerStyle);
			_B::_y2MarkerGraphElement.SetStyle(style->y2MarkerStyle);
			return *static_cast<DERIVED*>(this);
		}
	};

};





// ===============================================================================================================================
// ===============================================================================================================================
struct GraphCtrlDefaultTypes {
		typedef GraphDraw_ns::CoordinateConverter                                                    X_TypeCoordConverter;
		typedef GraphDraw_ns::CoordinateConverter                                                    X2_TypeCoordConverter;
		typedef GraphDraw_ns::CoordinateConverter                                                    Y_TypeCoordConverter;
		typedef GraphDraw_ns::CoordinateConverter                                                    Y2_TypeCoordConverter;
		typedef GraphDraw_ns::StdGridAxisECtrl<GraphCtrlDefaultTypes, GraphDraw_ns::GridAxisDraw >          X_TypeGridAxisDraw;
		typedef GraphDraw_ns::StdGridAxisECtrl<GraphCtrlDefaultTypes, GraphDraw_ns::GridAxisDraw >          X2_TypeGridAxisDraw;
		typedef GraphDraw_ns::StdGridAxisECtrl<GraphCtrlDefaultTypes, GraphDraw_ns::GridAxisDraw >          Y_TypeGridAxisDraw;
		typedef GraphDraw_ns::StdGridAxisECtrl<GraphCtrlDefaultTypes, GraphDraw_ns::GridAxisDraw >          Y2_TypeGridAxisDraw;
		typedef GraphDraw_ns::StdLabelECtrl<GraphCtrlDefaultTypes,GraphDraw_ns::LabelElement>               TypeLabelElement;
		typedef GraphDraw_ns::StdLegendECtrl<GraphCtrlDefaultTypes, GraphDraw_ns::LegendElement >           TypeLegendElement;
		typedef GraphDraw_ns::StdBlankAreaECtrl<GraphCtrlDefaultTypes, GraphDraw_ns::BlankAreaElement >     TypeBlankElement;
		typedef GraphDraw_ns::DynamicMarkerECtrl< GraphCtrlDefaultTypes >                                   TypeMarkerElement;
};


class XYLTMM_GraphCtrl : public GraphDraw_ns::GD_XYLTMM_GraphCtrl< GraphCtrlDefaultTypes, XYLTMM_GraphCtrl > {
	public:
		typedef XYLTMM_GraphCtrl  CLASSNAME;
		typedef GraphDraw_ns::GD_XYLTMM_GraphCtrl< GraphCtrlDefaultTypes, CLASSNAME > _B;
		
		XYLTMM_GraphCtrl() { _B::SetStyle( StyleDefault() ); }
		virtual ~XYLTMM_GraphCtrl() {}
		
		static const Style& StyleDefault();
};

class XYY2LTMM_GraphCtrl : public GraphDraw_ns::GD_XYY2LTMM_GraphCtrl< GraphCtrlDefaultTypes, XYY2LTMM_GraphCtrl > {
	public:
		typedef XYY2LTMM_GraphCtrl  CLASSNAME;
		typedef GraphDraw_ns::GD_XYY2LTMM_GraphCtrl< GraphCtrlDefaultTypes, CLASSNAME > _B;
		
		XYY2LTMM_GraphCtrl() {  _B::SetStyle( StyleDefault() ); }
		virtual ~XYY2LTMM_GraphCtrl() {}
		
		static const Style& StyleDefault();
};

class XY_GraphCtrl : public XYLTMM_GraphCtrl {
	public:
		typedef XY_GraphCtrl  CLASSNAME;
		typedef XYLTMM_GraphCtrl _B;
		
		XY_GraphCtrl() {
			HideTitle(true);
			HideLegend(true);
			HideX1Markers(true);
			HideY1Markers(true);
		}
		virtual ~XY_GraphCtrl() {}
};

class XYLT_GraphCtrl : public XYLTMM_GraphCtrl {
	public:
		typedef XYLT_GraphCtrl  CLASSNAME;
		typedef XYLTMM_GraphCtrl _B;
		
		XYLT_GraphCtrl() {
			HideX1Markers(true);
			HideY1Markers(true);
		}
		virtual ~XYLT_GraphCtrl() {}
};

class XYLTM_GraphCtrl : public XYLTMM_GraphCtrl {
	public:
		typedef XYLTM_GraphCtrl  CLASSNAME;
		typedef XYLTMM_GraphCtrl _B;
		
		XYLTM_GraphCtrl() {
			HideY1Markers(true);
		}
		virtual ~XYLTM_GraphCtrl() {}
};

class XYY2LT_GraphCtrl : public XYY2LTMM_GraphCtrl {
	public:
		typedef XYY2LT_GraphCtrl   CLASSNAME;
		typedef XYY2LTMM_GraphCtrl _B;
		
		XYY2LT_GraphCtrl() {
			HideX1Markers(true);
			HideY1Markers(true);
			HideY2Markers(true);
		}
		virtual ~XYY2LT_GraphCtrl() {}
};


};
#endif
