#ifndef _GraphCtrl_StdElementCtrls_h_
#define _GraphCtrl_StdElementCtrls_h_


struct StdGridAxisDrawECtrl_GEStyle : GridAxisDraw_GEStyle {
	Value vSelectStyle;
	Value vAxisSelectStyle;
	Value hSelectStyle;
	Value hAxisSelectStyle;

	static const StdGridAxisDrawECtrl_GEStyle& StyleDefault();  //X, Y
	static const StdGridAxisDrawECtrl_GEStyle& StyleDefault2(); // X2, Y2, X3, Y3, ...
};


#define GD_LAYDESIGN_StdGridAxisECtrl(CLASS, STYL) \
	CLASS& SetVSelectStyle(Value p)     { STYL.vSelectStyle = p; return *this; } \
	CLASS& SetVAxisSelectStyle(Value p) { STYL.vAxisSelectStyle = p; return *this; }\
	CLASS& SetHSelectStyle(Value p)     { STYL.hSelectStyle = p; return *this; }\
	CLASS& SetHAxisSelectStyle(Value p) { STYL.hAxisSelectStyle = p; return *this; }

template <class TYPES, class BASE_GRIDAXISDRAW>
class StdGridAxisECtrl : public GraphElementCtrl_Base<TYPES, BASE_GRIDAXISDRAW >
{
	public:
		typedef StdGridAxisECtrl<TYPES, BASE_GRIDAXISDRAW>       CLASSNAME;
		typedef GraphElementCtrl_Base<TYPES, BASE_GRIDAXISDRAW > _B;
	
		typedef StdGridAxisDrawECtrl_GEStyle Style;

		void SetStyle(const Style& s) {
			_B::SetStyle(s);
			styleEC = &s;
		}
		
		static const Style& StyleDefault()  { return Style::StyleDefault(); }
		static const Style& StyleDefault2() { return Style::StyleDefault2(); }

	protected:
		const Style *styleEC;

	private:
	PointScreen prevMousePoint;
	PointScreen selectOriginPoint, selectEndPoint;
	RectScreen selectRect;
	bool useLocalSelectLoop;
	Value currSelectStyle;
	
	UpdateCounter<CoordinateConverter> linkStatusCounter;
	typedef Index<CLASSNAME*> LinkedAxisList;
	LinkedAxisList linkedAxis;


	
	template <class COORDCONV>
	void TOpenPropertiesDlg(void) {
		GridAxisPropertiesDlg<CLASSNAME,  COORDCONV> dlg;
		COORDCONV& coordConv = * dynamic_cast< COORDCONV*>( &_B::GetCoordConverter() );
		dlg.InitDlg(*this, coordConv);
		if ( dlg.Execute() == IDOK ) {
			dlg.Retrieve();
			_B::_parent->RefreshFromChild( GraphDraw_ns::REFRESH_FULL );
		}
	}

	void _updateLinkedGraphs() {
		if (linkedAxis.GetCount() == 0) return;
		TypeGraphCoord min = _B::GetCoordConverter().getGraphMin();
		TypeGraphCoord max = _B::GetCoordConverter().getGraphMax();
		for (int c=(linkedAxis.GetCount()-1); c>=0; --c) {
			if ( linkedAxis[c]->linkStatusCounter != linkStatusCounter) {
				linkedAxis[c]->linkStatusCounter = linkStatusCounter;
				linkedAxis[c]->GetCoordConverter().updateGraphSize(min, max);
				linkedAxis[c]->_parent->RefreshFromChild( GraphDraw_ns::REFRESH_FAST );
			}
		}
	}

	void updateLinkedGraphs() {
		_B::GetCoordConverter().linkStatusCounter.Inc();
		_B::_parent->RequestLinksUpdate( _B::GetCoordConverter() );
	}

	void onAxisRangeUpdated() {
		whenRange( _B::GetCoordConverter().getGraphMin(), _B::GetCoordConverter().getGraphMax() );
		updateLinkedGraphs();
	}
	
	public:
	template<class COORDCONV>
	StdGridAxisECtrl( COORDCONV& conv)
	: _B(conv)
	, useLocalSelectLoop(true)
	{
		SetStyle(StyleDefault());
		_B::whenOpenPropertiesDlgCB = THISBACK( TOpenPropertiesDlg<COORDCONV> );
		currSelectStyle = Null;
	}

	Callback2<TypeGraphCoord, TypeGraphCoord>  whileScroll;
	Callback2<TypeGraphCoord, TypeGraphCoord>  whenRange;
	
	private:
	StdGridAxisECtrl( StdGridAxisECtrl& p)
	: _B(p)
	, useLocalSelectLoop(p.useLocalSelectLoop)
	{}
	
	
	public:
	virtual ~StdGridAxisECtrl() {}


	void FitToDataRefresh(FitToDataStrategy fitStrategy = GraphDraw_ns::ALL_SERIES) {
		_B::FitToData(fitStrategy);
		onAxisRangeUpdated();
		_B::_parent->RefreshFromChild( GraphDraw_ns::REFRESH_FULL );
	}

	virtual void ContextMenu(Bar& bar) {
		bar.Add(t_("Edit properties"),     THISBACK (OpenPropertiesDlg));
		bar.Add(t_("Fit To Data"),         THISBACK1(FitToDataRefresh,  GraphDraw_ns::ALL_SERIES));
		bar.Add(t_("Fit To Visible Data"), THISBACK1(FitToDataRefresh,  GraphDraw_ns::VISIBLE_SERIES_ONLY));
	}

	void UseLocalSelectLoop(bool p = true) {
		useLocalSelectLoop = p;
	}

	void Link(CLASSNAME* gridAxisCtrl) {
		if (gridAxisCtrl == 0)  return;
		if (linkedAxis.Find(gridAxisCtrl) >= 0) return;
		linkedAxis.Add( gridAxisCtrl );
		gridAxisCtrl->Link(this);
	}

	void Link(CLASSNAME& gridAxisCtrl) { Link(&gridAxisCtrl); }

	bool IsLinkedTo(CLASSNAME* gridAxisCtrl) const {
		return (linkedAxis.Find(gridAxisCtrl) >= 0);
	}

	void Unlink(CLASSNAME* gridAxisCtrl) {
		if (gridAxisCtrl == 0)  return;
		if ( linkedAxis.Find(gridAxisCtrl) < 0) return;
		linkedAxis.RemoveKey(gridAxisCtrl);
		gridAxisCtrl->Unlink(this);
	}

	void UnLinkAll() {
		while ( linkedAxis.GetCount() > 0 ) {
			Unlink(linkedAxis[0]);
		}
	}



	virtual Image  CursorImage(PointScreen p, dword keyflags) {
		if (  TEST_GC_KEYS(keyflags, GraphCtrl_Keys::K_AXIS_ZOOM) ) {
			if (!_B::GetCoordConverter().IsZoomAllowed())    return GraphCtrlImg::CROSS();
			if (_B::IsVertical() ) return GraphCtrlImg::AXIS_ZOOM_Y();
			else                   return GraphCtrlImg::AXIS_ZOOM_X();
		}
		else if ( TEST_GC_KEYS(keyflags, GraphCtrl_Keys::K_ZOOM)) {
			if (!_B::GetCoordConverter().IsZoomAllowed())    return GraphCtrlImg::CROSS();
			if (_B::IsVertical() ) return GraphCtrlImg::ZOOM_Y();
			else                   return GraphCtrlImg::ZOOM_X();
		}
		else if ( TEST_GC_KEYS(keyflags, GraphCtrl_Keys::K_AXIS_SCROLL)) {
			if (!_B::GetCoordConverter().IsScrollAllowed())  return GraphCtrlImg::CROSS();
			if (_B::IsVertical() ) return GraphCtrlImg::AXIS_SCROLL_Y();
			else                   return GraphCtrlImg::AXIS_SCROLL_X();
		}
		else if ( TEST_GC_KEYS(keyflags, GraphCtrl_Keys::K_SCROLL)) {
			if (!_B::GetCoordConverter().IsScrollAllowed())  return GraphCtrlImg::CROSS();
			if (_B::IsVertical() ) return GraphCtrlImg::SCROLL_Y();
			else                   return GraphCtrlImg::SCROLL_X();
		}
		return GraphCtrlImg::CROSS();
	}

	virtual void MouseWheel (PointScreen p, int zdelta, dword keyflags) {
		CoordinateConverter& converter = _B::GetCoordConverter();
		if (zdelta < 0) zdelta = -1;
		else            zdelta =  1;
		if (_B::IsHorizontal())  zdelta = -zdelta;
		zdelta *= abs(converter.getScreenRange()) / 5;

		if (  TEST_GC_KEYS(keyflags, GraphCtrl_Keys::K_AXIS_ZOOM) ) // => ZOOM on wheel (this axis only)
		{
			if (!_B::GetCoordConverter().IsZoomAllowed()) return;
			UndoStackData undo;
			undo.undoAction << converter.MakeRestoreAxisMinMaxCB();
				converter.updateGraphSize( converter.toGraph( converter.getScreenMin() - zdelta ),
				                           converter.toGraph( converter.getScreenMax() + zdelta ));
			undo.redoAction << converter.MakeRestoreAxisMinMaxCB();
			_B::_parent->AddUndoAction(undo);
			_B::_parent->RefreshFromChild( GraphDraw_ns::REFRESH_FAST );
			onAxisRangeUpdated();
		}
		else if (  TEST_GC_KEYS(keyflags, GraphCtrl_Keys::K_ZOOM) )
		{
			// => ZOOM on wheel ( whole graph )
			if (!_B::GetCoordConverter().IsZoomAllowed()) return;
			UndoStackData undo;
			undo.undoAction << _B::_parent->MakeRestoreGraphSizeCB();
				if (_B::IsVertical() ) {
					_B::_parent->ZoomY(converter.getScreenMax() + zdelta, converter.getScreenMin() - zdelta);
				} else {
					_B::_parent->ZoomX(converter.getScreenMin() - zdelta, converter.getScreenMax() + zdelta);
				}
			undo.redoAction << _B::_parent->MakeRestoreGraphSizeCB();
			_B::_parent->AddUndoAction(undo);
			_B::_parent->RefreshFromChild( GraphDraw_ns::REFRESH_FAST );
			onAxisRangeUpdated();
		}
		else if (  TEST_GC_KEYS(keyflags, GraphCtrl_Keys::K_AXIS_SCROLL) )
		{
			// => SCROLL on wheel ( on axis )
			if (!_B::GetCoordConverter().IsScrollAllowed()) return;
			UndoStackData undo;
			undo.undoAction << converter.MakeRestoreAxisMinMaxCB();
				converter.updateGraphSize( converter.toGraph( converter.getScreenMin() - zdelta ),
				                           converter.toGraph( converter.getScreenMax() - zdelta ));
			undo.redoAction << converter.MakeRestoreAxisMinMaxCB();
			_B::_parent->AddUndoAction(undo);
			_B::_parent->RefreshFromChild( GraphDraw_ns::REFRESH_FAST );
			onAxisRangeUpdated();
		}
		else if (  TEST_GC_KEYS(keyflags, GraphCtrl_Keys::K_SCROLL) )
		{
			if (!_B::GetCoordConverter().IsScrollAllowed()) return;
			// => SCROLL on wheel ( ALL vertical OR horizontal axis )
			UndoStackData undo;
			undo.undoAction << _B::_parent->MakeRestoreGraphSizeCB();
				if (_B::IsVertical() ) {
					// Vertical drag
					_B::_parent->ScrollY(zdelta);
				} else {
					// Horizontal drag
					_B::_parent->ScrollX(zdelta);
				}
			undo.redoAction << _B::_parent->MakeRestoreGraphSizeCB();
			_B::_parent->AddUndoAction(undo);
			_B::_parent->RefreshFromChild( GraphDraw_ns::REFRESH_FAST );
			onAxisRangeUpdated();
		}
	}

	virtual void  LeftDrag(PointScreen p, dword keyflags) {
		prevMousePoint = p;
		selectOriginPoint = p-_B::GetFrame().TopLeft();
		selectEndPoint = selectOriginPoint;

		CoordinateConverter& converter = _B::GetCoordConverter();
		Ctrl* parentCtrl = ValueTo<Ctrl*>(_B::_parent->GetParentCtrl());
		RectTracker tracker(*parentCtrl);
		tracker.Dashed().Animation();
		tracker.SetColor(Cyan()).Width(1);

		UndoStackData undo;
		undo.undoAction << _B::_parent->MakeRestoreGraphSizeCB();

		if ( TEST_GC_KEYS(keyflags, GraphCtrl_Keys::K_AXIS_ZOOM) ) // AXIS ZOOM --ONLY THIS AXIS--
		{
			if (!_B::GetCoordConverter().IsZoomAllowed()) return;
			if (_B::IsVertical() ) {
				if ( useLocalSelectLoop ) {
					currSelectStyle = styleEC->vAxisSelectStyle;
					_B::_parent->DoLocalLoop( THISBACK( _selectZoomLoop ) );
				} else {
					selectRect = tracker.Track(RectScreen(PointScreen(_B::GetFrame().TopLeft().x, p.y), Size(_B::GetFrame().GetSize().cx, 2)), ALIGN_CENTER, ALIGN_NULL ) - _B::GetFrame().TopLeft();
				}
				converter.updateGraphSize( converter.toGraph( selectRect.bottom ), converter.toGraph( selectRect.top ));
			} else {
				if ( useLocalSelectLoop ) {
					currSelectStyle = styleEC->hAxisSelectStyle;
					_B::_parent->DoLocalLoop( THISBACK( _selectZoomLoop ) );
				} else {
					selectRect = tracker.Track(RectScreen(PointScreen(p.x, _B::GetFrame().TopLeft().y), Size(2,_B::GetFrame().GetSize().cy)), ALIGN_NULL, ALIGN_CENTER) - _B::GetFrame().TopLeft();
				}
				converter.updateGraphSize( converter.toGraph( selectRect.left ), converter.toGraph( selectRect.right ));
			}
			currSelectStyle = Null;
			_B::_parent->RefreshFromChild( GraphDraw_ns::REFRESH_FAST );
			
			if (p != (ValueTo<Ctrl*>(_B::_parent->GetParentCtrl()))->GetMouseViewPos()) {
				undo.redoAction << _B::_parent->MakeRestoreGraphSizeCB();
				_B::_parent->AddUndoAction(undo);
				onAxisRangeUpdated();
			}
		}
		else if (TEST_GC_KEYS(keyflags, GraphCtrl_Keys::K_ZOOM) ) // GRAPH ZOOM
		{
			if (!_B::GetCoordConverter().IsZoomAllowed()) return;
			if (_B::IsVertical() ) {
				if ( useLocalSelectLoop ) {
					currSelectStyle = styleEC->vSelectStyle;
					_B::_parent->DoLocalLoop( THISBACK( _selectZoomLoop ) );
				}
				else {
					selectRect = tracker.Track(RectScreen(PointScreen(_B::GetFrame().TopLeft().x, p.y), Size(_B::GetFrame().GetSize().cx, 2)), ALIGN_CENTER, ALIGN_NULL ) - _B::GetFrame().TopLeft();
				}
				_B::_parent->ZoomY( selectRect.top, selectRect.bottom );
			} else {
				if ( useLocalSelectLoop ) {
					currSelectStyle = styleEC->hSelectStyle;
					_B::_parent->DoLocalLoop( THISBACK( _selectZoomLoop ) );
				}
				else {
					selectRect = tracker.Track(RectScreen(PointScreen(p.x, _B::GetFrame().TopLeft().y), Size(2,_B::GetFrame().GetSize().cy)), ALIGN_NULL, ALIGN_CENTER) - _B::GetFrame().TopLeft();
				}
				_B::_parent->ZoomX(selectRect.left, selectRect.right );
			}
			currSelectStyle = Null;
			_B::_parent->RefreshFromChild( GraphDraw_ns::REFRESH_FAST );

			if (p != (ValueTo<Ctrl*>(_B::_parent->GetParentCtrl()))->GetMouseViewPos()) {
				undo.redoAction << _B::_parent->MakeRestoreGraphSizeCB();
				_B::_parent->AddUndoAction(undo);
				onAxisRangeUpdated();
			}
		}
		else if ( TEST_GC_KEYS(keyflags, GraphCtrl_Keys::K_AXIS_SCROLL ) ) // AXIS SCROLL --ONLY THIS AXIS--
		{
			if (!_B::GetCoordConverter().IsScrollAllowed()) return;
			_B::_parent->DoLocalLoop( THISBACK( _AxisScrollLoop ) );

			if (p != (ValueTo<Ctrl*>(_B::_parent->GetParentCtrl()))->GetMouseViewPos()) {
				undo.redoAction << _B::_parent->MakeRestoreGraphSizeCB();
				_B::_parent->AddUndoAction(undo);
				onAxisRangeUpdated();
			}
		}
		else if ( TEST_GC_KEYS(keyflags, GraphCtrl_Keys::K_SCROLL )) // GRAPH SCROLL
		{
			if (!_B::GetCoordConverter().IsScrollAllowed()) return;
			_B::_parent->DoLocalLoop( THISBACK( _ScrollLoop ) );

			if (p != (ValueTo<Ctrl*>(_B::_parent->GetParentCtrl()))->GetMouseViewPos()) {
				undo.redoAction << _B::_parent->MakeRestoreGraphSizeCB();
				_B::_parent->AddUndoAction(undo);
				onAxisRangeUpdated();
			}
		}
	}

	private:
	virtual void PaintOnPlot_overData(Draw& dw, int otherWidth, int scale) {
		_B::PaintOnPlot_overData(dw, otherWidth, scale);
		if ( useLocalSelectLoop && !currSelectStyle.IsNull() ) {
			if (_B::IsVertical() ) {
				if (selectOriginPoint.y<=selectEndPoint.y) { selectRect = RectScreen(PointScreen(0, selectOriginPoint.y), PointScreen(otherWidth, selectEndPoint.y) );    }
				else                                       { selectRect = RectScreen(PointScreen(0, selectEndPoint.y),    PointScreen(otherWidth, selectOriginPoint.y) ); }
			} else {
				if (selectOriginPoint.x<=selectEndPoint.x) { selectRect = RectScreen(PointScreen(selectOriginPoint.x, 0), PointScreen(selectEndPoint.x, otherWidth) );    }
				else                                       { selectRect = RectScreen(PointScreen(selectEndPoint.x, 0),    PointScreen(selectOriginPoint.x, otherWidth) ); }
			}
			ChPaint(dw, selectRect, currSelectStyle);
		}
	}

	void _selectZoomLoop (PointScreen p, dword keyflags) {
		selectEndPoint = p-_B::GetFrame().TopLeft();
		_B::_parent->RefreshFromChild( GraphDraw_ns::REFRESH_KEEP_DATA );
	}

	void _ScrollLoop (PointScreen p, dword keyflags) {
		if (_B::IsVertical() ) { _B::_parent->ScrollY(p.y-prevMousePoint.y); }
		else                   { _B::_parent->ScrollX(p.x-prevMousePoint.x); }
		prevMousePoint = p;
		_B::_parent->RefreshFromChild( GraphDraw_ns::REFRESH_FAST );
	}

	void _AxisScrollLoop (PointScreen p, dword keyflags) {
		int delta=0;
		if (_B::IsVertical() ) { delta = p.y-prevMousePoint.y; }
		else                   { delta = p.x-prevMousePoint.x; }
		_B::_coordConverter.Scroll( delta );
		prevMousePoint = p;
		_B::_parent->RefreshFromChild( GraphDraw_ns::REFRESH_FAST );
	}

	public:
	virtual void MouseMove (PointScreen p, dword keyflags) {
	}
};




template<class TYPES, class LEGENDDRAW>
class StdLegendECtrl : public GraphElementCtrl_FloatMoveResize<TYPES, GraphElementCtrl_Base<TYPES, LEGENDDRAW > > {
	public:
	typedef StdLegendECtrl<TYPES, LEGENDDRAW>  CLASSNAME;
	typedef GraphElementCtrl_FloatMoveResize<TYPES, GraphElementCtrl_Base<TYPES, LEGENDDRAW > >  _B;
	StdLegendECtrl() {}
	StdLegendECtrl(StdLegendECtrl& p) : GraphElementCtrl_FloatMoveResize<TYPES, LEGENDDRAW>(p) {}
	virtual ~StdLegendECtrl() {}
};



template<class TYPES, class LABELDRAW>
class StdLabelECtrl : public  GraphElementCtrl_Base< TYPES, LABELDRAW > {
	public:
	typedef StdLabelECtrl<TYPES, LABELDRAW>  CLASSNAME;
	typedef GraphElementCtrl_Base< TYPES, LABELDRAW > _B;
	typedef TYPES  Types;
	
	StdLabelECtrl() {
		_B::whenOpenPropertiesDlgCB = THISBACK( _B::template TOpenPropertiesDlg<LabelPropertiesDlg> );
		_B::DisablePos(GraphDraw_ns::FLOAT_OVER_GRAPH);
	}
};

template<class TYPES, class ELEMENTDRAW>
class StdBlankAreaECtrl : public  GraphElementCtrl_Base< TYPES, ELEMENTDRAW > {
	public:
	typedef StdBlankAreaECtrl<TYPES, ELEMENTDRAW>  CLASSNAME;
	typedef GraphElementCtrl_Base< TYPES, ELEMENTDRAW > _B;
	typedef TYPES  Types;
	
	StdBlankAreaECtrl() {
		_B::whenOpenPropertiesDlgCB = THISBACK( _B::template TOpenPropertiesDlg<BlankAreaPropertiesDlg> );
	}
};


typedef Callback3< const MarkerPosList& /*list*/, int /*markerID*/, void* /*dynMarkerCtrl*/> TypeMarkerMoveCbk;

template<class TYPES>
class DynamicMarkerECtrl : public  GraphElementCtrl_Base< TYPES, GraphDraw_ns::MarkerElement > {
	public:
	typedef DynamicMarkerECtrl<TYPES>  CLASSNAME;
	typedef GraphElementCtrl_Base< TYPES, GraphDraw_ns::MarkerElement > _B;
	
	protected:
	UpdateCounter<CLASSNAME> linkStatusCounter;
	
	typedef Index<CLASSNAME*> LinkedElementsList;
	LinkedElementsList linkedElements;
	
	typedef TYPES  Types;
	PointScreen prevMousePoint;
	TypeScreenCoord selectOffset;
	
	MarkerPosList::Iterator currMarkerPos; // marker selected for MOVE action
	
	GraphDraw_ns::MarkerElementData::TypeMarkerUpdateCbk _whenMarkerUpdatedFromLink;

	public:
	TypeMarkerMoveCbk whenMarkerMove;
	TypeMarkerMoveCbk whenMarkerUpdated;
	TypeMarkerMoveCbk whenMarkerSelected;
	TypeMarkerMoveCbk whenMarkerReleased;
		

	DynamicMarkerECtrl(CoordinateConverter& coordconv)
	: _B(coordconv)
	, _whenMarkerUpdatedFromLink(THISBACK(_ProcessWhenMarkerUpdatedFromLink))
	, whenMarkerUpdated( Proxy( whenMarkerMove ) )
	{}

	~DynamicMarkerECtrl() {
		UnLinkAll();
	}
	
	
	private:
	virtual void ContextMenu(Bar& bar) {
		bar.Add(t_("Edit properties"),  THISBACK (OpenPropertiesDlg));
		bar.Add(t_("Reset marker positions"),    THISBACK(ResetMarkers));
	}

	void _MoveMarker (PointScreen p, dword keyflags) {
		if (keyflags & K_MOUSELEFT)
		{
			if (_B::IsVertical() ) {
				// Vertical drag
				(*currMarkerPos) =  _B::_coordConverter.toGraph(p.y+selectOffset);
			} else {
				// Horizontal drag
				(*currMarkerPos) =  _B::_coordConverter.toGraph(p.x+selectOffset);
			}
			prevMousePoint = p;
			whenMarkerMove(_B::markers, currMarkerPos->GetID(), this);
			_B::_parent->RefreshFromChild( GraphDraw_ns::REFRESH_KEEP_DATA );
		}
	}
	
	void _ProcessWhenMarkerUpdatedFromLink(int markerID, void* dynMarkerCtrl) {
		DynamicMarkerECtrl* dynMarkCtrl = (DynamicMarkerECtrl*)dynMarkerCtrl;
		whenMarkerUpdated(dynMarkCtrl->markers, markerID, dynMarkerCtrl);
	}
	
	void _UpdateLinkedMarkers() {
		if ( linkedElements.IsEmpty() ) return;
		
		// Update marker directly linked
		for (int m=(_B::markers.GetCount()-1); m>=0; --m) {
			_B::markers[m].UpdateLinked( _whenMarkerUpdatedFromLink );
		}
		
		// Update marker in-directly linked
		for (int e=(linkedElements.GetCount()-1); e>=0; --e) {
			if (linkedElements[e]->linkStatusCounter != linkStatusCounter) {
				linkedElements[e]->linkStatusCounter = linkStatusCounter;
				linkedElements[e]->_UpdateLinkedMarkers();
			}
		}
	}
	
	void _RefreshLinkedMarkerElements2() {
		for (int m=(linkedElements.GetCount()-1); m>=0; --m) {
			linkedElements[m]->_parent->RefreshFromChild( GraphDraw_ns::REFRESH_KEEP_DATA );
			if (linkedElements[m]->linkStatusCounter != linkStatusCounter) {
				linkedElements[m]->linkStatusCounter = linkStatusCounter;
				linkedElements[m]->_RefreshLinkedMarkerElements2();
			}
		}
	}

	void _RefreshLinkedMarkerElements() {
		if ( linkedElements.IsEmpty() ) return;
		linkStatusCounter.Inc();
		_RefreshLinkedMarkerElements2();
	}
	
	void _CleanLinks() {
		// Remove elements that have no more linked markers
		int l = linkedElements.GetCount()-1;
		while (l>=0) {
			if ( IsLinkedTo( linkedElements[l] ) == false) {
				CLASSNAME* otherMarkerElement = linkedElements[l];
				linkedElements.Remove( l );
				otherMarkerElement->_CleanLinks();
				l = linkedElements.GetCount()-1;
			}
			else --l;
		}
	}
	
	public:
	
	void Link(CLASSNAME* dynMarker, int thisId, int otherId) {
		if (dynMarker == 0)  return;
		_B::markers.Get(thisId).Link(dynMarker->markers.Get(otherId));
		if (linkedElements.Find(dynMarker) >= 0) return;
		linkedElements.Add( dynMarker );
		dynMarker->Link(this, otherId, thisId);
	}
	inline void Link(CLASSNAME& dynMarker, int thisId, int otherId) { Link(&dynMarker, thisId, otherId); }
	inline void Link(int thisId, CLASSNAME* dynMarker, int otherId) { Link( dynMarker, thisId, otherId); }
	inline void Link(int thisId, CLASSNAME& dynMarker, int otherId) { Link(&dynMarker, thisId, otherId); }
	inline void Link(int thisId, CLASSNAME* dynMarker) { Link( dynMarker, thisId, thisId); }
	inline void Link(int thisId, CLASSNAME& dynMarker) { Link(&dynMarker, thisId, thisId); }

	bool IsLinkedTo(CLASSNAME* dynMarker) const {
		for (int l=(_B::markers.GetCount()-1); l>=0; --l) {
			for (int o=(dynMarker->markers.GetCount()-1); o>=0; --o) {
				if (_B::markers[l].IsLinkedTo( dynMarker->markers[o]) ) {
					return true;
				}
			}
		}
		return false;
	}

	void Unlink(CLASSNAME* otherDynMarker, int thisId, int otherId) {
		//GDLOGBLOCK("DynamicMarkerECtrl::Unlink(" << thisId << " , " << otherId << ")  REQUESTED");
		if (otherDynMarker == 0)  return;
		if ( linkedElements.Find(otherDynMarker) < 0) return;
		if (( _B::markers.Find(thisId) < 0 ) || (otherDynMarker->markers.Find(otherId) < 0)) return;
		//LOG("DynamicMarkerECtrl::Unlink(" << thisId << " , " << otherId << ")   removing link     count = " << linkedElements.GetCount() );
		_B::markers.Get(thisId).Unlink(otherDynMarker->markers.Get(otherId) );
		_CleanLinks();
		otherDynMarker->Unlink(this, otherId, thisId);
		//LOG("DynamicMarkerECtrl::Unlink(" << thisId << " , " << otherId << ")   links cleaned     count = " << linkedElements.GetCount() );
	}
	inline void Unlink(CLASSNAME& dynMarker, int thisId, int otherId) { Unlink(&dynMarker, thisId, otherId); }
	inline void Unlink(int thisId, CLASSNAME* dynMarker, int otherId) { Unlink( dynMarker, thisId, otherId); }
	inline void Unlink(int thisId, CLASSNAME& dynMarker, int otherId) { Unlink(&dynMarker, thisId, otherId); }
	inline void Unlink(int thisId, CLASSNAME* dynMarker) { Unlink( dynMarker, thisId, thisId); }
	inline void Unlink(int thisId, CLASSNAME& dynMarker) { Unlink(&dynMarker, thisId, thisId); }

	void UnLinkAll() {
		for (int l=(_B::markers.GetCount()-1); l>=0; --l) {
			_B::markers[l].UnlinkAll();
		}
		_CleanLinks();
	}

	void ResetMarkers() {
		MarkerPosList::Iterator iter = _B::markers.Begin();
		MarkerPosList::ConstIterator endIter = _B::markers.End();
		TypeGraphCoord step = _B::_coordConverter.getSignedGraphRange()/ (_B::markers.GetCount()+1);
		TypeGraphCoord currVal = _B::_coordConverter.getGraphMin();
		while ( iter != endIter ) {
			currVal += step;
			(*iter) = currVal;
			whenMarkerMove(_B::markers, (*iter).GetID(), this);
			++iter;
		}
		_B::_parent->RefreshFromChild( GraphDraw_ns::REFRESH_KEEP_DATA );
		linkStatusCounter.Inc();
		_UpdateLinkedMarkers();
		_RefreshLinkedMarkerElements();
	}


	void SetMarkerPos(int markerID, TypeGraphCoord pos ) {
		_B::markers.Get(markerID) = pos;
		linkStatusCounter.Inc();
		_UpdateLinkedMarkers();
		_RefreshLinkedMarkerElements();
	}


	int MarkerContains(PointScreen p) const {
		if (_B::_frame.Contains(p)) {
			MarkerPosList::ConstIterator iter = _B::markers.Begin();
			MarkerPosList::ConstIterator endIter = _B::markers.End();
	
			while ( iter != endIter ) {
				const MarkerElementData& markerData = *iter;
				if (_B::_coordConverter.IsInGraphVisibleRange(markerData)) {
					switch( _B::GetElementPos() ) {
						case GraphDraw_ns::LEFT_OF_GRAPH:
							if ( markerData.GetTickMark().Contains(p, _B::GetFrame().TopLeft(), _B::GetElementPos(), _B::GetElementWidth(), _B::_coordConverter.toScreen(markerData))) return markerData.GetID();
							break;
						case GraphDraw_ns::BOTTOM_OF_GRAPH:
							if ( markerData.GetTickMark().Contains(p, _B::GetFrame().TopLeft(), _B::GetElementPos(), _B::_coordConverter.toScreen(markerData), 0 ))                    return markerData.GetID();
							break;
						case GraphDraw_ns::TOP_OF_GRAPH:
							if ( markerData.GetTickMark().Contains(p, _B::GetFrame().TopLeft(), _B::GetElementPos(), _B::_coordConverter.toScreen(markerData), _B::GetElementWidth())) return markerData.GetID();
							break;
						case GraphDraw_ns::RIGHT_OF_GRAPH:
							if ( markerData.GetTickMark().Contains(p, _B::GetFrame().TopLeft(), _B::GetElementPos(), 0, _B::_coordConverter.toScreen(markerData)))                     return markerData.GetID();
							break;
						case GraphDraw_ns::FLOAT_OVER_GRAPH:
							break;
					}
				}
				++iter;
			}
		}
		return MarkerElementData::INVALID_MARKER_ID;
	}

	virtual void  LeftDown(PointScreen p, dword keyflags) {
		prevMousePoint = p;

		MarkerPosList::Iterator iter = _B::markers.End();
		MarkerPosList::ConstIterator endIter = _B::markers.Begin();
		while ( iter != endIter ) {
			--iter;
			MarkerElementData& markerData = *iter;
			if (_B::_coordConverter.IsInGraphVisibleRange(markerData)) {
				switch( _B::GetElementPos() ) {
					case GraphDraw_ns::LEFT_OF_GRAPH:
						if ( markerData.GetTickMark().Contains(p, _B::GetFrame().TopLeft(),  _B::GetElementPos(), _B::GetElementWidth(), _B::_coordConverter.toScreen(markerData) )) {
							currMarkerPos = iter;
							selectOffset = _B::_coordConverter.toScreen(markerData) - p.y;
							whenMarkerSelected(_B::markers, currMarkerPos->GetID(), this);
							_B::_parent->DoLocalLoop( THISBACK( _MoveMarker ) );
							whenMarkerReleased(_B::markers, currMarkerPos->GetID(), this);
							linkStatusCounter.Inc();
							_UpdateLinkedMarkers();
							_RefreshLinkedMarkerElements();
						}
						break;
					case GraphDraw_ns::BOTTOM_OF_GRAPH:
						if ( markerData.GetTickMark().Contains(p, _B::GetFrame().TopLeft(), _B::GetElementPos(), _B::_coordConverter.toScreen(markerData), 0)) {
							currMarkerPos = iter;
							selectOffset = _B::_coordConverter.toScreen(markerData) - p.x;
							whenMarkerSelected(_B::markers, currMarkerPos->GetID(), this);
							_B::_parent->DoLocalLoop( THISBACK( _MoveMarker ) );
							whenMarkerReleased(_B::markers, currMarkerPos->GetID(), this);
							linkStatusCounter.Inc();
							_UpdateLinkedMarkers();
							_RefreshLinkedMarkerElements();
						}
						break;
					case GraphDraw_ns::TOP_OF_GRAPH:
						if ( markerData.GetTickMark().Contains(p, _B::GetFrame().TopLeft(), _B::GetElementPos(),  _B::_coordConverter.toScreen(markerData), _B::GetElementWidth() )) {
							currMarkerPos = iter;
							selectOffset = _B::_coordConverter.toScreen(markerData) - p.x;
							whenMarkerSelected(_B::markers, currMarkerPos->GetID(), this);
							_B::_parent->DoLocalLoop( THISBACK( _MoveMarker ) );
							whenMarkerReleased(_B::markers, currMarkerPos->GetID(), this);
							linkStatusCounter.Inc();
							_UpdateLinkedMarkers();
							_RefreshLinkedMarkerElements();
						}
						break;
					case GraphDraw_ns::RIGHT_OF_GRAPH:
						if ( markerData.GetTickMark().Contains(p, _B::GetFrame().TopLeft(), _B::GetElementPos(), 0, _B::_coordConverter.toScreen(markerData) )) {
							currMarkerPos = iter;
							selectOffset = _B::_coordConverter.toScreen(markerData) - p.y;
							whenMarkerSelected(_B::markers, currMarkerPos->GetID(), this);
							_B::_parent->DoLocalLoop( THISBACK( _MoveMarker ) );
							whenMarkerReleased(_B::markers, currMarkerPos->GetID(), this);
							linkStatusCounter.Inc();
							_UpdateLinkedMarkers();
							_RefreshLinkedMarkerElements();
						}
						break;
					case GraphDraw_ns::FLOAT_OVER_GRAPH:
						break;
				}
			}
		}
	}


	virtual Image  CursorImage(PointScreen p, dword keyflags) {
		MarkerPosList::Iterator iter = _B::markers.Begin();
		MarkerPosList::ConstIterator endIter = _B::markers.End();

		while ( iter != endIter ) {
			MarkerElementData& markerData = *iter;
			if (_B::_coordConverter.IsInGraphVisibleRange(markerData)) {
				switch( _B::GetElementPos() ) {
					case GraphDraw_ns::LEFT_OF_GRAPH:
						if ( markerData.GetTickMark().Contains(p, _B::GetFrame().TopLeft(), _B::GetElementPos(), _B::GetElementWidth(), _B::_coordConverter.toScreen(markerData) ) ) return GraphCtrlImg::SCROLL_Y_FINGER();
						break;
					case GraphDraw_ns::BOTTOM_OF_GRAPH:
						if ( markerData.GetTickMark().Contains(p, _B::GetFrame().TopLeft(), _B::GetElementPos(), _B::_coordConverter.toScreen(markerData), 0 )) return GraphCtrlImg::SCROLL_X_FINGER();
						break;
					case GraphDraw_ns::TOP_OF_GRAPH:
						if ( markerData.GetTickMark().Contains(p, _B::GetFrame().TopLeft(), _B::GetElementPos(), _B::_coordConverter.toScreen(markerData), _B::GetElementWidth() )) return GraphCtrlImg::SCROLL_X_FINGER();
						break;
					case GraphDraw_ns::RIGHT_OF_GRAPH:
						if ( markerData.GetTickMark().Contains(p, _B::GetFrame().TopLeft(), _B::GetElementPos(), 0, _B::_coordConverter.toScreen(markerData) ) ) return GraphCtrlImg::SCROLL_Y_FINGER();
						break;
					case GraphDraw_ns::FLOAT_OVER_GRAPH:
						return _B::CursorImage(p,keyflags);
						break;
				}
			}
			++iter;
		}
		return _B::CursorImage(p,keyflags);
	}
};




template<class TYPES>
class DynamicMarkerCtrl_MarkerContains : public  DynamicMarkerECtrl< TYPES > {
	public:
	typedef DynamicMarkerCtrl_MarkerContains<TYPES>  CLASSNAME;
	typedef DynamicMarkerECtrl< TYPES > _B;

	DynamicMarkerCtrl_MarkerContains(CoordinateConverter& coordconv)
	: _B(coordconv)
	{}

	~DynamicMarkerCtrl_MarkerContains() {}

	virtual bool Contains(PointScreen p) const {
		return ( _B::MarkerContains(p) != MarkerElementData::INVALID_MARKER_ID );
	}
};

#endif
