#ifndef _GraphDraw_GrapDraw_h
#define _GraphDraw_GrapDraw_h


#include <Core/Core.h>
#include <Draw/Draw.h>
#include <ScatterDraw/ScatterDraw.h>

#include <RichText/RichText.h>

#ifdef flagGD_TIMINGS
#include <TimingPolicies/TimingPolicies.h>
#endif

#define IMAGECLASS GraphDrawImg
#define IMAGEFILE <GraphDraw/GraphDraw.iml>
#include <Draw/iml_header.h>


#include <UndoStack/UndoStack.h>

#include "logging.h"


//#define GD_DEPRECATED(MSG) [[deprecated(MSG)]]
#define GD_DEPRECATED(MSG)

namespace Upp {

namespace GraphDraw_ns
{
	Size GetSmartTextSize(const char *text, const Font scaledFont, int scale=1, int cx=INT_MAX);
	int GetSmartTextHeight(const char *s, int cx, const Font font, int scale=1);
	void DrawSmartText(Draw& draw, int x, int y, int cx, const char *text, const Font scaledFont, Color ink, int scale);
};


#define VALIDATE_IML(IML_NAME) \
	for (int c=0; c<IML_NAME::GetCount(); ++c)	{\
		Image img = IML_NAME::Get(c);\
		int pix=0;\
		for(const RGBA *s = img.begin(); s != img.End(); ++s, ++pix) {\
			if ( !(s->r <= s->a && s->g <= s->a && s->b <= s->a )) {\
				RLOG("PIXEL [" << pix << "/" << img.GetLength() << "] *s =" << *s << "    " <<  IML_NAME::GetId(c));\
			}\
		}\
	}

#include "UpdateCounter.h"
#include "GraphDrawTypes.h"
#include "CoordinateConverter.h"
#include "GraphFunctions.h"
#include "SeriesConfig.h"
#include "SeriesGroup.h"
#include "GridStepManager.h"
#include "StdGraphElements.h"
#include "GridAxisDraw.h"
#include "CustomSeries.h"
#include "GraphDrawBase.h"
#include "GraphDrawMixinLayers.h"
#include "GraphDrawCRTP.h"




namespace GraphDraw_ns
{
	struct GraphDrawDefaultTypes {
			typedef GraphDraw_ns::CoordinateConverter          X_TypeCoordConverter;
			typedef GraphDraw_ns::CoordinateConverter          X2_TypeCoordConverter;
			typedef GraphDraw_ns::CoordinateConverter          Y_TypeCoordConverter;
			typedef GraphDraw_ns::CoordinateConverter          Y2_TypeCoordConverter;

			typedef GraphDraw_ns::GridAxisDraw                        X_TypeGridAxisDraw;
			typedef GraphDraw_ns::GridAxisDraw                        X2_TypeGridAxisDraw;
			typedef GraphDraw_ns::GridAxisDraw                        Y_TypeGridAxisDraw;
			typedef GraphDraw_ns::GridAxisDraw                        Y2_TypeGridAxisDraw;

			typedef LabelElement                                      TypeLabelElement;
			typedef LegendElement                                     TypeLegendElement;
			typedef BlankAreaElement                                  TypeBlankElement;
			typedef MarkerElement                                     TypeMarkerElement;
	};




template<class TYPES, class DERIVED>
class GD_XY_GraphDraw   : public CRTP_EmptyGraphDraw<TYPES, DERIVED>
{
	public:
	typedef GD_XY_GraphDraw<TYPES, DERIVED> CLASSNAME;
	typedef CRTP_EmptyGraphDraw<TYPES, DERIVED> _B;
	
	typedef typename TYPES::X_TypeCoordConverter TypeCoordConverterX;
	typedef typename TYPES::X_TypeGridAxisDraw   TypeGridAxisX1;
	typedef typename TYPES::TypeLabelElement     TypeLabelX1;

	typedef typename TYPES::Y_TypeCoordConverter TypeCoordConverterY1;
	typedef typename TYPES::Y_TypeGridAxisDraw   TypeGridAxisY1;
	typedef typename TYPES::TypeLabelElement     TypeLabelY1;
	
	
	protected:
		TypeCoordConverterX  _xConverter;
		TypeGridAxisX1        _xGridDraw;
		TypeLabelX1           _xLabel;
		TypeCoordConverterY1  _yConverter;
		TypeGridAxisX1        _yGridDraw;
		TypeLabelY1           _yLabel;

	public:
		DERIVED& setGraphSize(Rectf r) {
			_B::_xConverter.updateGraphSize(r.TopLeft().x, r.BottomRight().x);
			_B::_yConverter.updateGraphSize(r.TopLeft().y, r.BottomRight().y);
			_B::updateSizes();
			return *static_cast<DERIVED*>(this);
		}

		DERIVED& setGraphSize(TypeGraphCoord x0, TypeGraphCoord x1, TypeGraphCoord y0, TypeGraphCoord y1) {
			_B::_xConverter.updateGraphSize( x0, x1);
			_B::_yConverter.updateGraphSize( y0, y1);
			_B::updateSizes();
			return *static_cast<DERIVED*>(this);
		}

	// X1
	public:
		virtual ~GD_XY_GraphDraw() {}

		GD_XY_GraphDraw()
		: _xConverter(*this)
		, _xGridDraw(_xConverter)
		, _yConverter(*this)
		, _yGridDraw(_yConverter)
		{
			//SetStyle( StyleDefault() );
			_B::AddXConverter(_xConverter);
			_B::AddBottomElement(_xGridDraw, 20);
			_B::AddBottomElement(30, _xLabel, 25);
			_xGridDraw.SetName( t_("X axis") );
			_xGridDraw.SetElementWidth(25);
			_xLabel.SetName( t_("X label") );
			_xLabel.SetLabel("X Axis label");

			_B::AddYConverter(_yConverter);
			_B::AddLeftElement(_yGridDraw, 20);
			_B::AddLeftElement(30, _yLabel, 25);
			_yGridDraw.SetName( t_("Y axis") );
			_yGridDraw.SetElementWidth(40);
			_yLabel.SetName( t_("Y label") );
			_yLabel.SetLabel("Y Axis label");
		};


		TypeCoordConverterX& GetX1CoordConverter() { return _xConverter; }
		TypeGridAxisX1& GetX1GridAxisDraw()         { return _xGridDraw; }
		MAKE_GRAPHDRAW_AXIS_FN(X,x);

		TypeCoordConverterY1& GetY1CoordConverter() { return _yConverter; }
		TypeGridAxisY1& GetY1GridAxisDraw()         { return _yGridDraw; }
		MAKE_GRAPHDRAW_AXIS_FN(Y,y);
};



}; // namespace GraphDraw



class XYLTMM_GraphDraw : public GraphDraw_ns::GD_XYLTMM_GraphDraw< GraphDraw_ns::GraphDrawDefaultTypes, XYLTMM_GraphDraw >
{
	public:
		typedef XYLTMM_GraphDraw  CLASSNAME;
		typedef GraphDraw_ns::GraphDrawDefaultTypes  Types;
		typedef GraphDraw_ns::GD_XYLTMM_GraphDraw<Types, CLASSNAME> _B;

		struct Style : ChStyle<Style> {
			typename _B::StyleGD               gdStyle;
			typename _B::TypeGridAxisX1::Style  x1AxisStyle;
			typename _B::TypeLabelX1::Style     x1LabelStyle;
			typename _B::TypeGridAxisY1::Style y1AxisStyle;
			typename _B::TypeLabelY1::Style    y1LabelStyle;
			typename _B::TypeLegend::Style     legendStyle;
			typename _B::TypeLabelTitle::Style titleStyle;
			typename _B::TypeMarkerX1::Style   x1MarkerStyle;
			typename _B::TypeMarkerY1::Style   y1MarkerStyle;
		};
	
		//static const Style& StyleDefault() {};
	protected:
		const Style*               style;

	public:
		
		XYLTMM_GraphDraw&  SetStyle(const Style& s) {
			style = &s;
			_B::SetStyleGD(style->gdStyle);
			_xGridDraw.SetStyle(style->x1AxisStyle);
			_xLabel.SetStyle   (style->x1LabelStyle);
			_yGridDraw.SetStyle(style->y1AxisStyle);
			_yLabel.SetStyle   (style->y1LabelStyle);
			_legend.SetStyle   (style->legendStyle);
			_title.SetStyle    (style->titleStyle);
			_xMarkerGraphElement.SetStyle(style->x1MarkerStyle);
			_yMarkerGraphElement.SetStyle(style->y1MarkerStyle);
			return *this;
		}
		
};


class XYY2LTMM_GraphDraw : public GraphDraw_ns::GD_XYY2LTMM_GraphDraw< GraphDraw_ns::GraphDrawDefaultTypes, XYY2LTMM_GraphDraw >
{
	public:
		typedef XYY2LTMM_GraphDraw  CLASSNAME;
		typedef GraphDraw_ns::GraphDrawDefaultTypes  Types;
		typedef GraphDraw_ns::GD_XYY2LTMM_GraphDraw<Types, CLASSNAME> _B;

		struct Style : ChStyle<Style> {
			typename _B::StyleGD               gdStyle;
			typename _B::TypeGridAxisX1::Style  x1AxisStyle;
			typename _B::TypeLabelX1::Style     x1LabelStyle;
			
			typename _B::TypeGridAxisY1::Style y1AxisStyle;
			typename _B::TypeLabelY1::Style    y1LabelStyle;
			
			typename _B::TypeGridAxisY2::Style y2AxisStyle;
			typename _B::TypeLabelY2::Style    y2LabelStyle;
			
			typename _B::TypeLegend::Style     legendStyle;
			typename _B::TypeLabelTitle::Style titleStyle;

			typename _B::TypeMarkerX1::Style   x1MarkerStyle;
			typename _B::TypeMarkerY1::Style   y1MarkerStyle;
			typename _B::TypeMarkerY2::Style   y2MarkerStyle;
		};
	
	protected:
		const Style*               style;

	public:
		XYY2LTMM_GraphDraw&  SetStyle(const Style& s) {
			style = &s;
			_B::SetStyleGD(style->gdStyle);
			_xGridDraw.SetStyle(style->x1AxisStyle);
			_xLabel.SetStyle   (style->x1LabelStyle);
			
			_yGridDraw.SetStyle(style->y1AxisStyle);
			_yLabel.SetStyle   (style->y1LabelStyle);
			
			_y2GridDraw.SetStyle(style->y2AxisStyle);
			_y2Label.SetStyle   (style->y2LabelStyle);
			
			_legend.SetStyle   (style->legendStyle);
			_title.SetStyle    (style->titleStyle);
			_xMarkerGraphElement.SetStyle(style->x1MarkerStyle);
			_y1MarkerGraphElement.SetStyle(style->y1MarkerStyle);
			_y2MarkerGraphElement.SetStyle(style->y2MarkerStyle);
			return *this;
		}
		

};




}

#endif
