#ifndef _GraphDraw_GraphDrawMixinLayers_h_
#define _GraphDraw_GraphDrawMixinLayers_h_


namespace GraphDraw_ns
{

//#define COMBINE3__(a, b, c)        a##b##c
//#define COMBINE3(a, b, c)          COMBINE3__(a, b, c)
#define MAKE_GRAPHDRAW_AXIS_FN( XYZ, xyz) \
	DERIVED& COMBINE3(Hide, XYZ, Axis) (bool v)                   { COMBINE3(_, xyz, GridDraw).Hide(v); return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(Set, XYZ, AxisRectWidth)(int v)             { COMBINE3(_, xyz, GridDraw).SetElementWidth(v); return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(set, XYZ, NbGridSteps)(int v)               { COMBINE3(_, xyz, GridDraw).GetGridStepManager().SetNbSteps(v); return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(Set, XYZ, GridColor)(Color v)               { /*COMBINE3(_, xyz, GridDrawStyle).gridColor=v;*/ return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(Set, XYZ, AxisWidth)(int v)                 { /*COMBINE3(_, xyz, GridDrawStyle).axisWidth=v;*/ return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(Set, XYZ, AxisColor)(Color v)               { /*COMBINE3(_, xyz, GridDrawStyle).axisColor=v;*/ return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(Set, XYZ, AxisTextColor)(Color v)           { /*COMBINE3(_, xyz, GridDrawStyle).axisTextColor=v;*/ return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(Set, XYZ, AxisTextFont)(Font v)             { /*COMBINE3(_, xyz, GridDrawStyle).axisTextFont=v;*/ return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(Set, XYZ, AxisTickColor)(Color v)           { /*COMBINE3(_, xyz, GridDrawStyle).axisTickColor=v;*/ return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(Set, XYZ, ScaleType)(int v)                 { COMBINE3(_, xyz, Converter).SetScaleType(v); return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(Set, XYZ, AxisFormatType)(AxisTextFormat v) { COMBINE3(_, xyz, GridDraw).setAxisTextFormat(v); return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(Set, XYZ, Min)(double v)                    { COMBINE3(_, xyz, Converter).SetGraphMin(v); return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(Set, XYZ, Max)(double v)                    { COMBINE3(_, xyz, Converter).SetGraphMax(v); return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(Set, XYZ, MinRangeLimit)(double v)          { COMBINE3(_, xyz, Converter).setGraphMinRangeLimit(v); return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(Set, XYZ, MaxRangeLimit)(double v)          { COMBINE3(_, xyz, Converter).setGraphMaxRangeLimit(v); return *static_cast<DERIVED*>(this); }\
	DERIVED& COMBINE3(Invert, XYZ, Axis)(bool v=true)             { COMBINE3(_, xyz, Converter).SetInverted(v); return *static_cast<DERIVED*>(this); }\
	TypeGraphCoord COMBINE3(Get, XYZ, Min)()                      { return ( COMBINE3(_, xyz, Converter).getGraphMin()); }\
	TypeGraphCoord COMBINE3(Get, XYZ, Max)()                      { return ( COMBINE3(_, xyz, Converter).getGraphMax()); }\
	Value COMBINE3(Get, XYZ, MinRangeLimit)()                     { return ( COMBINE3(_, xyz, Converter).getGraphMinRangeLimit()); }\
	Value COMBINE3(Get, XYZ, MaxRangeLimit)()                     { return ( COMBINE3(_, xyz, Converter).getGraphMaxRangeLimit()); }


#define MAKE_GRAPHDRAW_LABEL_FN( XYZ, xyz) \
		DERIVED& COMBINE3(Hide, XYZ, Label)(bool v=true)         { COMBINE3(_, xyz, Label).Hide(v); return *static_cast<DERIVED*>(this); }\
		DERIVED& COMBINE3(Set,  XYZ, LabelWidth)(int v)          { COMBINE3(_, xyz, Label).SetElementWidth(v); return *static_cast<DERIVED*>(this); }\
		DERIVED& COMBINE3(Set,  XYZ, Label)(const String& v)     { COMBINE3(_, xyz, Label).SetLabel(v); return *static_cast<DERIVED*>(this); }\
		DERIVED& COMBINE3(Set,  XYZ, LabelFont)(const Font v)   { /*COMBINE3(_, xyz, LabelStyle).labelFont = v;*/ return *static_cast<DERIVED*>(this); }\
		DERIVED& COMBINE3(Set,  XYZ, LabelColor)(const Color v) { /*COMBINE3(_, xyz, LabelStyle).labelColor = v;*/ return *static_cast<DERIVED*>(this); }

#define MAKE_GRAPHDRAW_TITLE_FN \
	DERIVED& HideTitle(bool v)             { _title.Hide(v); return *static_cast<DERIVED*>(this); }\
	DERIVED& SetTitleWidth(int v)          { _title.SetElementWidth(v); return *static_cast<DERIVED*>(this); }\
	DERIVED& SetTitle(const String& v)     { _title.SetLabel(v); return *static_cast<DERIVED*>(this); }\
	DERIVED& SetTitlePosition(const ElementPosition v) { _title.SetElementPos(v); return *static_cast<DERIVED*>(this); }\
	DERIVED& SetTitleFont(const Font v)   { /*_titleStyle.labelFont = v; */return *static_cast<DERIVED*>(this); }\
	DERIVED& SetTitleColor(const Color v) { /*_titleStyle.labelColor = v;*/ return *static_cast<DERIVED*>(this); }

	// ==================================================================================================================================
	// ==================================================================================================================================

}; // namespace GraphDraw_ns



#endif
