#include "GraphDraw.h"

namespace Upp {
namespace GraphDraw_ns {

CH_STYLE(CH_EmptyGraphDraw, StyleGD, StyleDefault) {
	plotBckgndStyle = Blend(SColorShadow(), SColorPaper(), 190); //SLtGray();
	ctrlBckgndStyle = SColorPaper();//SWhite();
	rectSelectStyle = GraphDrawImg::GSELECT();
}

// =============================================
//  LabelElement
// =============================================
CH_STYLE(LabelElement, Style, StyleDefault) {
	labelFont = StdFont(15).Bold();
	labelColor = SColorText();

	lmntBackgnd = Null;
}

CH_STYLE(LabelElement, Style, StyleTitleDefault) {
	labelFont = StdFont(20).Bold().Underline();
	labelColor = SColorMark();

	lmntBackgnd = Null;
}

CH_STYLE(LabelElement, Style, StyleXAxisDefault) {
	labelFont = StdFont(15).Bold();
	labelColor = SColorMark();

	lmntBackgnd = Null;
}

CH_STYLE(LabelElement, Style, StyleYAxisDefault) {
	labelFont = StdFont(15).Bold();
	labelColor = SColorMark();

	lmntBackgnd = Null;
}

// =============================================
//  LegendElement
// =============================================
CH_STYLE(LegendElement, Style, StyleDefault) {
	lgdFont = StdFont();
	lgdTxtColor = Null;  // uses series color by default
	lgdXSeparation = 20; // separation between two legends
	lgdStyleLength = 23;

	lmntBackgnd = Null;
}


// =============================================
//  MarkerElement
// =============================================
CH_STYLE(MarkerElement, Style, StyleDefault) {
	mrkLineColor = SRed();
	mrkTickColor = SRed();
	mrkLineWidth = 1;

	lmntBackgnd = Null;
}

// =============================================
//  MarkerElement
// =============================================
// Style for X1, Y1
CH_STYLE(GridAxisDraw, Style, StyleDefault) {
	axisWidth     = 2;
	axisColor     = SBlue();
	axisTextFont  = StdFont();
	axisTextColor = SColorText();
	axisTickColor = SColorText();
	gridColor     = SGray();
	primaryTickFactory    << []() ->TickMark* { TickMark* t = new LineTickMark();  t->SetTickLength(3); return t; };
	secondaryTickFactory  << []() ->TickMark* { TickMark* t = new LineTickMark();  t->SetTickLength(1); return t; };

	lmntBackgnd = Null;
}

// Style for X2, X3 .... Y2, Y3, ....
CH_STYLE(GridAxisDraw, Style, StyleDefault2) {
	axisWidth     = 1;
	axisColor     = SBlue();
	axisTextFont  = StdFont();
	axisTextColor = SRed();
	axisTickColor = SRed();
	gridColor     = Null;     
	primaryTickFactory    << []() ->TickMark* { TickMark* t = new LineTickMark();  t->SetTickLength(3); return t; };
	secondaryTickFactory  << []() ->TickMark* { TickMark* t = new LineTickMark();  t->SetTickLength(1); return t; };

	lmntBackgnd = Null;
}

} // namespace GraphDraw_ns
} // namespace Upp
