#ifndef _GraphCtrl_SeriesConfig_h_
#define _GraphCtrl_SeriesConfig_h_

#include <ScatterDraw/SeriesPlot.h>
#include <ScatterDraw/MarkPlot.h>
#include <ScatterDraw/DataSource.h>

namespace GraphDraw_ns
{

	class SeriesConfig : public Moveable< SeriesConfig > {
		private:
			DataSource* pD;
			bool owns;
		
		public:
			bool sequential;
			unsigned int sequentialPointsRangeMin;
			unsigned int sequentialPointsRangeMax;

			unsigned int nbVisiblePoints;

			String legend;
			int id;
			CoordinateConverter* xConverter;
			CoordinateConverter* yConverter;
			bool show;
			
			// plot
			One<SeriesPlot> seriesPlot;
			double thickness;
			Color color;
			String dash;

			// Mark
			One<MarkPlot> markPlot;
			double markWidth;
			Color markColor;
			
			// Filling
			Color fillColor;
			double opacity;
			
			Image serieIcon; // image shown in LEGENDs & MENUs

		public:
			SeriesConfig()
			{
				pD = 0;
				color = Null;
				thickness = 1;
				legend = "";
				opacity = 1;
				sequential = true;
				sequentialPointsRangeMin = 0;
				sequentialPointsRangeMax = 0;
				nbVisiblePoints = 0;
				dash = LINE_SOLID;
//				seriesPlot;// = new LineSeriesPlot();
//				markPlot;  // = new CircleMarkPlot();
				markWidth = 8;
				markColor = Null;
				fillColor = Null;
				xConverter = 0;
				yConverter = 0;
				show = true;
			}

			~SeriesConfig()	{if(pD && owns) delete pD;}

			void Init(int id, bool setDefaultStyles)
			{
				color = GetNewColor(id);
				markColor = Color(max(color.GetR()-30, 0), max(color.GetG()-30, 0), max(color.GetB()-30, 0));
				if (setDefaultStyles) SetDefaultStyles(id);
			}

			void SetDataSource(DataSource *pointsData, bool ownsData = true) { pD = pointsData; owns = ownsData; }

			inline DataSource *PointsData()	{ return pD; }

			void SetDefaultStyles(int id)
			{
				dash = GetNewDash(id);
				markPlot = GetNewMarkPlot(id);
				seriesPlot = GetNewPlotStyle(id);
			}

			Image MakeSerieIcon( Size sz, const int scale ) {
				RGBA bckgColor;   bckgColor.r = 0; bckgColor.g = 0; bckgColor.b = 0; bckgColor.a = 0;
				int width = sz.cx;
				int height = sz.cy;
				ImageBuffer ib( sz );
				Fill( ib.Begin(), bckgColor, ib.GetLength() );

				Vector< PointGraph > p1;
				int painterMode = MODE_ANTIALIASED;
				if ( !seriesPlot.IsEmpty() && !color.IsNullInstance() ) {
					// draw multiple points ONLY if lines are drawn
					p1 << PointScreen((width*2)/32,(height*2)/32) << PointScreen((width*10)/32,(height*20)/32) << PointScreen((width*20)/32,(height*12)/32) << PointScreen((width*30)/32,(height*30)/32);
				}
				else {
					// lines not drawn ==> only one point in serie ( CENTERED )
					p1 << PointScreen(width/2,height/2);
					painterMode = MODE_SUBPIXEL;
				}

				BufferPainter dw(ib, painterMode );
				
				// Draw lines
				if ( !seriesPlot.IsEmpty() ) {
					seriesPlot->Paint(dw,
	                                 p1,
	                                 scale,
	                                 opacity,
	                                 fround(thickness),
	                                 color,
	                                 dash,
	                                 Null,
	                                 fillColor,
	                                 1,
	                                 1,
	                                 32,
					                 10, false);
				}
				// Draw marks
				if ( markWidth >= 1 && markPlot && !markPlot.IsEmpty()) {
					for (int c=0; c<p1.GetCount(); ++c)
					{
						markPlot->Paint(dw,
		                               scale,
		                               p1[c],
		                               markWidth,
		                               markColor,
		                               markWidth,
		                               markColor);
					}
				}
				return ib;
			}
			
			Image MakeSerieIcon( int width=16, const int scale=1 ) {
				return MakeSerieIcon(Size(width, width), scale);
			}

			
			const Image& UpdateSerieImage() {
				serieIcon = MakeSerieIcon();
				return serieIcon;
			}
	
			inline const Image& GetSerieIcon() { return serieIcon; }
	};

	typedef Vector<SeriesConfig>  TypeVectorSeries;
};
#endif
