#ifndef _GraphDraw_GraphDrawCRTP_h_
#define _GraphDraw_GraphDrawCRTP_h_


namespace GraphDraw_ns
{
/*
template<class TYPES, class DERIVED>
class GD_XY_GraphDraw   : public CRTP_EmptyGraphDraw<TYPES, DERIVED>
{
	public:
	typedef GD_XY_GraphDraw<TYPES, DERIVED> CLASSNAME;
	typedef CRTP_EmptyGraphDraw<TYPES, DERIVED> _B;
	
	typedef typename TYPES::X_TypeCoordConverter TypeCoordConverterX1;
	typedef typename TYPES::X_TypeGridAxisDraw   TypeGridAxisX1;
	typedef typename TYPES::TypeLabelElement     TypeLabelX1;

	typedef typename TYPES::Y_TypeCoordConverter TypeCoordConverterY1;
	typedef typename TYPES::Y_TypeGridAxisDraw   TypeGridAxisY1;
	typedef typename TYPES::TypeLabelElement     TypeLabelY1;
	
	
	protected:
		TypeCoordConverterX1  _x1Converter;
		TypeGridAxisX1        _x1GridDraw;
		TypeLabelX1           _x1Label;
		TypeCoordConverterY1  _y1Converter;
		TypeGridAxisX1        _y1GridDraw;
		TypeLabelY1           _y1Label;

	public:
		DERIVED& setGraphSize(Rectf r) {
			_B::_x1Converter.updateGraphSize(r.TopLeft().x, r.BottomRight().x);
			_B::_y1Converter.updateGraphSize(r.TopLeft().y, r.BottomRight().y);
			_B::updateSizes();
			return *static_cast<DERIVED*>(this);
		}

		DERIVED& setGraphSize(TypeGraphCoord x0, TypeGraphCoord x1, TypeGraphCoord y0, TypeGraphCoord y1) {
			_B::_x1Converter.updateGraphSize( x0, x1);
			_B::_y1Converter.updateGraphSize( y0, y1);
			_B::updateSizes();
			return *static_cast<DERIVED*>(this);
		}

	// X1
	public:
		virtual ~GD_XY_GraphDraw() {}

		GD_XY_GraphDraw()
		: _x1Converter(*this)
		, _x1GridDraw(_x1Converter)
		, _y1Converter(*this)
		, _y1GridDraw(_y1Converter)
		{
			//SetStyle( StyleDefault() );
			_B::AddXConverter(_x1Converter);
			_B::AddBottomElement(_x1GridDraw, 20);
			_B::AddBottomElement(30, _x1Label, 25);
			_x1GridDraw.SetName( t_("X axis") );
			_x1GridDraw.SetElementWidth(25);
			_x1Label.SetName( t_("X label") );
			_x1Label.SetLabel("X Axis label");

			_B::AddYConverter(_y1Converter);
			_B::AddLeftElement(_y1GridDraw, 20);
			_B::AddLeftElement(30, _y1Label, 25);
			_y1GridDraw.SetName( t_("Y axis") );
			_y1GridDraw.SetElementWidth(40);
			_y1Label.SetName( t_("Y label") );
			_y1Label.SetLabel("Y Axis label");
		};


		GD_ELEM_FN_AXIS(X1,x1);
		GD_ELEM_FN_AXIS(Y1,y1);
};
*/

template<class TYPES, class DERIVED>
class GD_XYLTMM_GraphDraw   : public CRTP_EmptyGraphDraw<TYPES, DERIVED>
{
	public:
	typedef GD_XYLTMM_GraphDraw<TYPES, DERIVED> CLASSNAME;
	typedef CRTP_EmptyGraphDraw<TYPES, DERIVED> _B;
	
	typedef typename TYPES::X_TypeCoordConverter TypeCoordConverterX1;
	typedef typename TYPES::X_TypeGridAxisDraw   TypeGridAxisX1;
	typedef typename TYPES::TypeLabelElement     TypeLabelX1;
	typedef typename TYPES::Y_TypeCoordConverter TypeCoordConverterY1;
	typedef typename TYPES::Y_TypeGridAxisDraw   TypeGridAxisY1;
	typedef typename TYPES::TypeLabelElement     TypeLabelY1;
	typedef typename TYPES::TypeLegendElement    TypeLegend;
	typedef typename TYPES::TypeLabelElement     TypeLabelTitle;
	typedef typename TYPES::TypeMarkerElement    TypeMarkerX1;
	typedef typename TYPES::TypeMarkerElement    TypeMarkerY1;
	
	
	protected:
		TypeCoordConverterX1   _x1Converter;
		TypeGridAxisX1        _x1GridDraw;
		TypeLabelX1           _x1Label;
		TypeCoordConverterY1  _y1Converter;
		TypeGridAxisY1        _y1GridDraw;
		TypeLabelY1           _y1Label;
		TypeLegend            _legend;
		TypeLabelTitle        _title;
		TypeMarkerX1          _x1MarkerGraphElement;
		TypeMarkerY1          _y1MarkerGraphElement;

	public:
		DERIVED& setGraphSize(Rectf r) {
			_x1Converter.updateGraphSize(r.TopLeft().x, r.BottomRight().x);
			_y1Converter.updateGraphSize(r.TopLeft().y, r.BottomRight().y);
			_B::updateSizes();
			return *static_cast<DERIVED*>(this);
		}

		DERIVED& setGraphSize(TypeGraphCoord x0, TypeGraphCoord x1, TypeGraphCoord y0, TypeGraphCoord y1) {
			_x1Converter.updateGraphSize( x0, x1);
			_y1Converter.updateGraphSize( y0, y1);
			_B::updateSizes();
			return *static_cast<DERIVED*>(this);
		}

	// X1
	public:
		virtual ~GD_XYLTMM_GraphDraw() {}

		GD_XYLTMM_GraphDraw()
		: _x1Converter(*this)
		, _x1GridDraw(_x1Converter)
		, _y1Converter(*this)
		, _y1GridDraw(_y1Converter)
		, _x1MarkerGraphElement(_x1Converter)
		, _y1MarkerGraphElement(_y1Converter)
		{
			//SetStyle( StyleDefault() );
			_B::AddXConverter(_x1Converter);
			_B::AddBottomElement(_x1GridDraw, 20);
			_B::AddBottomElement(30, _x1Label, 25);
			_x1GridDraw.SetName( t_("X axis") );
			_x1GridDraw.SetElementWidth(25);
			_x1Label.SetName( t_("X label") );
			_x1Label.SetLabel("X Axis label");

			_B::AddYConverter(_y1Converter);
			_B::AddLeftElement(_y1GridDraw, 20);
			_B::AddLeftElement(30, _y1Label, 25);
			_y1GridDraw.SetName( t_("Y axis") );
			_y1GridDraw.SetElementWidth(40);
			_y1Label.SetName( t_("Y label") );
			_y1Label.SetLabel("Y Axis label");
			
			_legend.SetName(t_("Legend"));
			_legend.SetFloatFrame(RectScreen(PointScreen(40,20), Size(80, 30)));
			_B::AddFloatElement(30, _legend, 150);
			
			_B::AddTopElement(40, _title, 200);
			_title.SetName( t_("Title") );
			_title.SetLabel("TITLE");

			_B::AddTopElement(30, _x1MarkerGraphElement, -1);
			_x1MarkerGraphElement.SetAllowedPosMask(BOTTOM_OF_GRAPH | TOP_OF_GRAPH);

			_B::AddRightElement(30, _y1MarkerGraphElement, -1);
			_y1MarkerGraphElement.SetAllowedPosMask(LEFT_OF_GRAPH | RIGHT_OF_GRAPH);
		};

		GD_ELEM_FN_TITLE;
		GD_ELEM_FN_AXIS(X1,x1);
		GD_ELEM_FN_LABEL(X1,x1);
		GD_ELEM_FN_AXIS(Y1,y1);
		GD_ELEM_FN_LABEL(Y1,y1);
		GD_ELEM_FN_LEGEND;
		GD_ELEM_FN_MARKER(X1,x1);
		GD_ELEM_FN_MARKER(Y1,y1);
};









template<class TYPES, class DERIVED>
class GD_XYY2LTMM_GraphDraw   : public CRTP_EmptyGraphDraw<TYPES, DERIVED>
{
	public:
	typedef GD_XYLTMM_GraphDraw<TYPES, DERIVED> CLASSNAME;
	typedef CRTP_EmptyGraphDraw<TYPES, DERIVED> _B;
	
	typedef typename TYPES::X_TypeCoordConverter TypeCoordConverterX1;
	typedef typename TYPES::X_TypeGridAxisDraw   TypeGridAxisX1;
	typedef typename TYPES::TypeLabelElement     TypeLabelX1;

	typedef typename TYPES::Y_TypeCoordConverter TypeCoordConverterY1;
	typedef typename TYPES::Y_TypeGridAxisDraw   TypeGridAxisY1;
	typedef typename TYPES::TypeLabelElement     TypeLabelY1;

	typedef typename TYPES::Y_TypeCoordConverter TypeCoordConverterY2;
	typedef typename TYPES::Y_TypeGridAxisDraw   TypeGridAxisY2;
	typedef typename TYPES::TypeLabelElement     TypeLabelY2;

	typedef typename TYPES::TypeLegendElement    TypeLegend;
	typedef typename TYPES::TypeLabelElement     TypeLabelTitle;
	typedef typename TYPES::TypeMarkerElement    TypeMarkerX1;
	typedef typename TYPES::TypeMarkerElement    TypeMarkerY1;
	typedef typename TYPES::TypeMarkerElement    TypeMarkerY2;
	
	
	protected:
		TypeCoordConverterX1  _x1Converter;
		TypeGridAxisX1        _x1GridDraw;
		TypeLabelX1           _x1Label;

		TypeCoordConverterY1 _y1Converter;
		TypeGridAxisY1       _y1GridDraw;
		TypeLabelY1          _y1Label;

		TypeCoordConverterY2 _y2Converter;
		TypeGridAxisY2       _y2GridDraw;
		TypeLabelY2          _y2Label;

		TypeLegend           _legend;
		TypeLabelTitle       _title;
		TypeMarkerX1         _x1MarkerGraphElement;
		TypeMarkerY1         _y1MarkerGraphElement;
		TypeMarkerY1         _y2MarkerGraphElement;

	private:
		// forbid usage of following methods in this case
		DERIVED& setGraphSize(Rectf r) {}
		DERIVED& setGraphSize(TypeGraphCoord x0, TypeGraphCoord x1, TypeGraphCoord y0, TypeGraphCoord y1) {}
		
	public:
		DERIVED& setGraphSize(TypeGraphCoord x0, TypeGraphCoord x1, TypeGraphCoord y0, TypeGraphCoord y1, TypeGraphCoord y20, TypeGraphCoord y21 )
		{
			_x1Converter.updateGraphSize( x0, x1);
			_y1Converter.updateGraphSize( y0, y1);
			_y2Converter.updateGraphSize( y20, y21);
			_B::updateSizes();
			return *static_cast<DERIVED*>(this);
		}

	// X1
	public:
		virtual ~GD_XYY2LTMM_GraphDraw() {}

		GD_XYY2LTMM_GraphDraw()
		: _x1Converter(*this)
		, _x1GridDraw(_x1Converter)
		, _y1Converter(*this)
		, _y1GridDraw(_y1Converter)
		, _y2Converter(*this)
		, _y2GridDraw(_y2Converter)
		, _x1MarkerGraphElement(_x1Converter)
		, _y1MarkerGraphElement(_y1Converter)
		, _y2MarkerGraphElement(_y2Converter)
		{
			//SetStyle( StyleDefault() );
			_B::AddXConverter(_x1Converter);
			_B::AddBottomElement(_x1GridDraw, 20);
			_B::AddBottomElement(30, _x1Label, 25);
			_x1GridDraw.SetName( t_("X axis") );
			_x1GridDraw.SetElementWidth(25);
			_x1Label.SetName( t_("X label") );
			_x1Label.SetLabel("X Axis label");

			_B::AddYConverter(_y1Converter);
			_B::AddLeftElement(_y1GridDraw, 20);
			_B::AddLeftElement(30, _y1Label, 25);
			_y1GridDraw.SetName( t_("Y1 axis") );
			_y1GridDraw.SetElementWidth(40);
			_y1Label.SetName( t_("Y1 label") );
			_y1Label.SetLabel("Y1 Axis label");

			_B::AddYConverter(_y2Converter);
			_B::AddRightElement(_y2GridDraw, 20);
			_B::AddRightElement(30, _y2Label, 25);
			_y2GridDraw.SetName( t_("Y2 axis") );
			_y2GridDraw.SetElementWidth(40);
			_y2Label.SetName( t_("Y2 label") );
			_y2Label.SetLabel("Y2 Axis label");
			
			_legend.SetName(t_("Legend"));
			_legend.SetFloatFrame(RectScreen(PointScreen(40,20), Size(80, 30)));
			_B::AddFloatElement(30, _legend, 150);
			
			_B::AddTopElement(40, _title, 200);
			_title.SetName( t_("Title") );
			_title.SetLabel("TITLE");

			_B::AddTopElement(30, _x1MarkerGraphElement, -1);
			_x1MarkerGraphElement.SetAllowedPosMask(BOTTOM_OF_GRAPH | TOP_OF_GRAPH);

			_B::AddRightElement(30, _y1MarkerGraphElement, -1);
			_y1MarkerGraphElement.SetAllowedPosMask(LEFT_OF_GRAPH | RIGHT_OF_GRAPH);

			_B::AddRightElement(30, _y2MarkerGraphElement, -1);
			_y2MarkerGraphElement.SetAllowedPosMask(LEFT_OF_GRAPH | RIGHT_OF_GRAPH);
		};

		GD_ELEM_FN_TITLE;
		GD_ELEM_FN_LEGEND;
		GD_ELEM_FN_AXIS(X1,x1);
		GD_ELEM_FN_LABEL(X1,x1);
		GD_ELEM_FN_AXIS(Y1,y1);
		GD_ELEM_FN_LABEL(Y1,y1);
		GD_ELEM_FN_AXIS(Y2,y2);
		GD_ELEM_FN_LABEL(Y2,y2);
		GD_ELEM_FN_MARKER(X1,x1);
		GD_ELEM_FN_MARKER(Y1,y1);
		GD_ELEM_FN_MARKER(Y2,y2);
};

}; // namespace GraphDraw_ns


#endif
