#ifndef _GanttCtrl_GanttCtrl_h
#define _GanttCtrl_GanttCtrl_h


#include <GraphCtrl/GraphCtrl.h>

namespace Upp {
namespace GraphDraw_ns {

#include "GanttGridAxisDraw.h"


struct GanttCtrlDefaultTypes {
		typedef GanttCtrlDefaultTypes                                                      Types;
		typedef GraphDraw_ns::CoordinateConverter                                          X_TypeCoordConverter;
		typedef GraphDraw_ns::CoordinateConverter                                          X2_TypeCoordConverter;
		typedef GraphDraw_ns::CoordinateConverter                                          Y_TypeCoordConverter;
		typedef GraphDraw_ns::CoordinateConverter                                          Y2_TypeCoordConverter;
		typedef GraphDraw_ns::StdGridAxisECtrl<Types, GraphDraw_ns::GanttGridAxisDraw >    X_TypeGridAxisDraw;
//		typedef GraphDraw_ns::StdGridAxisECtrl<Types, GraphDraw_ns::GridAxisDraw >         X2_TypeGridAxisDraw;
		typedef GraphDraw_ns::StdGridAxisECtrl<Types, GraphDraw_ns::GridAxisDraw >         Y_TypeGridAxisDraw;
//		typedef GraphDraw_ns::StdGridAxisECtrl<Types, GraphDraw_ns::GridAxisDraw >         Y2_TypeGridAxisDraw;
		typedef GraphDraw_ns::StdLabelECtrl<Types,GraphDraw_ns::LabelElement>              TypeLabelElement;
		typedef GraphDraw_ns::StdLegendECtrl<Types, GraphDraw_ns::LegendElement >          TypeLegendElement;
		typedef GraphDraw_ns::StdBlankAreaECtrl<Types, GraphDraw_ns::BlankAreaElement >    TypeBlankElement;
		typedef GraphDraw_ns::DynamicMarkerECtrl< Types >                                  TypeMarkerElement;
};


class GanttCtrl : public GraphDraw_ns::GD_XYLTMM_GraphCtrl< GanttCtrlDefaultTypes, GanttCtrl > {
	public:
		typedef GanttCtrl  CLASSNAME;
		typedef GraphDraw_ns::GD_XYLTMM_GraphCtrl< GanttCtrlDefaultTypes, CLASSNAME > _B;
		
		GanttCtrl();
		virtual ~GanttCtrl() {}
		
		static const Style& StyleDefault();
		static void step1_GridStepCalcCbk(GridStepManager& gridStepManager, CoordinateConverter& coordConv);

		GD_LAYOUTFN_BASE;
		GD_ELEM_LAYOUTFN_TITLE;
		GD_ELEM_LAYOUTFN_LEGEND;
		GD_ELEM_LAYOUTFN_LABEL(X1, x1);
		GD_ELEM_LAYOUTFN_LABEL(Y1, y1);
		GD_ELEM_LAYOUTFN_AXIS(X1, x1);
		GD_ELEM_LAYOUTFN_AXIS(Y1, y1);
		GD_ELEM_LAYOUTFN_MARKER(X1, x1);
		GD_ELEM_LAYOUTFN_MARKER(Y1, y1);
};

} // namespace GraphDraw_ns
} // namespace Upp



#endif
