#ifndef _GraphDraw_GrapDraw_h
#define _GraphDraw_GrapDraw_h


#include <Core/Core.h>
#include <Draw/Draw.h>
#include <ScatterDraw/ScatterDraw.h>

#include <RichText/RichText.h>

#ifdef flagGD_TIMINGS
#include <TimingPolicies/TimingPolicies.h>
#endif

#define IMAGECLASS GraphDrawImg
#define IMAGEFILE <GraphDraw/GraphDraw.iml>
#include <Draw/iml_header.h>


#include <UndoStack/UndoStack.h>

#include "logging.h"


//#define GD_DEPRECATED(MSG) [[deprecated(MSG)]]
#define GD_DEPRECATED(MSG)

namespace Upp {

namespace GraphDraw_ns
{
	Size GetSmartTextSize(const char *text, const Font scaledFont, int scale=1, int cx=INT_MAX);
	int GetSmartTextHeight(const char *s, int cx, const Font font, int scale=1);
	void DrawSmartText(Draw& draw, int x, int y, int cx, const char *text, const Font scaledFont, Color ink, int scale);
};


#define VALIDATE_IML(IML_NAME) \
	for (int c=0; c<IML_NAME::GetCount(); ++c)	{\
		Image img = IML_NAME::Get(c);\
		int pix=0;\
		for(const RGBA *s = img.begin(); s != img.End(); ++s, ++pix) {\
			if ( !(s->r <= s->a && s->g <= s->a && s->b <= s->a )) {\
				RLOG("PIXEL [" << pix << "/" << img.GetLength() << "] *s =" << *s << "    " <<  IML_NAME::GetId(c));\
			}\
		}\
	}

#include "UpdateCounter.h"
#include "GraphDrawTypes.h"
#include "CoordinateConverter.h"
#include "GraphFunctions.h"
#include "SeriesConfig.h"
#include "SeriesGroup.h"
#include "GridStepManager.h"
#include "StdGraphElements.h"
#include "GridAxisDraw.h"
#include "CustomSeries.h"
#include "GraphDrawBase.h"
#include "GraphDrawMixinLayers.h"
#include "GraphDrawCRTP.h"




namespace GraphDraw_ns
{
	struct GraphDrawDefaultTypes {
			typedef GraphDraw_ns::CoordinateConverter          X_TypeCoordConverter;
			typedef GraphDraw_ns::CoordinateConverter          X2_TypeCoordConverter;
			typedef GraphDraw_ns::CoordinateConverter          Y_TypeCoordConverter;
			typedef GraphDraw_ns::CoordinateConverter          Y2_TypeCoordConverter;

			typedef GraphDraw_ns::GridAxisDraw                 X_TypeGridAxisDraw;
			typedef GraphDraw_ns::GridAxisDraw                 X2_TypeGridAxisDraw;
			typedef GraphDraw_ns::GridAxisDraw                 Y_TypeGridAxisDraw;
			typedef GraphDraw_ns::GridAxisDraw                 Y2_TypeGridAxisDraw;

			typedef LabelElement                               TypeLabelElement;
			typedef LegendElement                              TypeLegendElement;
			typedef BlankAreaElement                           TypeBlankElement;
			typedef MarkerElement                              TypeMarkerElement;
	};







}; // namespace GraphDraw




class XYLTMM_GraphDraw : public GraphDraw_ns::GD_XYLTMM_GraphDraw< GraphDraw_ns::GraphDrawDefaultTypes, XYLTMM_GraphDraw >
{
	public:
		typedef XYLTMM_GraphDraw  CLASSNAME;
		typedef GraphDraw_ns::GraphDrawDefaultTypes  Types;
		typedef GraphDraw_ns::GD_XYLTMM_GraphDraw<Types, CLASSNAME> _B;

		struct Style : ChStyle<Style> {
			typename _B::StyleGD               gdStyle;
			typename _B::TypeGridAxisX1::Style  x1AxisStyle;
			typename _B::TypeLabelX1::Style     x1LabelStyle;
			typename _B::TypeGridAxisY1::Style y1AxisStyle;
			typename _B::TypeLabelY1::Style    y1LabelStyle;
			typename _B::TypeLegend::Style     legendStyle;
			typename _B::TypeLabelTitle::Style titleStyle;
			typename _B::TypeMarkerX1::Style   x1MarkerStyle;
			typename _B::TypeMarkerY1::Style   y1MarkerStyle;
		};
	
		//static const Style& StyleDefault() {};
	protected:
		const Style*  style;

	public:

		const Style& GetStyle() { return *style; }
		XYLTMM_GraphDraw&  SetStyle(const Style& s) {
			_B::ClearLocalChStyle(&s);
			style = &s;
			_B::SetStyleGD(style->gdStyle);
			_x1GridDraw.SetStyle(style->x1AxisStyle);
			_x1Label.SetStyle   (style->x1LabelStyle);
			_y1GridDraw.SetStyle(style->y1AxisStyle);
			_y1Label.SetStyle   (style->y1LabelStyle);
			_legend.SetStyle   (style->legendStyle);
			_title.SetStyle    (style->titleStyle);
			_x1MarkerGraphElement.SetStyle(style->x1MarkerStyle);
			_y1MarkerGraphElement.SetStyle(style->y1MarkerStyle);
			return *this;
		}

		static const Style& StyleDefault();

		GD_LAYOUTFN_BASE;
		GD_ELEM_LAYOUTFN_TITLE;
		GD_ELEM_LAYOUTFN_LEGEND;
		GD_ELEM_LAYOUTFN_LABEL(X1, x1);
		GD_ELEM_LAYOUTFN_LABEL(Y1, y1);
		GD_ELEM_LAYOUTFN_AXIS(X1, x1);
		GD_ELEM_LAYOUTFN_AXIS(Y1, y1);
		GD_ELEM_LAYOUTFN_MARKER(X1, x1);
		GD_ELEM_LAYOUTFN_MARKER(Y1, y1);
};


class XYY2LTMM_GraphDraw : public GraphDraw_ns::GD_XYY2LTMM_GraphDraw< GraphDraw_ns::GraphDrawDefaultTypes, XYY2LTMM_GraphDraw >
{
	public:
		typedef XYY2LTMM_GraphDraw  CLASSNAME;
		typedef GraphDraw_ns::GraphDrawDefaultTypes  Types;
		typedef GraphDraw_ns::GD_XYY2LTMM_GraphDraw<Types, CLASSNAME> _B;

		struct Style : ChStyle<Style> {
			typename _B::StyleGD                gdStyle;
			typename _B::TypeGridAxisX1::Style  x1AxisStyle;
			typename _B::TypeLabelX1::Style     x1LabelStyle;
			
			typename _B::TypeGridAxisY1::Style y1AxisStyle;
			typename _B::TypeLabelY1::Style    y1LabelStyle;
			
			typename _B::TypeGridAxisY2::Style y2AxisStyle;
			typename _B::TypeLabelY2::Style    y2LabelStyle;
			
			typename _B::TypeLegend::Style     legendStyle;
			typename _B::TypeLabelTitle::Style titleStyle;

			typename _B::TypeMarkerX1::Style   x1MarkerStyle;
			typename _B::TypeMarkerY1::Style   y1MarkerStyle;
			typename _B::TypeMarkerY2::Style   y2MarkerStyle;
		};
	
	protected:
		const Style*  style;

	public:
		const Style& GetStyle() { return *style; }
		XYY2LTMM_GraphDraw&  SetStyle(const Style& s) {
			_B::ClearLocalChStyle(&s);
			style = &s;
			_B::SetStyleGD(style->gdStyle);
			_x1GridDraw.SetStyle(style->x1AxisStyle);
			_x1Label.SetStyle   (style->x1LabelStyle);
			
			_y1GridDraw.SetStyle(style->y1AxisStyle);
			_y1Label.SetStyle   (style->y1LabelStyle);
			
			_y2GridDraw.SetStyle(style->y2AxisStyle);
			_y2Label.SetStyle   (style->y2LabelStyle);
			
			_legend.SetStyle   (style->legendStyle);
			_title.SetStyle    (style->titleStyle);
			_x1MarkerGraphElement.SetStyle(style->x1MarkerStyle);
			_y1MarkerGraphElement.SetStyle(style->y1MarkerStyle);
			_y2MarkerGraphElement.SetStyle(style->y2MarkerStyle);
			return *this;
		}

		static const Style& StyleDefault();

		GD_LAYOUTFN_BASE;
		GD_ELEM_LAYOUTFN_TITLE;
		GD_ELEM_LAYOUTFN_LEGEND;
		GD_ELEM_LAYOUTFN_LABEL(X1, x1);
		GD_ELEM_LAYOUTFN_LABEL(Y1, y1);
		GD_ELEM_LAYOUTFN_LABEL(Y2, y2);
		GD_ELEM_LAYOUTFN_AXIS(X1, x1);
		GD_ELEM_LAYOUTFN_AXIS(Y1, y1);
		GD_ELEM_LAYOUTFN_AXIS(Y2, y2);
		GD_ELEM_LAYOUTFN_MARKER(X1, x1);
		GD_ELEM_LAYOUTFN_MARKER(Y1, y1);
			GD_ELEM_LAYOUTFN_MARKER(Y2, y2);
};

}

#endif
