#include "GanttCtrl.h"

namespace Upp {
namespace GraphDraw_ns {


GanttCtrl::GanttCtrl() {
	_B::SetStyle( StyleDefault() );
	GetElementX1GridAxisDraw().SetElementPos(TOP_OF_GRAPH);
	HideTitle();
	HideLegend();
	HideX1Markers();
	HideX1Label();
	HideY1Markers();
	SetY1AxisRectWidth(0);
	HideY1Label();
	GetElementY1GridAxisDraw().GetGridStepManager().setCustomGridSteps(STDBACK(step1_GridStepCalcCbk));
}
	
void GanttCtrl::step1_GridStepCalcCbk(GridStepManager& gridStepManager, CoordinateConverter& coordConv) {
	const unsigned int nbMaxSteps = GridStepManager::NB_MAX_STEPS; //gridStepManager.GetNbMaxSteps();
	GridStepData* gridStepData = gridStepManager.GetGridStepData();
	TypeGraphCoord gridStepValue = 1;
	TypeGraphCoord gridStartValue = GridStepManager::GetGridStartValue( gridStepValue, coordConv.getGraphMin() );

	unsigned int nbSteps = (unsigned int)tabs((coordConv.getGraphMax() - gridStartValue) / gridStepValue);
	
	if (nbSteps > nbMaxSteps) {
		nbSteps = nbMaxSteps;
	}
	gridStepManager.SetNbSteps(nbSteps);

	// fill step values ==> used by gridStepIterator
	for (unsigned int c=0; c<nbSteps+1; ++c) {
		gridStepData[c].stepGraphValue = gridStartValue + gridStepValue*c;
		gridStepData[c].drawTickText = 1;// ==> draw tick text
	}
}





CH_STYLE(GanttCtrl, Style, StyleDefault) {
	gdStyle        = GanttCtrl::CH_EmptyGraphDraw::StyleDefault();
	x1LabelStyle   = GanttCtrl::TypeLabelX1::StyleXAxisDefault();
	x1AxisStyle    = GanttCtrl::TypeGridAxisX1::StyleDefault();
	y1LabelStyle   = GanttCtrl::TypeLabelY1::StyleYAxisDefault();
	y1AxisStyle    = GanttCtrl::TypeGridAxisY1::StyleDefault();
	titleStyle     = GanttCtrl::TypeLabelTitle::StyleTitleDefault();
	legendStyle    = GanttCtrl::TypeLegend::StyleDefault();
	x1MarkerStyle  = GanttCtrl::TypeMarkerX1::StyleDefault();
	y1MarkerStyle  = GanttCtrl::TypeMarkerY1::StyleDefault();
	
}


} // namespace GraphDraw_ns
} // namespace Upp
