#include "GraphCtrl.h"

namespace Upp {
namespace GraphDraw_ns {

struct SeriesIconDisplay : public Display {
	virtual void Paint(Draw& w, const RectScreen& r, const Value& q,
	                   Color ink, Color paper, dword style) const {
		SeriesConfig* currSerie = ValueTo<SeriesConfig*>(q);
		ChPaint(w, r, currSerie->MakeSerieIcon(r.GetSize(),1));
	}
};


Id ID_SHOW_COLUMN("SHOW");
Id ID_LEGEND_COLUMN("LEGEND");


SeriesCtrlDlg::SeriesCtrlDlg( TypeVectorSeries& s )
: series(s)
, currSelection(-1)
{
	CtrlLayoutOK(*this, "Data Series Properties");
	series[0].MakeSerieIcon();
	
	seriesArray.AddColumn(ID_SHOW_COLUMN, "Show").Ctrls<Option>();
	seriesArray.AddColumn("Icon").SetDisplay( Single<SeriesIconDisplay>() );
	seriesArray.AddColumn(ID_LEGEND_COLUMN, "Legend").Ctrls<EditString>();
	seriesArray.ColumnWidths("23 45 120");
	
	seriesArray.WhenCtrlsAction = THISBACK(arrayLineEdited);
	seriesArray.WhenSel = THISBACK(updateSelection);
	show.WhenAction = THISBACK(updateArrayShow);
	legend.WhenAction = THISBACK(updateArrayLegend);
	
	lineDash.WhenAction = THISBACK(saveConfigToSelectedSerie);
	lineThickness.WhenAction = THISBACK(saveConfigToSelectedSerie);
	lineColor.WhenAction = THISBACK(saveConfigToSelectedSerie);
	opacity.WhenAction = THISBACK(saveConfigToSelectedSerie);
	fillColor.WhenAction = THISBACK(saveConfigToSelectedSerie);

	//markstyle.WhenAction = THISBACK(saveConfigToSelectedSerie);
	markWidth.WhenAction = THISBACK(saveConfigToSelectedSerie);
	markColor.WhenAction = THISBACK(saveConfigToSelectedSerie);
	
	ShowAllBt.WhenAction= THISBACK1( showAll, true );
	ClearAllBt.WhenAction= THISBACK1(showAll, false);
	

	serieBackGnd.Color( Color(255, 255, 255) );

	for (int c=0; c<series.GetCount(); ++c) {
		SeriesConfig& ser = (series[c]);
		seriesArray.Add( ser.show, RawToValue(&ser), ser.legend );
	}
}

SeriesCtrlDlg::~SeriesCtrlDlg() {
	saveConfigToSelectedSerie();
}



void SeriesCtrlDlg::showAll(bool showHide) {
	for (int i = 0; i < series.GetCount(); ++i) {
		seriesArray.Set(i, ID_SHOW_COLUMN, showHide);
	}
	arrayLineEdited();
}


void SeriesCtrlDlg::updateArrayShow(void) {
	seriesArray.Set(ID_SHOW_COLUMN, ~show);
}

void SeriesCtrlDlg::updateArrayLegend(void) {
	seriesArray.Set(ID_LEGEND_COLUMN, ~legend);
}

void SeriesCtrlDlg::arrayLineEdited(void) {
	for (int c=0; c<seriesArray.GetCount(); ++c) {
		series[c].show = seriesArray.Get(c, ID_SHOW_COLUMN);
		series[c].legend = seriesArray.Get(c, ID_LEGEND_COLUMN);
	}
	show.SetData(seriesArray.Get(ID_SHOW_COLUMN));
	legend.SetData(seriesArray.Get(ID_LEGEND_COLUMN));
}


void SeriesCtrlDlg::updateSelection(void) {
	saveConfigToSelectedSerie();
	currSelection = seriesArray.GetCursor();
	loadConfigFromSelectedSerie();
}

void SeriesCtrlDlg::loadConfigFromSelectedSerie(void) {
	// Load new values
	if (currSelection >= 0) {
		SeriesConfig& s = series[currSelection];

		fillColor.SetData(s.fillColor);
		opacity.SetData(s.opacity);
		markColor.SetData(s.markColor);
		lineDash.SetData(s.dash);
		lineColor.SetData(s.color);
		lineThickness.SetData(s.thickness);
		fillColor.SetData(s.fillColor);
		markWidth.SetData(s.markWidth);
		show.SetData(s.show);
		legend.SetData(s.legend);

		updateSeriePreview();
	}
}


void SeriesCtrlDlg::saveConfigToSelectedSerie(void) {
	// save previous modifications
	if (currSelection >= 0) {
		SeriesConfig& s = series[currSelection];

		s.fillColor = ~fillColor;
		s.opacity = ~opacity;
		s.markColor = ~markColor;
		s.dash = ~lineDash;
		s.color = ~lineColor;
		s.thickness = ~lineThickness;
		s.fillColor = ~fillColor;
		s.markWidth = ~markWidth;
		s.show = ~show;
		s.legend = ~legend;
		
		updateSeriePreview();
	}
}

void SeriesCtrlDlg::updateSeriePreview(void) {
	if (currSelection >= 0) {
		SeriesConfig& s = series[currSelection];
		seriePreview.SetImage( s.MakeSerieIcon(seriePreview.GetSize(),1) );
	}
}

} // namespace



END_UPP_NAMESPACE
