#ifndef _LinuxFrameBuffer_VirtualTerminal_h_
#define _LinuxFrameBuffer_VirtualTerminal_h_

#include <termios.h>
#include <CtrlLib/CtrlLib.h>

namespace Upp{

    struct VirtualTerminal{
    private:
        int active_vt = -1;
        int previous_vt = -1;
        int previous_mode = 0;
        int previous_keyboard_mode = 0;
        struct termios terminal_attributes;
        
        int  Allocate();
        void Deallocate();
        bool SetMode();
        void ResetMode();
        
    public:
        bool Open();
        void Close();
        bool HasFocus() const;
        bool SetFocus(int vt_number);
        VirtualTerminal();
    };

}

#endif
