#ifndef _ProjectsDashboard_CustomGantt_h_
#define _ProjectsDashboard_CustomGantt_h_

#include <GraphCtrl/GraphCtrl.h>

//#include <ProjectsDashboard/CurrentData.h>
//#include <ProjectsDashboard/Utilities.h>

typedef int S_ACTIVITIES;
inline bool IsHoliday(const Upp::Date& d) { return false; }


namespace Upp {
namespace GraphDraw_ns {

class GanttBase : public CustomData {
protected:
	int row_num;
	const S_ACTIVITIES* act;

public:
	GanttBase(int row, const S_ACTIVITIES* ac) : row_num(row), act(ac) {};
	virtual ~GanttBase() {};
	virtual bool Intersects(const RectGraph& graphView) const = 0;
	virtual bool Contains(const PointGraph& pt) const = 0;
	virtual void PaintDataPoint(BufferPainter& dw, int scale,
		const CoordinateConverter* xCoordConv, const CoordinateConverter* yCoordConv) = 0;
};

class GanttArrow : public GanttBase {
private:
	Vector<RectGraph> arrow_rects;
	
public:
	typedef GanttBase _B;
	rval_default(GanttArrow);
	
	GanttArrow(int row, const S_ACTIVITIES* ac, Vector<int> predRows, Vector<Date> predDates);
	virtual ~GanttArrow() {};

	virtual bool Intersects(const RectGraph& graphView) const;
	virtual bool Contains(const PointGraph& pt) const {return false;};
	virtual void PaintDataPoint(BufferPainter& dw, int scale,
		const CoordinateConverter* xCoordConv, const CoordinateConverter* yCoordConv);
};

class GanttBar : public GanttBase {
private:
	RectGraph pl_bar, ac_bar, pr_bar;

public:
	typedef GanttBase _B;
	rval_default(GanttBar);
	
	GanttBar(int row, const S_ACTIVITIES* ac);
	virtual ~GanttBar() {};
	virtual bool Intersects(const RectGraph& graphView) const;
	virtual bool Contains(const PointGraph& pt) const;
	virtual void PaintDataPoint(BufferPainter& dw, int scale,
		const CoordinateConverter* xCoordConv, const CoordinateConverter* yCoordConv);
};

class GanttBarSeries : public CustomDataSource {
private:
	const ArrayCtrl* array;
	Array<GanttBar> gantt_bars;
	
public:
	GanttBarSeries() {};
	void LinkArray(const ArrayCtrl* ar) {array = ar;};
	void DrawBars();
	virtual ~GanttBarSeries() {};
	virtual unsigned int GetCount() const {return gantt_bars.GetCount();};
	virtual const CustomData& Get(unsigned int dataIndex) const {return gantt_bars[dataIndex];};
	virtual CustomData& Get(unsigned int dataIndex) {return gantt_bars[dataIndex];};
};

class GanttArrowSeries : public CustomDataSource {
private:
	const ArrayCtrl* array;
	Array<GanttArrow> gantt_arrows;
	
public:
	GanttArrowSeries() {};
	void LinkArray(const ArrayCtrl* ar) {array = ar;};
	void DrawArrows();
	virtual ~GanttArrowSeries() {};
	virtual unsigned int GetCount() const {return gantt_arrows.GetCount();};
	virtual const CustomData& Get(unsigned int dataIndex) const {return gantt_arrows[dataIndex];};
	virtual CustomData& Get(unsigned int dataIndex) {return gantt_arrows[dataIndex];};
};

class GanttXGridAxisDraw : public GridAxisDraw {
public:
	typedef GridAxisDraw  _B;
	typedef GanttXGridAxisDraw  CLASSNAME;
	
protected:
	int daySpacing; // spacing of successive days on screen
	enum gridModeType{LONG_WEEK, SHORT_WEEK, LONG_MONTH, SHORT_MONTH, QUARTER, LONG_YEAR, SHORT_YEAR};
	gridModeType gridMode;

private:
	GanttXGridAxisDraw(const GanttXGridAxisDraw& p) : _B(p._coordConverter) {};
	
public:
	GanttXGridAxisDraw(CoordinateConverter& coordConv) : _B(coordConv) {
		SetGanttGridSteps();
	};
	virtual ~GanttXGridAxisDraw() {};

	void SetGanttGridSteps();
	void FormatAsDateCbk(const const_GridStepIterator& iter, String& output);
	void GanttGridStepCalcCbk(GridStepManager& gridStepManager, CoordinateConverter& coordConv);
	virtual void PaintAxisTop(Draw& dw, const int scale, const_GridStepIterator iter,
		const_GridStepIterator endIter);
	// draw grid of horizontal axis
	virtual void PaintHGrid(Draw& dw, int yRange, const_GridStepIterator iter,
		const_GridStepIterator endIter);
};

class GanttYGridAxisDraw : public GridAxisDraw {
public:
	typedef GridAxisDraw  _B;
	typedef GanttYGridAxisDraw  CLASSNAME;
	
private:
	GanttYGridAxisDraw(const GanttYGridAxisDraw& p) : _B(p._coordConverter) {};
	
public:
	GanttYGridAxisDraw(CoordinateConverter& coordConv) : _B(coordConv) {
		SetGanttGridSteps();
	};
	virtual ~GanttYGridAxisDraw() {};

	void SetGanttGridSteps();
	void GanttGridStepCalcCbk(GridStepManager& gridStepManager, CoordinateConverter& coordConv);
};

struct GanttCtrlDefaultTypes {
	typedef GanttCtrlDefaultTypes                                                Types;
	typedef GraphDraw_ns::CoordinateConverter                                          X1_TypeCoordConverter;
//	typedef GraphDraw_ns::CoordinateConverter                                          X2_TypeCoordConverter;
	typedef GraphDraw_ns::CoordinateConverter                                          Y1_TypeCoordConverter;
//	typedef GraphDraw_ns::CoordinateConverter                                          Y2_TypeCoordConverter;
	typedef GraphDraw_ns::StdGridAxisECtrl<Types, GraphDraw_ns::GanttXGridAxisDraw >   X1_TypeGridAxisDraw;
	typedef GraphDraw_ns::StdGridAxisECtrl<Types, GraphDraw_ns::GridAxisDraw >         X2_TypeGridAxisDraw;
	typedef GraphDraw_ns::StdGridAxisECtrl<Types, GraphDraw_ns::GanttYGridAxisDraw >   Y1_TypeGridAxisDraw;
//	typedef GraphDraw_ns::StdGridAxisECtrl<Types, GraphDraw_ns::GridAxisDraw >         Y1_TypeGridAxisDraw;
//	typedef GraphDraw_ns::StdGridAxisECtrl<Types, GraphDraw_ns::GridAxisDraw >         Y2_TypeGridAxisDraw;
	typedef GraphDraw_ns::StdLabelECtrl<Types,GraphDraw_ns::LabelElement>              TypeLabelElement;
	typedef GraphDraw_ns::StdLegendECtrl<Types, GraphDraw_ns::LegendElement >          TypeLegendElement;
	typedef GraphDraw_ns::StdBlankAreaECtrl<Types, GraphDraw_ns::BlankAreaElement >    TypeBlankElement;
	typedef GraphDraw_ns::DynamicMarkerECtrl< Types >                                  TypeMarkerElement;
};


class GanttCtrl : public GraphDraw_ns::GD_XYLTMM_GraphCtrl< GanttCtrlDefaultTypes, GanttCtrl > {
public:
	typedef GanttCtrl  CLASSNAME;
	typedef GraphDraw_ns::GD_XYLTMM_GraphCtrl< GanttCtrlDefaultTypes, CLASSNAME > _B;
	
	GanttCtrl();
	virtual ~GanttCtrl() {}
	
	static const Style& StyleDefault();
};

}; //namespace Upp
}; //namespace GraphDraw_ns


#endif
