#ifndef _GanttCtrl_GanttCtrl_h
#define _GanttCtrl_GanttCtrl_h


#include <GraphCtrl/GraphCtrl.h>

#include "CustomGantt.h"

namespace Upp {
namespace GraphDraw_ns {

#include "GanttGridAxisDraw.h"


struct MyGanttCtrlDefaultTypes {
		typedef MyGanttCtrlDefaultTypes                                                    Types;
		typedef GraphDraw_ns::CoordinateConverter                                          X1_TypeCoordConverter;
		typedef GraphDraw_ns::CoordinateConverter                                          X2_TypeCoordConverter;
		typedef GraphDraw_ns::CoordinateConverter                                          Y1_TypeCoordConverter;
		typedef GraphDraw_ns::CoordinateConverter                                          Y2_TypeCoordConverter;
		typedef GraphDraw_ns::StdGridAxisECtrl<Types, GraphDraw_ns::GanttGridAxisDraw >    X1_TypeGridAxisDraw;
//		typedef GraphDraw_ns::StdGridAxisECtrl<Types, GraphDraw_ns::GridAxisDraw >         X2_TypeGridAxisDraw;
		typedef GraphDraw_ns::StdGridAxisECtrl<Types, GraphDraw_ns::GridAxisDraw >         Y1_TypeGridAxisDraw;
//		typedef GraphDraw_ns::StdGridAxisECtrl<Types, GraphDraw_ns::GridAxisDraw >         Y2_TypeGridAxisDraw;
		typedef GraphDraw_ns::StdLabelECtrl<Types,GraphDraw_ns::LabelElement>              TypeLabelElement;
		typedef GraphDraw_ns::StdLegendECtrl<Types, GraphDraw_ns::LegendElement >          TypeLegendElement;
		typedef GraphDraw_ns::StdBlankAreaECtrl<Types, GraphDraw_ns::BlankAreaElement >    TypeBlankElement;
		typedef GraphDraw_ns::DynamicMarkerECtrl< Types >                                  TypeMarkerElement;
};


class MyGanttCtrl : public GraphDraw_ns::GD_XYLTMM_GraphCtrl< MyGanttCtrlDefaultTypes, MyGanttCtrl > {
	public:
		typedef MyGanttCtrl  CLASSNAME;
		typedef GraphDraw_ns::GD_XYLTMM_GraphCtrl< MyGanttCtrlDefaultTypes, CLASSNAME > _B;
		
		MyGanttCtrl();
		virtual ~MyGanttCtrl() {}
		
		static const Style& StyleDefault();
		static void step1_GridStepCalcCbk(GridStepManager& gridStepManager, CoordinateConverter& coordConv);

		GD_LAYOUTFN_BASE;
		GD_ELEM_LAYOUTFN_TITLE;
		GD_ELEM_LAYOUTFN_LEGEND;
		GD_ELEM_LAYOUTFN_LABEL(X1, x1);
		GD_ELEM_LAYOUTFN_LABEL(Y1, y1);
		GD_ELEM_LAYOUTFN_AXIS(X1, x1);
		GD_ELEM_LAYOUTFN_AXIS(Y1, y1);
		GD_ELEM_LAYOUTFN_MARKER(X1, x1);
		GD_ELEM_LAYOUTFN_MARKER(Y1, y1);
};

} // namespace GraphDraw_ns
} // namespace Upp



#endif
