#ifndef _GraphCtrl_GraphFunctions_h_
#define _GraphCtrl_GraphFunctions_h_


Color GetNewColor(int id);
String GetNewDash(int id);
MarkPlot *GetNewMarkPlot(int id);
SeriesPlot* GetNewPlotStyle(int id);

namespace GraphDraw_ns
{
	void DrawVArrowEnd(Draw &w, double x0, double y0, double x1, double y1, double width, double aWidth, double aHeight, const Color &color);
	void DrawHArrowEnd(Draw &w, double x0, double y0, double x1, double y1, double width, double aWidth, double aHeight, const Color &color);

	
	template <class POINT, class RECT>
	bool DetectSCrossing(const POINT p1, const POINT p2, const RECT rect)
	{
		if (p1.x<p2.x) {
			if ((p2.x<rect.left) || (rect.right<p1.x)) return false;
		}
		else {
			if ((p1.x<rect.left) || (rect.right<p2.x)) return false;
		}
	
		if (p1.y<p2.y) {
			if ((p1.y>rect.bottom) || (rect.top>p2.y)) return false;
		}
		else {
			if ((p2.y>rect.bottom) || (rect.top>p1.y)) return false;
		}

		auto pente = (p2.y-p1.y)/(p2.x-p1.x);
		auto dXmin = pente*(rect.left-p1.x)+p1.y;
		auto dXmax = pente*(rect.right-p1.x)+p1.y;
		if ( ((dXmin-rect.top)*(dXmax-rect.bottom) < 0)
		   ||((dXmin-rect.bottom)*(dXmax-rect.top) < 0) )
		{
			return true;
		}
		return false;
	}


	template <class POINT, class RECT>
	bool DetectSCrossing_XinRange(const POINT p1, const POINT p2, const RECT rect)
	{
		// We know X is in valid range ==> no need to test
		if (p1.y<p2.y) {
			if ((p1.y>rect.bottom) || (rect.top>p2.y)) return false;
		}
		else {
			if ((p2.y>rect.bottom) || (rect.top>p1.y)) return false;
		}

		auto pente = (p2.y-p1.y)/(p2.x-p1.x);
		auto dXmin = pente*(rect.left-p1.x)+p1.y;
		auto dXmax = pente*(rect.right-p1.x)+p1.y;
		if ( ((dXmin-rect.top)*(dXmax-rect.bottom) < 0)
		   ||((dXmin-rect.bottom)*(dXmax-rect.top) < 0) )
		{
			return true;
		}
		return false;
	}


	template <class T>
	int FindIndexX(DataSource* src, int idxMin, int idxMax, T xVal)
	{
		if(idxMin == idxMax)
			return idxMin;
		int64 min = 0;
		int64 max = idxMax - idxMin;
	
		while(min < max)
		{
			int64 mid = (max + min) >> 1;
			if( src->x(idxMin + mid) < xVal ) min = mid + 1;
			else                              max = mid;
		}
		return (int)(min+idxMin);
	}


};


#endif
