#include "GraphDraw.h"

namespace Upp {
namespace GraphDraw_ns {

CH_STYLE(CH_EmptyGraphDraw, StyleGD, StyleGDDefault) {
	plotBckgndStyle = Blend(SColorShadow(), SColorPaper(), 190); //SLtGray();
	ctrlBckgndStyle = SColorPaper();//SWhite();
	rectSelectStyle = GraphDrawImg::GSELECT();
}

// =============================================
//  BlankAreaElement
// =============================================
CH_STYLE(BlankAreaElement, StyleGE, StyleGEDefault) {
	lmntBackgnd = Null;
}

// =============================================
//  LabelElement
// =============================================
CH_STYLE(LabelElement, StyleGE, StyleGEDefault) {
	lmntBackgnd = Null;
	labelFont   = StdFont(15).Bold();
	labelColor  = SColorText();
}

CH_STYLE(LabelElement, StyleGE, StyleGETitleDefault) {
	lmntBackgnd = Null;
	labelFont   = StdFont(20).Bold().Underline();
	labelColor  = SColorMark();
}

CH_STYLE(LabelElement, StyleGE, StyleGEXAxisDefault) {
	lmntBackgnd = Null;
	labelFont   = StdFont(15).Bold();
	labelColor  = SColorMark();
}

CH_STYLE(LabelElement, StyleGE, StyleGEYAxisDefault) {
	lmntBackgnd = Null;
	labelFont = StdFont(15).Bold();
	labelColor = SColorMark();
}

// =============================================
//  LegendElement
// =============================================
CH_STYLE(LegendElement, StyleGE, StyleGEDefault) {
	lmntBackgnd    = Null;
	lgdFont        = StdFont();
	lgdTxtColor    = Null;  // uses series color by default
	lgdXSeparation = 20; // separation between two legends
	lgdStyleLength = 23;
	lgdFloatBackgnd= GraphDrawImg::LEGEND_FLOAT_STYLE();
}


// =============================================
//  MarkerElement
// =============================================
CH_STYLE(MarkerElement, StyleGE, StyleGEDefault) {
	lmntBackgnd  = Null;
	mrkLineColor = SRed();
	mrkTickColor = SRed();
	mrkLineWidth = 1;
}

// =============================================
//  MarkerElement
// =============================================
// Style for X1, Y1
CH_STYLE(GridAxisDraw, StyleGE, StyleGEDefault) {
	lmntBackgnd   = Null;
	axisWidth     = 2;
	axisColor     = SBlue();
	axisTextFont  = StdFont();
	axisTextColor = SColorText();
	axisTextFont  = StdFont();
	axisTickColor = SColorText();
	gridColor     = SGray();
	primaryTickFactory    << []() ->TickMark* { TickMark* t = new LineTickMark();  t->SetTickLength(3); return t; };
	secondaryTickFactory  << []() ->TickMark* { TickMark* t = new LineTickMark();  t->SetTickLength(1); return t; };
}

// Style for X2, X3 .... Y2, Y3, ....
CH_STYLE(GridAxisDraw, StyleGE, StyleGEDefault2) {
	lmntBackgnd   = Null;
	axisWidth     = 2;
	axisColor     = SBlue();
	axisTextFont  = StdFont();
	axisTextColor = SColorText();
	axisTextFont  = StdFont();
	axisTickColor = SColorText();
	gridColor     = Null;     
	primaryTickFactory    << []() ->TickMark* { TickMark* t = new LineTickMark();  t->SetTickLength(3); return t; };
	secondaryTickFactory  << []() ->TickMark* { TickMark* t = new LineTickMark();  t->SetTickLength(1); return t; };
}

} // namespace GraphDraw_ns
} // namespace Upp
