#include "GraphCtrl_Demo.h"


namespace Upp {
namespace GraphDraw_ns {
	// =========================================================
	//    CustomData_WF
	// =========================================================
	bool CustomData_WF::Intersects(const RectGraph& graphView) const
	{
		//RLOG( "CustomData_WF::Intersects()=" << graphView.Intersects(rectGraphBound) << " : "<< graphView <<  "  --  " << rectGraphBound);
		if ( !rectGraphBound.IsNullInstance() || !rectGraphBound.IsEmpty() ) return graphView.Intersects(rectGraphBound);
		return true;
	}
	
	bool CustomData_WF::Contains(const PointGraph& pt) const
	{
//				RLOG("CustomData_WF::Contains()["<< priorite << "]="<< rectGraphBound.Contains(pt) << " : " << pt << "  -- "  << rectGraphBound);
		return rectGraphBound.Contains(pt);
	}
	
	void CustomData_WF::PaintDataPoint(BufferPainter& dw, int scale, const CoordinateConverter* xCoordConv, const CoordinateConverter* yCoordConv )
	{
		double start = dateDebut;
		double end = dateFin;
		
		//RectGraph rectGraphBound2;
		rectGraphBound.left = start/10;
		rectGraphBound.right = end/10;
		rectGraphBound.top = priorite/10;
		rectGraphBound.bottom = priorite/10 + hauteur;
		
		const TypeScreenCoord left = xCoordConv->toScreen(rectGraphBound.left);
		const TypeScreenCoord right = xCoordConv->toScreen(rectGraphBound.right);
		const TypeScreenCoord bottom = yCoordConv->toScreen(rectGraphBound.top);
		const TypeScreenCoord top = yCoordConv->toScreen(rectGraphBound.bottom);
		Rect r(left,top, right, bottom);
		r.Normalize();
		ChPaint(dw, r, rectStyle);
		if (isSelected) {
			DrawFrame(dw, r, Cyan());
		}
	}
	
	
	// =========================================================
	//    CustomDataSource_WF
	// =========================================================
	bool CustomDataSource_WF::LeftDown (unsigned int pIndex, PointGraph p, dword keyflags) {
		data[pIndex].isSelected = !(data[pIndex].isSelected);
		return true;
	}

	bool CustomDataSource_WF::LeftDouble (unsigned int pIndex, PointGraph p, dword keyflags) {
		RLOG( "CustomDataSource_WF::LeftDouble() [" << pIndex << "] : " << data[pIndex].dateDebut);
		return true;
	}
	
	bool CustomDataSource_WF::CursorImage(unsigned int pIndex, PointGraph p, dword keyflags, Image& outImg ) {
		outImg = GraphDrawImg::CROSS();
		return true;
	}

};
};