/*
 * GridAxisDraw.h
 *
 *  Created on: 6 avr. 2012
 *      Author: didier
 */

#ifndef GRIDAXISDRAW_H_
#define GRIDAXISDRAW_H_


#include "TickMark.h"

namespace GraphDraw_ns
{

	// ============================
	//    GridAxisDraw   CLASS
	// ============================
	typedef enum {
		AXIS_TEXT_FORMAT_STD,
		AXIS_TEXT_FORMAT_LOG,
		AXIS_TEXT_FORMAT_DATE,
		AXIS_TEXT_FORMAT_TIME,
	} AxisTextFormat;

	struct GridAxisDraw_GEStyle : ChStyle<GridAxisDraw_GEStyle>, GraphElement::GEBaseStyle {
			int       axisWidth;
			Color     axisColor;
			Font      axisTextFont;
			Color     axisTextColor;
			Color     axisTickColor;
			Color     gridColor;
			Function<TickMark* ()> primaryTickFactory;
			Function<TickMark* ()> secondaryTickFactory;
	};

	class GridAxisDraw : public GraphElement
	{
	public:
		typedef GraphElement  _B;
		typedef GridAxisDraw  CLASSNAME;

		typedef GridAxisDraw_GEStyle StyleGE;
		
		static const StyleGE& StyleGEDefault();  // default for X1 & Y1
		static const StyleGE& StyleGEDefault2(); // default for X2,Y2, X3,Y3, ....
		GridAxisDraw&  SetStyleGE(const StyleGE& s) {
			style = &s;
			_tickMarks[0] = style->primaryTickFactory();
			_tickMarks[1] = style->secondaryTickFactory();
			return *this;
		}

	protected:
		const StyleGE *style;
		
	public:
		
	protected:
		CoordinateConverter& _coordConverter;
		GridStepManager _gridStepManager;

		enum {NB_TICKMARKS = 2 };
		One<TickMark> _tickMarks[NB_TICKMARKS]; // One<>  used for ownership (manages delete)
		TypeFormatTextCbk _formatTextCbk;
		Sizef _meanTickTextsz;
		Sizef _tmpTextSize;
		unsigned int _nbMeanValues;


	public:
		GridAxisDraw(CoordinateConverter& coordConv)
		: _coordConverter( coordConv )
		, _gridStepManager( coordConv )
		, _formatTextCbk(THISBACK(FormatAsDouble))
		, _meanTickTextsz(10,10)
		, _tmpTextSize(10,10)
		, _nbMeanValues(0)
		{
			SetStyleGE(StyleGEDefault());
			_B::DisablePos(FLOAT_OVER_GRAPH);
			PrePaint(1);
		}
	private:
		GridAxisDraw(GridAxisDraw& p)
		: _B(p)
		, style(p.style)
		, _coordConverter( p._coordConverter )
		, _gridStepManager( p._coordConverter )
		, _formatTextCbk( p._formatTextCbk )
		, _meanTickTextsz( p._meanTickTextsz )
		, _tmpTextSize(10,10)
		, _nbMeanValues(0)
		{
			SetStyleGE(*p.style);
			PrePaint(1);
		}
	public:
		virtual ~GridAxisDraw() {}
		
		virtual void PrePaint( int scale );
		virtual void SetElementPos(ElementPosition v);
		virtual void FitToData(FitToDataStrategy fitStrategy);

		inline GridStepManager& GetGridStepManager()         { return _gridStepManager; }
		inline CoordinateConverter& GetCoordConverter()      { return _coordConverter;  }

		GridAxisDraw& setMajorTickMark(TickMark* v)             { _tickMarks[0] = v; return *this;  }
		GridAxisDraw& setMinorTickMark(TickMark* v)             { _tickMarks[1] = v; return *this;  }
		GridAxisDraw& setAxisTextFormat(TypeFormatTextCbk v)    { _formatTextCbk = v; return *this;  }
		GridAxisDraw& setAxisInverted(bool v=true)              { _coordConverter.SetInverted(v); return *this; }

		GridAxisDraw& setAxisTextFormat(AxisTextFormat v) {
			switch(v) {
				case AXIS_TEXT_FORMAT_STD:  resetAxisTextFormat() ; break;
				case AXIS_TEXT_FORMAT_LOG:  setAxisLogFormat(); break;
				case AXIS_TEXT_FORMAT_DATE: setAxisDateFormat(); break;
				case AXIS_TEXT_FORMAT_TIME: setAxisTimeFormat(); break;
				default:
					ASSERT_(false, "UNVALID_VALUE");
			}
			return *this;
		}
		
		GridAxisDraw& resetAxisTextFormat();
		GridAxisDraw& setAxisLogFormat(TypeFormatTextCbk cbk=TypeFormatTextCbk());
		GridAxisDraw& setAxisDateFormat( TypeFormatTextCbk cbk=TypeFormatTextCbk() );
		GridAxisDraw& setAxisTimeFormat( TypeFormatTextCbk cbk=TypeFormatTextCbk() );
  
		inline int  GetMajorTickLength()                  { return _tickMarks[0]->GetTickLength(); }
		inline void SetMajorTickLength(int v)             { _tickMarks[0]->SetTickLength(v); }
		inline int  GetMinorTickLength()                  { return _tickMarks[1]->GetTickLength(); }
		inline void SetMinorTickLength(int v)             { _tickMarks[1]->SetTickLength(v); }

		inline       GridStepIterator GridStepBegin(void) { return  _gridStepManager.Begin(); }
		inline const_GridStepIterator GridStepEnd(void)   { return  _gridStepManager.End(); }

		void FormatAsDouble( const const_GridStepIterator& iter, String& output );
		void FormatAsLog10( const const_GridStepIterator& iter, String& output );
		void FormatAsDate( const const_GridStepIterator& value, String& output );
		void FormatAsTime( const const_GridStepIterator& value, String& output );

		void UpdateTickTextData( int scale );

		void PaintTickText(Draw& dw,  const ElementPosition ePos, const const_GridStepIterator& value, TypeScreenCoord x, TypeScreenCoord y, const Color color, const Font scaledFont, int scale);
		virtual void PaintAxisLeft(Draw& dw, const int scale, const_GridStepIterator iter, const_GridStepIterator endIter);
		virtual void PaintAxisRight(Draw& dw, const int scale, const_GridStepIterator iter, const_GridStepIterator endIter);
		virtual void PaintAxisBottom(Draw& dw, const int scale, const_GridStepIterator iter, const_GridStepIterator endIter);
		virtual void PaintAxisTop(Draw& dw, const int scale, const_GridStepIterator iter, const_GridStepIterator endIter);
		virtual void PaintVGrid(Draw& dw, int xRange, const_GridStepIterator iter, const_GridStepIterator endIter);
		virtual void PaintHGrid(Draw& dw, int yRange, const_GridStepIterator iter, const_GridStepIterator endIter);
		virtual void PaintOnPlot_underData(Draw& dw, int otherWidth, int scale);
		virtual void PaintElement(Draw& dw, int scale);
	};
}


#endif /* GRIDAXISDRAW_H_ */
