#include "GraphDraw.h"


namespace Upp {
namespace GraphDraw_ns {
	
	
		// =============================================================
		//      LabelElement
		// =============================================================
		void LabelElement::PaintElement(Draw& dw, int scale)
		{
			_B::PaintElementBckGround(dw, _B::GetFrame().GetSize(), style->lmntBackgnd );
			
			Font scaledFont( style->labelFont );
			scaledFont.Height(scale*scaledFont.GetHeight());
			Size sz = GetTextSize(_label, scaledFont);
			switch(_B::GetElementPos()) {
				case LEFT_OF_GRAPH:
					dw.DrawText( _B::GetElementWidth()*scale/2-sz.cy/2, _B::GetFrame().GetHeight()/2+sz.cx/2 , 900, _label, scaledFont, style->labelColor);
					break;
				case BOTTOM_OF_GRAPH:
					dw.DrawText( _B::GetFrame().GetWidth()/2-sz.cx/2, _B::GetElementWidth()*scale/2-sz.cy/2 , _label, scaledFont, style->labelColor);
					break;
				case TOP_OF_GRAPH:
					dw.DrawText( _B::GetFrame().GetWidth()/2-sz.cx/2, _B::GetElementWidth()*scale/2-sz.cy/2 , _label, scaledFont, style->labelColor);
					break;
				case RIGHT_OF_GRAPH:
					dw.DrawText( _B::GetElementWidth()*scale/2+sz.cy/2, _B::GetFrame().GetHeight()/2-sz.cx/2 , 2700, _label, scaledFont, style->labelColor);
					break;
				case FLOAT_OVER_GRAPH:
					break;
			}
		}
	



		// =============================================================
		//      LegendElement
		// =============================================================

		void LegendElement::PaintElement(Draw& dw, int scale) {
			_B::PaintElementBckGround(dw, _B::GetFrame().GetSize(), style->lmntBackgnd  );
			DrawLegend(dw, scale);
		}

		void LegendElement::PaintFloatElement(Draw& dw, int scale){
			_B::PaintElementBckGround(dw, _B::GetFloatFrame().GetSize()*scale, style->lgdFloatBackgnd );
			DrawLegend(dw, scale);
		}

		void LegendElement::PrePaint( int scale ) {
			if (v_series==0) {
				v_series = &_B::_parent->GetSeries();
			}

			_legendWeight = 0;
			for (int c=0; c<(*v_series).GetCount(); ++c) {
				int textLength = GetTextSize((*v_series)[c].legend, style->lgdFont).cx;
				if(_legendWeight < textLength) _legendWeight = textLength;
			}
			_legendWeight += style->lgdStyleLength + style->lgdXSeparation;
		}

		void LegendElement::DrawLegend(Draw& w, const int scale) const
		{
			if (v_series==0) {
				String text = "LEGEND TEXT : no series defined";
				w.DrawText( 0,0 , text, style->lgdFont, SBlack());
				return;
			}

			int nmr = fround(_B::_frame.GetSize().cx/(_legendWeight*scale));	//max number of labels per row
			if (nmr <= 0) nmr = 1;
			int nLab = (*v_series).GetCount();	//number of labels
			int idx=0;
			int ix=0;
			int iy=0;
			Font scaledFont( style->lgdFont );
			int txtHeight = scaledFont.Height(scale * style->lgdFont.GetHeight() ).GetHeight();
			while (idx<nLab) {
				while ((idx<nLab) && ((*v_series)[idx].show == false )) { ++idx; }
				
				if (idx<nLab) {
					int x = scale*ix*_legendWeight + txtHeight/2;
					int y = iy*txtHeight + txtHeight/2;
					Image img = (*v_series)[idx].MakeSerieIcon(txtHeight, scale);
					w.DrawImage(x,y, img);
					Color txtColor;
					if (style->lgdTxtColor.IsNullInstance())
						txtColor = ((*v_series)[idx].seriesPlot.IsEmpty()) ? (*v_series)[idx].markColor : (*v_series)[idx].color;
					else
						txtColor = style->lgdTxtColor;
					
					DrawText(w, x+scale*(style->lgdStyleLength+2), y, 0, (*v_series)[idx].legend, scaledFont, txtColor );
					++idx;
				}
				++ix;
				if (ix>=nmr) { ix=0; ++iy; }
			}
		}


		// =============================================================
		//      MarkerElement
		// =============================================================
		void MarkerElementData::Link(MarkerElementData* m) {
			//GDLOGBLOCK("MarkerElementData::Link");
			if (m == 0)  return;
			if (linkedMarkers.Find(m) >= 0) return;
			linkedMarkers.Add( m );
			m->Link(this);
		}
	
		void MarkerElementData::Unlink(MarkerElementData* m) {
			//GDLOGBLOCK("MarkerElementData::Unlink  REQUESTED");
			if (m == 0)  return;
			if ((linkedMarkers.Find(m)) < 0) return;
			//LOG("MarkerElementData::Unlink  removing link  count=" << linkedMarkers.GetCount());
			linkedMarkers.RemoveKey( m );
			//LOG("MarkerElementData::Unlink  removed        count=" << linkedMarkers.GetCount());
			m->Unlink(this);
		}
	
		void MarkerElementData::UnlinkAll() {
			//GDLOGBLOCK("MarkerElementData::UnlinkAll");
			while( linkedMarkers.GetCount() > 0) {
				Unlink(linkedMarkers[0]);
			}
		}
		
		void MarkerElementData::UpdateLinked(TypeMarkerUpdateCbk& cbk) {
			//GDLOGBLOCK("MarkerElementData::UnlinkAll");
			for (int c=(linkedMarkers.GetCount()-1); c>=0; --c) {
				linkedMarkers[c]->pos = pos;
				cbk( linkedMarkers[c]->ID, owner );
			}
		}



		SmartTextTickMark&  MarkerElement::AddMarker(int markerId, TypeGraphCoord pos) {
			MarkerElementData& markData = markers.Add(markerId);
			markData = pos;
			return markData.CreateMarker<SmartTextTickMark>(markerId, this);
		}

		SmartTextTickMark&  MarkerElement::AddMarker(int markerId, const String txt, TypeGraphCoord pos) {
			MarkerElementData& markData = markers.Add(markerId);
			markData = pos;
			SmartTextTickMark& m = markData.CreateMarker<SmartTextTickMark>(markerId, this);
			m.SetText(txt);
			return m;
		}

		void  MarkerElement::SetElementPos(ElementPosition v) {
			if (v==LEFT_OF_GRAPH || v==RIGHT_OF_GRAPH) {
				_B::DisablePos(BOTTOM_OF_GRAPH);
				_B::DisablePos(TOP_OF_GRAPH);
			} else {
				_B::DisablePos(LEFT_OF_GRAPH);
				_B::DisablePos(RIGHT_OF_GRAPH);
			}
			_B::SetElementPos(v);
		}


		void MarkerElement::PaintHLine(Draw& dw, int range)
		{
			if ( ! (style->mrkLineColor.IsNullInstance()) )
			{
				MarkerPosList::Iterator iter = markers.Begin();
				MarkerPosList::ConstIterator endIter =  markers.End();
				while( iter != endIter)
				{
					MarkerElementData& markerData = *iter;
					if (_coordConverter.IsInGraphVisibleRange(markerData)) {
						const TypeScreenCoord y = _coordConverter.toScreen(markerData);
						dw.DrawLineOp( 0, y, range, y, style->mrkLineWidth, style->mrkLineColor );
					}
					++iter;
				}
			}
		}

		void MarkerElement::PaintVLine(Draw& dw, int range)
		{
			if (! (style->mrkLineColor.IsNullInstance()) )
			{
				MarkerPosList::Iterator iter = markers.Begin();
				MarkerPosList::ConstIterator endIter =  markers.End();
				while( iter != endIter)
				{
					MarkerElementData& markerData = *iter;
					if (_coordConverter.IsInGraphVisibleRange(markerData)) {
						const TypeScreenCoord x = _coordConverter.toScreen(markerData);
						dw.DrawLineOp( x, 0, x, range, style->mrkLineWidth, style->mrkLineColor );
					}
					++iter;
				}
			}
		}

		void MarkerElement::PaintElement(Draw& dw, int scale)
		{
			_B::PaintElementBckGround(dw, _B::GetFrame().GetSize(), style->lmntBackgnd );

			//dw.DrawLineOp(_B::GetElementWidth()*scale, _coordConverter.getScreenMin(), _B::GetElementWidth()*scale, _coordConverter.getScreenMax(), tyle->mrkLineWidth*scale, _color );
			MarkerPosList::Iterator iter = markers.Begin();
			MarkerPosList::ConstIterator endIter = markers.End();
			int c=0;
			while ( iter != endIter ) {
					MarkerElementData& markerData = *iter;
				if (_coordConverter.IsInGraphVisibleRange(markerData)) {
					switch( _B::GetElementPos() ) {
						case LEFT_OF_GRAPH:
							markerData.GetTickMark().Paint(dw, _B::GetElementPos(), scale, _B::GetElementWidth()*scale, _coordConverter.toScreen(markerData), style->mrkTickColor);
							break;
						case BOTTOM_OF_GRAPH:
							markerData.GetTickMark().Paint(dw, _B::GetElementPos(), scale, _coordConverter.toScreen(markerData), 0, style->mrkTickColor );
							break;
						case TOP_OF_GRAPH:
							markerData.GetTickMark().Paint(dw, _B::GetElementPos(), scale,  _coordConverter.toScreen(markerData), _B::GetElementWidth()*scale, style->mrkTickColor );
							break;
						case RIGHT_OF_GRAPH:
							markerData.GetTickMark().Paint(dw, _B::GetElementPos(), scale, 0, _coordConverter.toScreen(markerData), style->mrkTickColor );
							break;
						case FLOAT_OVER_GRAPH:
							break;
					}
				}
				++iter;
				++c;
			}
		}
		
		void MarkerElement::PaintOnPlot_overData(Draw& dw, int otherWidth, int scale)
		{
			switch( _B::GetElementPos() )
			{
				case LEFT_OF_GRAPH:
				case RIGHT_OF_GRAPH:
					PaintHLine(dw, otherWidth);
					break;
				case TOP_OF_GRAPH:
				case BOTTOM_OF_GRAPH:
					PaintVLine(dw, otherWidth);
					break;
				case FLOAT_OVER_GRAPH:
					break;
			}
			
		}
		// =============================================================
		//      Xxxxxxx
		// =============================================================

		// =============================================================
		//      Xxxxxxx
		// =============================================================

		// =============================================================
		//      Xxxxxxx
		// =============================================================

		// =============================================================
		//      Xxxxxxx
		// =============================================================

		// =============================================================
		//      Xxxxxxx
		// =============================================================

		// =============================================================
		//      Xxxxxxx
		// =============================================================

		// =============================================================
		//      Xxxxxxx
		// =============================================================


	
}}