#ifndef _GraphCtrl_Demo_CustomDataSource_WF_h_
#define _GraphCtrl_Demo_CustomDataSource_WF_h_

namespace Upp {
namespace GraphDraw_ns {
	// =========================================================
	//    TEST CLASSES
	// =========================================================
	class CustomData_WF : public CustomData {
		public:
			double dateDebut;
			double dateFin;
			double hauteur;
			int priorite;
			Value rectStyle;
			RectGraph rectGraphBound;
			bool isSelected;
			
			CustomData_WF(int deb, int fin, int prio=0, int haut=10, Value style=Color(113, 255, 255) )
			: dateDebut(deb)
			, dateFin(fin)
			, hauteur(haut)
			, priorite(prio)
			, rectStyle(style)
			, isSelected(false)
			{
				rectGraphBound.left = dateDebut;
				rectGraphBound.right = dateFin;
				rectGraphBound.bottom = 0;
				rectGraphBound.top = 1000;
			}
			
			CustomData_WF()
			: hauteur(.5)
			, priorite(0)
			, isSelected(false)
			{
				rectStyle = GraphCtrl_DemoImg::FW_IMG();
				rectGraphBound.SetNull();
			}
			virtual ~CustomData_WF() {}

			virtual bool Intersects(const RectGraph& graphView) const;
			virtual bool Contains(const PointGraph& pt) const;
			virtual void PaintDataPoint(BufferPainter& dw, int scale, const CoordinateConverter* xCoordConv, const CoordinateConverter* yCoordConv );
	};
	
	class CustomDataSource_WF : public CustomDataSource
	{
		enum {DATA_COUNT=6};
		CustomData_WF data[DATA_COUNT];
		public:
			CustomDataSource_WF() {}
			virtual ~CustomDataSource_WF() {}
			
			virtual unsigned int GetCount() const {return DATA_COUNT;};
			virtual const CustomData& Get(unsigned int dataIndex) const { return data[dataIndex]; }
			virtual       CustomData& Get(unsigned int dataIndex)       { return data[dataIndex]; }
			
			CustomData_WF& operator[](int dataIndex) { return data[dataIndex]; }

			virtual bool IsCtrlable() { return true; }
			virtual bool LeftDown   (unsigned int pIndex, PointGraph p, dword keyflags); // select / unselect
			virtual bool LeftDouble (unsigned int pIndex, PointGraph p, dword keyflags);
			virtual bool CursorImage(unsigned int pIndex, PointGraph p, dword keyflags, Image& outImg );
	};
};
};

#endif
