#ifndef _XmlView_svg2_XmlView2_h_
#define _XmlView_svg2_XmlView2_h_

#define AGG_RGBA32
#include <agg_aris_main/agg_aris_main.h>

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define IMAGEFILE  <XmlView_svg2/XmlView.iml>
#define IMAGECLASS XmlImg
#include <Draw/iml_header.h>

// AGG rendering buffer class - pointers to each row.

class ImagBuffer : public ImageBuffer {

public:
	RGBA GetPixel(int x, int y) const;
	void SetPixel(int x, int y, RGBA color);
	void SetPixel(int x, int y, Color color, int alpha = 255);
	void SetLineV(int x, int y, int height, RGBA rgba);

	bool IsEqualColumn(int x, int y, int height, RGBA rgba);
	Image CreateCopy(int x, int y, int width, int height);

	void Rectangalize(Draw& w, bool norect=true); //showrect for debug

//	void DrawRect(int x, int y, int cx, int cy, Color color, int alpha = 255);
//	ImagBuffer() {;}
};

RGBA ImagBuffer::GetPixel(int x, int y) const
{
	const RGBA *p=this[0] + y*GetSize().cx + x;
	return *p;
}

void ImagBuffer::SetPixel(int x, int y, RGBA color)
{
	RGBA *p = this[0] + y*GetSize().cx + x;
	*p=color;
}

void ImagBuffer::SetPixel(int x, int y, Color color, int alpha)
{
	RGBA ba;
	ba.a = alpha;
	ba.b = color.GetB();
	ba.r = color.GetR();
	ba.g = color.GetG();
	RGBA *p = this[0] + y*GetSize().cx + x;
//	p+=y*GetSize().cx+x;
	p->a=ba.a;
	p->r=ba.r;
	p->g=ba.g;
	p->b=ba.b;
}

bool ImagBuffer::IsEqualColumn(int x, int y, int height, RGBA rgba)
{
	RGBA *p = this[0] + (y+height-1)*GetSize().cx + x;
	
	while(height>0) {
		if (*p!=rgba) {
			return false;
		}
		p-=GetSize().cx;
		--height;
	}
	return true;
}

void ImagBuffer::SetLineV(int x, int y, int height, RGBA rgba)
{
	ASSERT(height>0);   //don't make height <=0 !!! later change to out of bounds...
	RGBA *p = this[0] + (y+height-1)*GetSize().cx + x;
	while(height>0) {
		*p=rgba;
		p-=GetSize().cx;
		--height;
	}
}

Image ImagBuffer::CreateCopy(int x, int y, int width, int height)
{
	ImageBuffer imgb(width,height);
	RGBA *src = this[0] + y *GetSize().cx+ x;
	int dy=0;
	while(--height >= 0) {
		memcpy(imgb[dy++] , src, width * sizeof(RGBA));
		src+=GetSize().cx;
	}
	return imgb;
}


void ImagBuffer::Rectangalize(Draw& w, bool norect) //showrect for DEBUG 
{
	Size bsz=GetSize();
	int cx=bsz.cx;
	int cy=bsz.cy;
	
	RGBA back=RGBA(Color(255,200,200));   //for backgfound blending
//	memset(uibuf, 255, cx * cy * 4); //!!!change or remove this for the background...


int x=0;
int y=0;
	int band=1;
int yy = 0;

	while(yy < cy) {  //going through each full horizontal 16 pix strip
		int ccy = min(cy - yy, 16); 
//		Image m = imgA.InitRender(aggTriangle(m_x,m_y), 0, -yy, 600, ccy);  //render some lines (rectangle of image)
		int x2 = 0;
		int x1 = 0;
		int ximg1 = -1;
		int ximg2 = -1;
		RGBA c;

		while(x2 < cx) {  //while inside a horizontal strip - going through each several times!!!
			c = GetPixel(x1, yy);

			while(IsEqualColumn(x2, yy, ccy, c) && x2 < cx) {
				++x2;  //end of a mono-rectangle
				}

			if(  (x2 - x1 > 0) && (x2 - x1 <= 16) ) { //first small mono-rectangle
				if( ximg2-ximg1 == 0 ) {
					ximg1=x1;  //start the very first small mono-rectangle as image series
				}
				ximg2=x2;
			}
		
			else  { 
				  if( x2 - x1 > 16 ) {
					if (ximg2-ximg1>0) {   // Step1 draw as accumulated image
						w.DrawImage( x + ximg1, y + yy, CreateCopy(ximg1, yy, ximg2 - ximg1, ccy) );
						ximg1=ximg2=-1;
					}
					//Step 2 draw mono-rectangle
					
					if (norect) {
//						RGBA c1=back;
//						AlphaBlend(&c1,&c, 1, 255, Color(c.r, c.g, c.b)); //Aris FIXME
						RGBA c1=c;
						w.DrawRect(x + x1, y + yy, x2 - x1, ccy, 
							Color(c1.r, c1.g, c1.b)); //Mirek's old TODO - Color RGBA conversion?
					}
				}
			}
			
			x1 = x2;  //x counter forward because we processed the solid part

			//below means pure image
			while(!IsEqualColumn( x2, yy, ccy, GetPixel(x2, yy)) && x2 < cx)
				x2++;
					
			if( x2 - x1 > 0) { //piece of image found
				if ( ximg2-ximg1 == 0 ) {
					ximg1 = x1;
					}
				ximg2 = x2;
				x1 = x2;  //x counter forward
				}

		}  //end of a strip

		if (ximg2-ximg1>0) {  //after the end of strip paint the image
			w.DrawImage( x + ximg1, y + yy, CreateCopy(ximg1, yy, ximg2 - ximg1, ccy));
			}
	
		yy += ccy;  //next strip
//		if (yy>=8) break;
	}  //end of all strips

}


class SvgView : public ParentCtrl
{

//	DocEdit doc;
public:
//	Option 			optrect;
	bool norect;  //debug
	ImagBuffer uibuf;
	virtual void Paint(Draw& w);
	
	typedef SvgView CLASSNAME;
	
//	void parse_svg(const char *fname);
	void parse_svg(String& result);
	void SetPath(agg::svg::path_renderer path);
	agg::svg::path_renderer m_path;
	
	SvgView();
};

class XmlView : public TopWindow {
public:
	virtual bool Key(dword key, int);
private:
	TreeCtrl              xml;
	LineEdit              view;
	FrameTop<StaticRect>  errorbg;
	Label                 error;
	FileList              files;
	ParentCtrl            data;
	Splitter              splitter1;
	Splitter              splitter2;
	SvgView            svgv;
	String                dir;
	String               result;

//	agg::svg::path_renderer        m_path;
	bool                          m_path_flag;
	agg::svg::path_tokenizer      m_tokenizer;

	void Load(int parent, XmlParser& p);
	void Load(const char *filename);
	void Enter();
	void DoDir();
		void start_element(String el, XmlParser& p);
		void end_element(String el, XmlParser& p);
		void parse_attr(XmlParser& p);  //this is only for g???

		void parse_style(const char* str);
		bool parse_name_value(const char* nv_start, const char* nv_end);

	void copy_name(const char* start, const char* end);
	void copy_value(const char* start, const char* end);
		char*          m_attr_name;
		char*          m_attr_value;
		unsigned       m_attr_name_len;
		unsigned       m_attr_value_len;
	bool parse_attr(const char* name, const char* value);
	void parse_path(XmlParser& p);
	void parse_rect(const char** attr);
	void parse_poly(XmlParser& p, bool close_flag);

	void parse_transform(const char* str);
	unsigned parse_matrix(const char* str);
	unsigned parse_translate(const char* str);
	unsigned parse_rotate(const char* str);
	unsigned parse_scale(const char* str);
	unsigned parse_skew_x(const char* str);

	unsigned parse_skew_y(const char* str);


public:
	typedef XmlView CLASSNAME;

	void Serialize(Stream& s);
	void LoadDir(const char *d);
	void LoadDir()                      { LoadDir(dir); }

	XmlView();
	~XmlView() {delete [] m_attr_name; delete m_attr_value;}
};

#endif
