#include "XmlView2.h"

#define IMAGEFILE  <XmlView_svg2/XmlView.iml>
#define IMAGECLASS XmlImg
#include <Draw/iml_source.h>



	struct named_color
	{
		char  name[22];
		agg::int8u r, g, b, a;
	};

	named_color colors[] = 
	{
		{ "aliceblue",240,248,255, 255 },
		{ "antiquewhite",250,235,215, 255 },
		{ "aqua",0,255,255, 255 },
		{ "aquamarine",127,255,212, 255 },
		{ "azure",240,255,255, 255 },
		{ "beige",245,245,220, 255 },
		{ "bisque",255,228,196, 255 },
		{ "black",0,0,0, 255 },
		{ "blanchedalmond",255,235,205, 255 },
		{ "blue",0,0,255, 255 },
		{ "blueviolet",138,43,226, 255 },
		{ "brown",165,42,42, 255 },
		{ "burlywood",222,184,135, 255 },
		{ "cadetblue",95,158,160, 255 },
		{ "chartreuse",127,255,0, 255 },
		{ "chocolate",210,105,30, 255 },
		{ "coral",255,127,80, 255 },
		{ "cornflowerblue",100,149,237, 255 },
		{ "cornsilk",255,248,220, 255 },
		{ "crimson",220,20,60, 255 },
		{ "cyan",0,255,255, 255 },
		{ "darkblue",0,0,139, 255 },
		{ "darkcyan",0,139,139, 255 },
		{ "darkgoldenrod",184,134,11, 255 },
		{ "darkgray",169,169,169, 255 },
		{ "darkgreen",0,100,0, 255 },
		{ "darkgrey",169,169,169, 255 },
		{ "darkkhaki",189,183,107, 255 },
		{ "darkmagenta",139,0,139, 255 },
		{ "darkolivegreen",85,107,47, 255 },
		{ "darkorange",255,140,0, 255 },
		{ "darkorchid",153,50,204, 255 },
		{ "darkred",139,0,0, 255 },
		{ "darksalmon",233,150,122, 255 },
		{ "darkseagreen",143,188,143, 255 },
		{ "darkslateblue",72,61,139, 255 },
		{ "darkslategray",47,79,79, 255 },
		{ "darkslategrey",47,79,79, 255 },
		{ "darkturquoise",0,206,209, 255 },
		{ "darkviolet",148,0,211, 255 },
		{ "deeppink",255,20,147, 255 },
		{ "deepskyblue",0,191,255, 255 },
		{ "dimgray",105,105,105, 255 },
		{ "dimgrey",105,105,105, 255 },
		{ "dodgerblue",30,144,255, 255 },
		{ "firebrick",178,34,34, 255 },
		{ "floralwhite",255,250,240, 255 },
		{ "forestgreen",34,139,34, 255 },
		{ "fuchsia",255,0,255, 255 },
		{ "gainsboro",220,220,220, 255 },
		{ "ghostwhite",248,248,255, 255 },
		{ "gold",255,215,0, 255 },
		{ "goldenrod",218,165,32, 255 },
		{ "gray",128,128,128, 255 },
		{ "green",0,128,0, 255 },
		{ "greenyellow",173,255,47, 255 },
		{ "grey",128,128,128, 255 },
		{ "honeydew",240,255,240, 255 },
		{ "hotpink",255,105,180, 255 },
		{ "indianred",205,92,92, 255 },
		{ "indigo",75,0,130, 255 },
		{ "ivory",255,255,240, 255 },
		{ "khaki",240,230,140, 255 },
		{ "lavender",230,230,250, 255 },
		{ "lavenderblush",255,240,245, 255 },
		{ "lawngreen",124,252,0, 255 },
		{ "lemonchiffon",255,250,205, 255 },
		{ "lightblue",173,216,230, 255 },
		{ "lightcoral",240,128,128, 255 },
		{ "lightcyan",224,255,255, 255 },
		{ "lightgoldenrodyellow",250,250,210, 255 },
		{ "lightgray",211,211,211, 255 },
		{ "lightgreen",144,238,144, 255 },
		{ "lightgrey",211,211,211, 255 },
		{ "lightpink",255,182,193, 255 },
		{ "lightsalmon",255,160,122, 255 },
		{ "lightseagreen",32,178,170, 255 },
		{ "lightskyblue",135,206,250, 255 },
		{ "lightslategray",119,136,153, 255 },
		{ "lightslategrey",119,136,153, 255 },
		{ "lightsteelblue",176,196,222, 255 },
		{ "lightyellow",255,255,224, 255 },
		{ "lime",0,255,0, 255 },
		{ "limegreen",50,205,50, 255 },
		{ "linen",250,240,230, 255 },
		{ "magenta",255,0,255, 255 },
		{ "maroon",128,0,0, 255 },
		{ "mediumaquamarine",102,205,170, 255 },
		{ "mediumblue",0,0,205, 255 },
		{ "mediumorchid",186,85,211, 255 },
		{ "mediumpurple",147,112,219, 255 },
		{ "mediumseagreen",60,179,113, 255 },
		{ "mediumslateblue",123,104,238, 255 },
		{ "mediumspringgreen",0,250,154, 255 },
		{ "mediumturquoise",72,209,204, 255 },
		{ "mediumvioletred",199,21,133, 255 },
		{ "midnightblue",25,25,112, 255 },
		{ "mintcream",245,255,250, 255 },
		{ "mistyrose",255,228,225, 255 },
		{ "moccasin",255,228,181, 255 },
		{ "navajowhite",255,222,173, 255 },
		{ "navy",0,0,128, 255 },
		{ "oldlace",253,245,230, 255 },
		{ "olive",128,128,0, 255 },
		{ "olivedrab",107,142,35, 255 },
		{ "orange",255,165,0, 255 },
		{ "orangered",255,69,0, 255 },
		{ "orchid",218,112,214, 255 },
		{ "palegoldenrod",238,232,170, 255 },
		{ "palegreen",152,251,152, 255 },
		{ "paleturquoise",175,238,238, 255 },
		{ "palevioletred",219,112,147, 255 },
		{ "papayawhip",255,239,213, 255 },
		{ "peachpuff",255,218,185, 255 },
		{ "peru",205,133,63, 255 },
		{ "pink",255,192,203, 255 },
		{ "plum",221,160,221, 255 },
		{ "powderblue",176,224,230, 255 },
		{ "purple",128,0,128, 255 },
		{ "red",255,0,0, 255 },
		{ "rosybrown",188,143,143, 255 },
		{ "royalblue",65,105,225, 255 },
		{ "saddlebrown",139,69,19, 255 },
		{ "salmon",250,128,114, 255 },
		{ "sandybrown",244,164,96, 255 },
		{ "seagreen",46,139,87, 255 },
		{ "seashell",255,245,238, 255 },
		{ "sienna",160,82,45, 255 },
		{ "silver",192,192,192, 255 },
		{ "skyblue",135,206,235, 255 },
		{ "slateblue",106,90,205, 255 },
		{ "slategray",112,128,144, 255 },
		{ "slategrey",112,128,144, 255 },
		{ "snow",255,250,250, 255 },
		{ "springgreen",0,255,127, 255 },
		{ "steelblue",70,130,180, 255 },
		{ "tan",210,180,140, 255 },
		{ "teal",0,128,128, 255 },
		{ "thistle",216,191,216, 255 },
		{ "tomato",255,99,71, 255 },
		{ "turquoise",64,224,208, 255 },
		{ "violet",238,130,238, 255 },
		{ "wheat",245,222,179, 255 },
		{ "white",255,255,255, 255 },
		{ "whitesmoke",245,245,245, 255 },
		{ "yellow",255,255,0, 255 },
		{ "yellowgreen",154,205,50, 255 },
		{ "zzzzzzzzzzz",0,0,0, 0 }
	}; 

	//-------------------------------------------------------------
	int cmp_color(const void* p1, const void* p2)
	{
		return strcmp(((named_color*)p1)->name, ((named_color*)p2)->name);
	}

	//-------------------------------------------------------------
	agg::rgba8 parse_color(const char* str)
	{
		while(*str == ' ') ++str;
		unsigned c = 0;
		if(*str == '#')
		{
			sscanf(str + 1, "%x", &c);
			return agg::rgb8_packed(c);
		}
		else
		{
			named_color c;
			unsigned len = strlen(str);
			if(len > sizeof(c.name) - 1)
			{
				throw XmlError("parse_color: Invalid color name");
				//throw exception("parse_color: Invalid color name '%s'", str);
			}
			strcpy(c.name, str);
			const void* p = bsearch(&c, 
									colors, 
									sizeof(colors) / sizeof(colors[0]), 
									sizeof(colors[0]), 
									cmp_color);
			if(p == 0)
			{
				throw XmlError("parse_color: Invalid color name");
				//throw exception("parse_color: Invalid color name '%s'", str);
			}
			const named_color* pc = (const named_color*)p;
			return agg::rgba8(pc->r, pc->g, pc->b, pc->a);
		}
	}


double parse_double(const char* str)
{
	while(*str == ' ') ++str;
	return atof(str);
}
//-------------------------------------------------------------
	static bool is_numeric(char c)
	{
		return strchr("0123456789+-.eE", c) != 0;
	}

	void XmlView::start_element(String el, XmlParser& p)
	{
//		if(el=="title")   m_title_flag = true;                  else
		if(el=="g")      { svgv.m_path.push_attr(); parse_attr(p); } else  //not clinton, mcseem, xenia
		if(el=="path")
		{
			if(m_path_flag)
			{
				throw XmlError("start_element: We don't do Nested paths");
				//throw exception("start_element: Nested path");
			}
			svgv.m_path.begin_path();
			parse_path(p);
			svgv.m_path.end_path();
			m_path_flag = true;
		}
		else
//		if(el=="rect")    result<<"\n==RECT=="; /* parse_rect(p); */    //    else
//		if(el=="line")      parse_line(p);        else
		if(el=="polyline") {
			result<<("\nPOLYLINE ");
		 parse_poly(p, false);
		}
		  //else
//		if(el=="polygon")   parse_poly(p, true);
	} 


	//-------------------------------------------------------------
	void XmlView::parse_path(XmlParser& p)
	{
		int i;
		for(i = 0; i < p.GetAttrCount(); i++)
		{
			String attr=p.GetAttr(i);
			String attrText=p[i];

//			result << ' ' << p.GetAttr(i) << "=\"" << p[i] << "\"";

			if(attr== "d")
			{
				m_tokenizer.set_path_str(attrText);
				svgv.m_path.parse_path(m_tokenizer);	
			}
			else
			{
				parse_attr(attr, attrText);
				//parse_attr(p.GetAttr[i], p.GetAttr[i + 1]);
			}
		}
	}

	//------------------------------------------------------------------------
	void XmlView::end_element(String el, XmlParser& p)
	{
//		if(el=="title")  m_title_flag = false; else
		if(el=="g")      svgv.m_path.pop_attr();    else
		if(el=="path")   m_path_flag = false;
	}


	void XmlView::parse_attr(XmlParser& p)
	{
		int i;
		for(i = 0; i < p.GetAttrCount(); i++)
		{
			String attr=p.GetAttr(i);
			String attrText=p[i];

//			result << ' ' << p.GetAttr(i) << "=\"" << p[i] << "\"";

			if(attr== "style")
			{
				//result << ' ' << p.GetAttr(i) << "=\"" << p[i] << "\""<<"\n\n";				
				parse_style(attrText);
			}
			else
			{
				parse_attr(attr, attrText);
				//parse_attr(p.GetAttr[i], p.GetAttr[i + 1]);
			}
		}
	}
	

	//-------------------------------------------------------------
	void XmlView::parse_style(const char* str)
	{
		while(*str)
		{
			// Left Trim
			while(*str && isspace(*str)) ++str;
			const char* nv_start = str;
			while(*str && *str != ';') ++str;
			const char* nv_end = str;

			// Right Trim
			while(nv_end > nv_start && 
				(*nv_end == ';' || isspace(*nv_end))) --nv_end;
			++nv_end;

			parse_name_value(nv_start, nv_end);
			if(*str) ++str;
		}

	}


	//-------------------------------------------------------------
	bool XmlView::parse_name_value(const char* nv_start, const char* nv_end)
	{
		const char* str = nv_start;
		while(str < nv_end && *str != ':') ++str;

		const char* val = str;

		// Right Trim
		while(str > nv_start && 
			(*str == ':' || isspace(*str))) --str;
		++str;

		copy_name(nv_start, str);

		while(val < nv_end && (*val == ':' || isspace(*val))) ++val;
		
		copy_value(val, nv_end);
		return parse_attr(m_attr_name, m_attr_value);
	}

//-------------------------------------------------------------
	void XmlView::copy_name(const char* start, const char* end)
	{
		unsigned len = unsigned(end - start);
		if(m_attr_name_len == 0 || len > m_attr_name_len)
		{
			delete [] m_attr_name;
			m_attr_name = new char[len + 1];
			m_attr_name_len = len;
		}
		if(len) memcpy(m_attr_name, start, len);
		m_attr_name[len] = 0;
	}

//-------------------------------------------------------------
	bool XmlView::parse_attr(const char* name, const char* value)
	{
		if(strcmp(name, "style") == 0)
		{
			parse_style(value);
		}
		else
		if(strcmp(name, "fill") == 0)
		{
			if(strcmp(value, "none") == 0)
			{
				svgv.m_path.fill_none();
			}
			else
			{
			//	result<<("\n======color=========\n");
				svgv.m_path.fill(parse_color(value));
			}
		}
		else
		if(strcmp(name, "fill-opacity") == 0)
		{
			svgv.m_path.fill_opacity(parse_double(value));
		}
		else
		if(strcmp(name, "stroke") == 0)
		{
			if(strcmp(value, "none") == 0)
			{
				svgv.m_path.stroke_none();
			}
			else
			{
				svgv.m_path.stroke(parse_color(value));
			}
		}
		else
		if(strcmp(name, "stroke-width") == 0)
		{
			svgv.m_path.stroke_width(parse_double(value));
		}
		else
		if(strcmp(name, "stroke-linecap") == 0)
		{
//			if(strcmp(value, "butt") == 0)        svgv.m_path.line_cap(butt_cap);
//			else if(strcmp(value, "round") == 0)  svgv.m_path.line_cap(round_cap);
//			else if(strcmp(value, "square") == 0) svgv.m_path.line_cap(square_cap);
		}
		else
		if(strcmp(name, "stroke-linejoin") == 0)
		{
//			if(strcmp(value, "miter") == 0)      svgv.m_path.line_join(miter_join);
//			else if(strcmp(value, "round") == 0) svgv.m_path.line_join(round_join);
//			else if(strcmp(value, "bevel") == 0) svgv.m_path.line_join(bevel_join);
		}
		else
		if(strcmp(name, "stroke-miterlimit") == 0)
		{
			svgv.m_path.miter_limit(parse_double(value));
		}
		else
		if(strcmp(name, "stroke-opacity") == 0)
		{
			svgv.m_path.stroke_opacity(parse_double(value));
		}
		else
		if(strcmp(name, "transform") == 0)
		{
			parse_transform(value);
		}
		//else
		//if(strcmp(el, "<OTHER_ATTRIBUTES>") == 0) 
		//{
		//}
		// . . .
		else
		{
			return false;
		}
		return true;
	}


	//-------------------------------------------------------------
	void XmlView::copy_value(const char* start, const char* end)
	{
		unsigned len = unsigned(end - start);
		if(m_attr_value_len == 0 || len > m_attr_value_len)
		{
			delete [] m_attr_value;
			m_attr_value = new char[len + 1];
			m_attr_value_len = len;
		}
		if(len) memcpy(m_attr_value, start, len);
		m_attr_value[len] = 0;
	}

//-------------------------------------------------------------
	void XmlView::parse_rect(const char** attr)
	{
		int i;
		double x = 0.0;
		double y = 0.0;
		double w = 0.0;
		double h = 0.0;

		svgv.m_path.begin_path();
		for(i = 0; attr[i]; i += 2)
		{
			if(!parse_attr(attr[i], attr[i + 1]))
			{
				if(strcmp(attr[i], "x") == 0)      x = parse_double(attr[i + 1]);
				if(strcmp(attr[i], "y") == 0)      y = parse_double(attr[i + 1]);
				if(strcmp(attr[i], "width") == 0)  w = parse_double(attr[i + 1]);
				if(strcmp(attr[i], "height") == 0) h = parse_double(attr[i + 1]);
				// rx - to be implemented 
				// ry - to be implemented
			}
		}


		if(w != 0.0 && h != 0.0)
		{
			if(w < 0.0) throw XmlError("parse_rect: Invalid width:");
			if(h < 0.0) throw XmlError("parse_rect: Invalid height:");

			svgv.m_path.move_to(x,     y);
			svgv.m_path.line_to(x + w, y);
			svgv.m_path.line_to(x + w, y + h);
			svgv.m_path.line_to(x,     y + h);
			svgv.m_path.close_subpath();
		}
		svgv.m_path.end_path();
	}

#if 0
	//-------------------------------------------------------------
	void parser::parse_line(const char** attr)
	{
		int i;
		double x1 = 0.0;
		double y1 = 0.0;
		double x2 = 0.0;
		double y2 = 0.0;

		svgv.m_path.begin_path();
		for(i = 0; attr[i]; i += 2)
		{
			if(!parse_attr(attr[i], attr[i + 1]))
			{
				if(strcmp(attr[i], "x1") == 0) x1 = parse_double(attr[i + 1]);
				if(strcmp(attr[i], "y1") == 0) y1 = parse_double(attr[i + 1]);
				if(strcmp(attr[i], "x2") == 0) x2 = parse_double(attr[i + 1]);
				if(strcmp(attr[i], "y2") == 0) y2 = parse_double(attr[i + 1]);
			}
		}

		svgv.m_path.move_to(x1, y1);
		svgv.m_path.line_to(x2, y2);
		svgv.m_path.end_path();
	}
#endif
//#if 0
	//-------------------------------------------------------------
	void XmlView::parse_poly(XmlParser& p, bool close_flag)
	{
		double x = 0.0;
		double y = 0.0;

		svgv.m_path.begin_path();

		int i;
		for(i = 0; i < p.GetAttrCount(); i++)
		{
			String attr=p.GetAttr(i);
			String attrText=p[i];

//			result << ' ' << p.GetAttr(i) << "=\"" << p[i] << "\"";

			if(attr== "points")
			{
				result  << p.GetAttr(i) << "=\"" << attrText << "\""<<"\n\n";				
					m_tokenizer.set_path_str(attrText);
					if(!m_tokenizer.next())
					{
						throw XmlError("parse_poly: Too few coordinates");
					}
					x = m_tokenizer.last_number();
					if(!m_tokenizer.next())
					{
						throw XmlError("parse_poly: Too few coordinates");
					}
					y = m_tokenizer.last_number();
					svgv.m_path.move_to(x, y);
					while(m_tokenizer.next())
					{
						x = m_tokenizer.last_number();
						if(!m_tokenizer.next())
						{
							throw XmlError("parse_poly: Odd number of coordinates");
						}
						y = m_tokenizer.last_number();
						svgv.m_path.line_to(x, y);
					}
			}
			else
			{
				//throw XmlError("parse_poly: Check other attributes than points");
				parse_attr(attr, attrText);
				//parse_attr(p.GetAttr[i], p.GetAttr[i + 1]);
			}
		}
		
		if(close_flag) 
		{
			svgv.m_path.close_subpath();
		}
		svgv.m_path.end_path();
	}

//#endif

	//-------------------------------------------------------------
	void XmlView::parse_transform(const char* str)
	{
		while(*str)
		{
			if(islower(*str))
			{
				if(strncmp(str, "matrix", 6) == 0)    str += parse_matrix(str);    else 
				if(strncmp(str, "translate", 9) == 0) str += parse_translate(str); else 
				if(strncmp(str, "rotate", 6) == 0)    str += parse_rotate(str);    else 
				if(strncmp(str, "scale", 5) == 0)     str += parse_scale(str);     else 
				if(strncmp(str, "skewX", 5) == 0)     str += parse_skew_x(str);    else 
				if(strncmp(str, "skewY", 5) == 0)     str += parse_skew_y(str);    else
				{
					++str;
				}
			}
			else
			{
				++str;
			}
		}
	}


	//-------------------------------------------------------------
	static unsigned parse_transform_args(const char* str, 
										double* args, 
										unsigned max_na, 
										unsigned* na)
	{
		*na = 0;
		const char* ptr = str;
		while(*ptr && *ptr != '(') ++ptr;
		if(*ptr == 0)
		{
			throw XmlError("parse_transform_args: Invalid syntax");
		}
		const char* end = ptr;
		while(*end && *end != ')') ++end;
		if(*end == 0)
		{
			throw XmlError("parse_transform_args: Invalid syntax");
		}

		while(ptr < end)
		{
			if(is_numeric(*ptr))
			{
				if(*na >= max_na)
				{
					throw XmlError("parse_transform_args: Too many arguments");
				}
				args[(*na)++] = atof(ptr);
				while(ptr < end && is_numeric(*ptr)) ++ptr;
			}
			else
			{
				++ptr;
			}
		}
		return unsigned(end - str);
	}

	//-------------------------------------------------------------
	unsigned XmlView::parse_matrix(const char* str)
	{
		double args[6];
		unsigned na = 0;
		unsigned len = parse_transform_args(str, args, 6, &na);
		if(na != 6)
		{
			throw XmlError("parse_matrix: Invalid number of arguments");
		}
		svgv.m_path.transform().premultiply(agg::trans_affine(args[0], args[1], args[2], args[3], args[4], args[5]));
		return len;
	}

	//-------------------------------------------------------------
	unsigned XmlView::parse_translate(const char* str)
	{
		double args[2];
		unsigned na = 0;
		unsigned len = parse_transform_args(str, args, 2, &na);
		if(na == 1) args[1] = 0.0;
		svgv.m_path.transform().premultiply(agg::trans_affine_translation(args[0], args[1]));
		return len;
	}

	//-------------------------------------------------------------
	unsigned XmlView::parse_rotate(const char* str)
	{
		double args[3];
		unsigned na = 0;
		unsigned len = parse_transform_args(str, args, 3, &na);
		if(na == 1) 
		{
			svgv.m_path.transform().premultiply(agg::trans_affine_rotation(agg::deg2rad(args[0])));
		}
		else if(na == 3)
		{
			agg::trans_affine t = agg::trans_affine_translation(-args[1], -args[2]);
			t *= agg::trans_affine_rotation(agg::deg2rad(args[0]));
			t *= agg::trans_affine_translation(args[1], args[2]);
			svgv.m_path.transform().premultiply(t);
		}
		else
		{
			throw XmlError("parse_rotate: Invalid number of arguments");
		}
		return len;
	}

	//-------------------------------------------------------------
	unsigned XmlView::parse_scale(const char* str)
	{
		double args[2];
		unsigned na = 0;
		unsigned len = parse_transform_args(str, args, 2, &na);
		if(na == 1) args[1] = args[0];
		svgv.m_path.transform().premultiply(agg::trans_affine_scaling(args[0], args[1]));
		return len;
	}

	//-------------------------------------------------------------
	unsigned XmlView::parse_skew_x(const char* str)
	{
		double arg;
		unsigned na = 0;
		unsigned len = parse_transform_args(str, &arg, 1, &na);
		svgv.m_path.transform().premultiply(agg::trans_affine_skewing(agg::deg2rad(arg), 0.0));
		return len;
	}

	//-------------------------------------------------------------
	unsigned XmlView::parse_skew_y(const char* str)
	{
		double arg;
		unsigned na = 0;
		unsigned len = parse_transform_args(str, &arg, 1, &na);
		svgv.m_path.transform().premultiply(agg::trans_affine_skewing(0.0, agg::deg2rad(arg)));
		return len;
	}



void XmlView::Load(int parent, XmlParser& p)
{
	if(p.IsTag()) {
		String tag = p.ReadTag();
		String txt=tag;
//	if (tag=="title") {
//			result<<("\n"+tag+" TAG START"+"n") ;
//	}
		start_element(tag,p);
		for(int i = 0; i < p.GetAttrCount(); i++) {
			txt << ' ' << p.GetAttr(i) << "=\"" << p[i] << "\"";
		//	result<<(txt+"ATTR="+AsString(i)+"\n\n");
		}
		parent = xml.Add(parent, XmlImg::Tag(), txt);
		while(!p.End()) {
		//	result<<("p[0]="+p[0]+"\n");
			if(p.IsEof())
				throw XmlError("");
			Load(parent, p);
		}
		end_element(tag,p);
//	if (tag=="title")
//		result<<("\n"+tag+" TAG ENDn");
	}
	else
	if(p.IsText())  //add title handling here!!!
		xml.Add(parent, XmlImg::Text(), NormalizeSpaces(p.ReadText()));
	else
	if(p.IsPI())
		xml.Add(parent, XmlImg::PI(), NormalizeSpaces(p.ReadPI()));
	else
	if(p.IsDecl())
		xml.Add(parent, XmlImg::Decl(), NormalizeSpaces(p.ReadDecl()));
	else
	if(p.IsComment())
		xml.Add(parent, XmlImg::Comment(), NormalizeSpaces(p.ReadComment()));
	else
		NEVER();
}

void XmlView::Load(const char *filename)
{
	Title(filename);
	int64 l = GetFileLength(filename);
	if(l < 0 || l > 16000000)
		return;
	svgv.m_path.remove_all();  //clean 

	String txt = LoadFile(filename);
	XmlParser p(txt);
	xml.Clear();
	try {
		while(!p.IsEof())
			Load(0, p);
	}
	catch(XmlError e) {
		error = "XML parsing error: " + e;
		DUMP(error.GetScreenRect());
		view.Show();
		view <<= txt;
		view.SetCursor(view.GetPos(p.GetLine() - 1, p.GetColumn() - 1));
		view.SetFocus();
		return;
	}
	xml.Show();
//	xml.SetFocus();
	//aris
	svgv.parse_svg(result);

	result.Clear();
}

void XmlView::LoadDir(const char *d)
{
	files.Clear();
	dir = d;
#ifdef PLATFORM_WIN32
	if(dir.GetLength())
#else
	if(dir.GetLength() > 1)
#endif
		files.Add("..", CtrlImg::DirUp(), StdFont(), SColorText(), true);
	::Load(files, dir, "*.*");
	SortByExt(files);
}

void XmlView::Enter()
{
	if(!files.IsCursor())
		return;
	const FileList::File& f = files.Get(files.GetCursor());
	xml.Hide();
	view.Hide();
	if(!f.isdir)
		Load(AppendFileName(dir, f.name));
}

void XmlView::DoDir()
{
	if(!files.IsCursor())
		return;
	const FileList::File& f = files.Get(files.GetCursor());
	if(!f.isdir)
		return;
	if(f.name == "..") {
		String n = DirectoryUp(dir);
		LoadDir(dir);
		files.FindSetCursor(n);	
	}
	else
		LoadDir(AppendFileName(dir, f.name));
}

bool XmlView::Key(dword key, int)
{
	if(key == K_ENTER) {
		DoDir();
		return true;
	}
	return false;
}

void XmlView::Serialize(Stream& s)
{
	int version = 0;
	s / version;
	SerializePlacement(s);
	s % files;
	s % dir;
	s % splitter1;
}

XmlView::XmlView()
{
	xml.NoRoot();

	error.SetFont(Arial(20)).SetInk(Red);
	errorbg.Height(25).Add(error.SizePos());
	view.AddFrame(errorbg);
	view.SetReadOnly();
	view.SetColor(LineEdit::PAPER_READONLY, SColorPaper());

	xml.Hide();
	view.Hide();

	data.Add(xml.SizePos());
	data.Add(view.SizePos());

	splitter1.Horz(files, data.SizePos());
	splitter1.SetPos(1000);
//	Add(splitter1.SizePos());

	splitter2.Horz(splitter1, svgv.SizePos());
	splitter2.SetPos(4000);	
	Add(splitter2);
	
	files.WhenEnterItem = THISBACK(Enter);
	files.WhenLeftDouble = THISBACK(DoDir);

	Sizeable().Zoomable();
	
//	dir = GetCurrentDirectory();

	
	Icon(XmlImg::Icon());
	BackPaint();
	m_path_flag=false;
	m_attr_name=new char[128];
		m_attr_value=new char[1024];
		m_attr_name_len=127;
		m_attr_value_len=1023;
}

void SvgView::Paint(Draw& w)
{
	uibuf.Create(500,500);

		typedef agg::pixfmt_bgra32 pixfmt;
		typedef agg::renderer_base<pixfmt> renderer_base;
		typedef agg::renderer_scanline_aa_solid<renderer_base> renderer_solid;

	agg::rendering_buffer rbuf;

	Size bsz=uibuf.GetSize();
	int cx=bsz.cx;
	int cy=bsz.cy;
	rbuf.attach((agg::int8u *)uibuf[0], cx, cy, cx*4); //THIS IS THE MAIN agg and upp CONNECTION!!!
		pixfmt pixf(rbuf);
		
		renderer_base rb(pixf);
		renderer_solid ren(rb);

		rb.clear(agg::rgba(1,1,1));

		agg::rasterizer_scanline_aa<> ras;
		agg::scanline_p8 sl;
		agg::trans_affine mtx;

//		ras.gamma(agg::gamma_power(m_gamma.value()));
//		mtx *= agg::trans_affine_translation((m_min_x + m_max_x) * -0.5, (m_min_y + m_max_y) * -0.5);
//		mtx *= agg::trans_affine_scaling(m_scale.value());
//		mtx *= agg::trans_affine_rotation(agg::deg2rad(m_rotate.value()));
//		mtx *= agg::trans_affine_translation((m_min_x + m_max_x) * 0.5 + m_x, (m_min_y + m_max_y) * 0.5 + m_y + 30);
		

//		m_path.expand(m_expand.value());

//		start_timer();
		m_path.render(ras, sl, ren, mtx, rb.clip_box(), 1.0);
		double tm; // = elapsed_time();
		unsigned vertex_count = m_path.vertex_count();

//		ras.gamma(agg::gamma_none());

//Controls
//		agg::render_ctrl(ras, sl, rb, m_expand);
//		agg::render_ctrl(ras, sl, rb, m_gamma);
//		agg::render_ctrl(ras, sl, rb, m_scale);
//		agg::render_ctrl(ras, sl, rb, m_rotate);


		char buf[128]; 
		agg::gsv_text t;
		t.size(10.0);
		t.flip(true);

		agg::conv_stroke<agg::gsv_text> pt(t);
		pt.width(1.5);

		sprintf(buf, "Vertices=%d Time=%.3f ms", vertex_count, tm);

		t.start_point(10.0, 40.0);
		t.text(buf);

		ras.add_path(pt);
		ren.color(agg::rgba(0,0,0));
		agg::render_scanlines(ras, sl, ren);


		//agg::gamma_lut<> gl(m_gamma.value());
		//unsigned x, y;
		//unsigned w = unsigned(width());
		//unsigned h = unsigned(height());
		//for(y = 0; y < h; y++)
		//{
		//    for(x = 0; x < w; x++)
		//    {
		//        agg::rgba8 c = rb.pixel(x, y);
		//        c.r = gl.inv(c.r);
		//        c.g = gl.inv(c.g);
		//        c.b = gl.inv(c.b);
		//        rb.copy_pixel(x, y, c);
		//    }
		//}
	uibuf.Rectangalize(w, norect);
//	w.DrawLine(Point(0,0),Point(100,100),2);
	uibuf.Clear();
}

SvgView::SvgView()
{
	norect = true;
//	Add(doc.SizePos());
//	m_path();
}

void SvgView::SetPath(agg::svg::path_renderer path)
{
//	m_path=path;
}

void SvgView::parse_svg(String& result)
{
//	String result=fname;
//	doc.Set(result);
//		agg::svg::parser p(m_path);
//	String error1=	p.load_parse(fname,result);
//	PromptOK(result);
		m_path.arrange_orientations();
//		m_path.bounding_rect(&m_min_x, &m_min_y, &m_max_x, &m_max_y);
//		caption(p.title());
Refresh();
}


GUI_APP_MAIN
{
	XmlView x;
	LoadFromFile(x);
	x.LoadDir(GetHomeDirectory()+"/svg_examples");
	x.Run();
	StoreToFile(x);
}
