#include "MultiWindow.h"

void MultiWindow::MainMenu(Bar& bar)
{
	bar.Sub(t_("File"), THISFN(FileMenu));
	bar.Sub(t_("Windows"), THISFN(WindowMenu));
}

void MultiWindow::FileMenu(Bar& bar)
{
	bar.Add(t_("Exit"), THISFN(Close));
}

void MultiWindow::WindowMenu(Bar& bar)
{
	bar.Add(t_("Forms"),  [=]{ if(!fwin.IsOpen()) fwin.Open(this); }).Key(K_CTRL_F);
	bar.Add(t_("Editor"), [=]{ if(!ewin.IsOpen()) ewin.Open(this); }).Key(K_CTRL_E);
}

MultiWindow::MultiWindow()
{
	CtrlLayout(*this, "Window title");
	AddFrame(mainmenu);
	mainmenu.Set(THISFN(MainMenu));
}

bool MultiWindow::Key(dword key, int count)
{
	if(key == K_CTRL_E && !ewin.IsOpen())
		ewin.Open(this);
	else
	if(key == K_CTRL_F && !fwin.IsOpen())
		fwin.Open(this);
	return false;
}

GUI_APP_MAIN
{
	MultiWindow().Run();
}
