#include "simple.h"

#ifdef _DEBUG
#include <Sql/sch_schema.h>
#endif

#include <Sql/sch_source.h>

CONSOLE_APP_MAIN
{
	StdLogSetup(LOG_COUT|LOG_FILE);

	LOG("-- Starting new run of Sqlite3 simple test");
#ifdef _DEBUG
	LOG("Debug mode!");
#endif

	Sqlite3Session sqlite3;
	sqlite3.LogErrors(true);
	if(!sqlite3.Open(ConfigFile("simple.db"))) {
		LOG("Can't create or open database file\n");
		return;
	}

	SQL = sqlite3;

	// Update the schema to match the schema described in "simple.sch"
#ifdef _DEBUG
	SqlSchema sch(SQLITE3);
	All_Tables(sch);
	if(sch.ScriptChanged(SqlSchema::UPGRADE))
		SqlPerformScript(sch.Upgrade());
	if(sch.ScriptChanged(SqlSchema::ATTRIBUTES)) {
		SqlPerformScript(sch.Attributes());
	}
	if(sch.ScriptChanged(SqlSchema::CONFIG)) {
		SqlPerformScript(sch.ConfigDrop());
		SqlPerformScript(sch.Config());
	}
	sch.SaveNormal();
#endif

	// Now test out some functionality:
	//--------------------------------------------------------------------
	// Get the list of tables
	Vector<String> table_list = sqlite3.EnumTables("");
	LOG(Format("Tables: (%d)",table_list.GetCount()));
	for (int i = 0; i < table_list.GetCount(); ++i)
		LOG(Format("  #%d: %s",i+1,table_list[i]));


	S_SIMPLE_TEST1 row;
	Sql sql;

	// Test basic insertion:
	// (check buglog for errors about duplicate entries if you run this more
	//  than once on the same db!)
	sql*Insert(SIMPLE_TEST1)(ID,0)(NAME,"Joe")(LASTNAME,"Smith")(BDATE, GetSysDate());

	sql*SelectAll().From(SIMPLE_TEST1);
	while(sql.Fetch())
		DDUMP(sql.GetRow());

	SetLanguage(LNG_('C','S','C','Z'));
	sql*SelectAll().From(SIMPLE_TEST1);
	while(sql.Fetch())
		DDUMP(sql.GetRow());
}
