/* __guido__@web.de */

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

FileSel& NeatpadFs()
{
	static FileSel fs;
	return fs;
}

class Neatpad : public TopWindow {
protected:
	TextCtrl   editor;
	MenuBar    menubar;
	StatusBar  statusbar;
	String     filename;
	
	void Load(const String& filename);
	void New();
	void Open();
	void Save();
	void SaveAs();
	void Print();
	void About();
	void Destroy();
	//void SetBar();
	void FileBar(Bar& bar);
	void AboutMenu(Bar& bar);
	void MainMenu(Bar& bar);
	void MainBar(Bar& bar);

public:
	typedef Neatpad CLASSNAME;

	Neatpad();
};

void Neatpad::FileBar(Bar& bar)
{
	bar.Add("New", CtrlImg::new_doc(), THISBACK(New))
	   .Key(K_CTRL_N)
	   .Help("Open new window");
	bar.Add("Open..", CtrlImg::open(), THISBACK(Open))
	   .Key(K_CTRL_O)
	   .Help("Open existing document");
	bar.Add(editor.IsModified(), "Save", CtrlImg::save(), THISBACK(Save))
	   .Key(K_CTRL_S)
	   .Help("Save current document");
	bar.Add("SaveAs", CtrlImg::save_as(), THISBACK(SaveAs))
	   .Help("Save current document with a new name");
	bar.ToolGap();
	bar.MenuSeparator();
	bar.Add("Print..", CtrlImg::print(), THISBACK(Print))
	   .Key(K_CTRL_P)
	   .Help("Print document");
	if(bar.IsMenuBar()) {
		bar.Separator();
		bar.Add("Exit", THISBACK(Destroy));
	}
}

void Neatpad::AboutMenu(Bar& bar)
{
	bar.Add("About..", THISBACK(About));
	bar.Separator();
	bar.Add("What is this ?", callback(PerformDescription))
	   .Key(K_SHIFT_F1);
}

void Neatpad::MainMenu(Bar& bar)
{
	bar.Add("File", THISBACK(FileBar));
	bar.Add("Window", callback(WindowsMenu));
	bar.Add("Help", THISBACK(AboutMenu));
}

void Neatpad::New()
{
	new Neatpad;
}

void Neatpad::Load(const String& name)
{
	editor.SetData(LoadFile(name));
	filename = name;
	editor.ClearModify();
	Title(filename);
}

void Neatpad::Open()
{
	FileSel& fs = NeatpadFs();
	if(fs.ExecuteOpen())
		if(filename.IsEmpty() && !editor.IsModified())
			Load(fs);
		else
			(new Neatpad)->Load(fs);
	else
		statusbar.Temporary("Loading aborted.");
}

void Neatpad::Save()
{
	if(!editor.IsModified()) return;
	if(filename.IsEmpty())
		SaveAs();
	else
		if(SaveFile(filename, editor.GetData())) {
			statusbar.Temporary("File " + filename + " was saved.");
			ClearModify();
		}
		else
			Exclamation("Error saving the file [* " + filename + "]!");
}

void Neatpad::SaveAs()
{
	FileSel& fs = NeatpadFs();
	if(fs.ExecuteSaveAs()) {
		filename = fs;
		Title(filename);
		Save();
	}
}

void Neatpad::Print()
{
	//editor.Print();
}


void Neatpad::About()
{
	PromptOK("[A5 Neatpad]&Using [*^www://upp.sf.net^ Ultimate`+`+] technology.");
	PromptOK(GetExeFilePath());
}

void Neatpad::Destroy()
{
	if(editor.IsModified()) {
		switch(PromptYesNoCancel("Do you want to save the changes to the document?")) {
		case 1:
			Save();
			break;
		case -1:
			return;
		}
	}
		
	delete this;
}

void Neatpad::MainBar(Bar& bar)
{
	FileBar(bar);
}


Neatpad::Neatpad()
{
	AddFrame(menubar);
	AddFrame(statusbar);
	Add(editor.SizePos());
	menubar.Set(THISBACK(MainMenu));
	Sizeable().Zoomable();
	WhenClose = THISBACK(Destroy);
	menubar.WhenHelp = statusbar;
	static int doc;
	Title(Format("Document%d", ++doc));
	Icon(CtrlImg::File());
	editor.ClearModify();
	OpenMain();
	ActiveFocus(editor);
}

void SerializeApp(Stream& s)
{
	int version = 0;
	s / version;
	s % NeatpadFs();
}

GUI_APP_MAIN
{
	SetLanguage(LNG_ENGLISH);

	NeatpadFs().AllFilesType();
	         
	LoadFromFile(callback(SerializeApp));
	new Neatpad;
	Ctrl::EventLoop();
	StoreToFile(callback(SerializeApp));
}
