#include <CtrlLib/CtrlLib.h>
#include <MtAlt/MtAlt.h>
#include <MtAlt/SysCFG.h>
#include <deque>
#include <Core/Core.h>
#include <Core/Rpc/Rpc.h>


#include "Worker.h"
#include "RegionalCtrl.h"

using namespace Upp;
using namespace std;

class MainWindow : public WithMainLayout<TopWindow>
{
public:	
	typedef MainWindow CLASSNAME;
	MainWindow();
	virtual ~MainWindow();
private:
	Vector<RegionalCtrl*> ctrl;
};

MainWindow::MainWindow()
{
	CtrlLayout(*this, "Regional Controller");	
	
	//Get XML config here;
	SysCFG sysCFG;
	sysCFG.Load();
//	sysCFG.Save();
	
	for(int i = 0; i < sysCFG.Junctions.GetCount(); i++)
	{
		String JctName = sysCFG.Junctions.GetKey(i);
		Local_Controller local_rcd = sysCFG.Junctions[i];
		
		RegionalCtrl *temp = new RegionalCtrl(local_rcd);
		ctrl.Add(temp);
		tabs.Add((*temp).SizePos(), JctName);
	}

}

MainWindow::~MainWindow()
{
	for(auto q = ctrl.begin(), e = ctrl.end(); q != e; q++)
		if(*q) delete (*q);
}

GUI_APP_MAIN
{
	MainWindow().Sizeable().Run();
}


