#ifndef _LocalCtrl_SysCFG_h_
#define _LocalCtrl_SysCFG_h_

struct SubSystem : Moveable<SubSystem>
{
	int nID;
	String strIP;
	int nPort;
	
	void Xmlize(XmlIO& xml);
};

void SubSystem::Xmlize(XmlIO& xml)
{
	xml
		("id", nID)
		("IP", strIP)
		("Port", nPort)
		;
}

struct Local_Controller : Moveable<Local_Controller>
{
	int nID;
	String strIP;
	int nPort;
	String cfgFileName;
	
	SubSystem subSys;
	void Xmlize(XmlIO& xml);
};

void Local_Controller::Xmlize(XmlIO& xml)
{
	xml
		("id", nID)
		("IP", strIP)
		("Port", nPort)
		("cfgFileName", cfgFileName)
		("SubSystem", subSys)
		;
}

struct SysCFG : Moveable<SysCFG>
{
	VectorMap<String, Local_Controller>  Junctions;
	
	void Load();
	void Save();
	void Xmlize(XmlIO& xml);
};

void SysCFG::Xmlize(XmlIO& xml)
{
	xml
		("Master_CFG", Junctions)
	;
}

void SysCFG::Load()
{
	LoadFromXMLFile(*this, "Main.XML");
}

void SysCFG::Save()
{
	StoreAsXMLFile(*this, "Junctions", "Main.XML");
}

#endif
