#ifndef _RegionalCtrl_RegionalCtrl_h_
#define _RegionalCtrl_RegionalCtrl_h_

#include <CtrlLib/CtrlLib.h>
#include <MtAlt/MtAlt.h>
#include <MtAlt/SysCFG.h>
#include <deque>
#include <Core/Core.h>

using namespace Upp;
using namespace std;

#define LAYOUTFILE <RegionalCtrl/RegionalCtrl.lay>
#include <CtrlCore/lay.h>

const int nAlgoInterval = 1000; //Interval to simulate algo decision
const int nDataInterval = 1000; //Interval to read sensor status
const int nHotDataSize = 500; //Data for Algo
const int nMinSaveRCD = 500; //Data size to trigger disk save operation
const int nLoggerSnap = 30000; //logger snap time;
const String strSaveFileName = "History.log";

//thread GUI (main application thread)
class RegionalCtrl : public WithRegionalCtrlLayout<ParentCtrl>, public CallbackQueue, public UdpRpcCmder::Notify, public TcpRpcCmder::Notify
{
	typedef RegionalCtrl CLASSNAME;
public: //thread GUI
	RegionalCtrl(Local_Controller ctrl_cfg);
	
public: //thread Worker
	virtual void OnReplyUdpRpcCmd(String string, int x2, String s) {Request(&RegionalCtrl::SaveRpcCmdResult,string,x2,s);}
	virtual void OnReplyTcpRpcCmd(String string, int x2, String s) {Request(&RegionalCtrl::SaveTcpRpcCmdResult,string,x2,s);}

private:
	void UdpRpcCmd(UrrRequest r) {udpRpcCmder.Request(&UdpRpcCmder::UdpRpcCmd, r);}
	void UdpRpcCmd(String strIP, int nPort, int nCmd) {udpRpcCmder.Request(&UdpRpcCmder::UdpCmd, strIP, nPort, nCmd);}
	void TcpRpcCmd(String s) {tcpRpcCmder.Request(&TcpRpcCmder::TcpRpcCmd, s);}
	void SendCmd(int nCmd);
	
	void SaveRpcCmdResult(String string, int x2, String s);
	void SaveTcpRpcCmdResult(String string, int x2, String s);
	
	void SpawnTasks();
	
	void DoTasksAndStatistics();
	
	//Worker worker;
	UdpRpcCmder udpRpcCmder;
	TcpRpcCmder tcpRpcCmder;
	
//	String m_cfgFile;
	String m_CtrlIP;
	int m_nServerPort;

	String m_LocalCtrlIP;
	int m_nLocalCtrlPort;
	
	// Listenning here to figure any execution is needed
    void UDPRpcServerThread();
    void TCPRpcServerThread();

};


RegionalCtrl::RegionalCtrl(Local_Controller ctrl_cfg)
	:udpRpcCmder(this), tcpRpcCmder(this)
{
	m_CtrlIP = ctrl_cfg.subSys.strIP;
	m_nServerPort = ctrl_cfg.subSys.nPort;
	
	m_LocalCtrlIP = ctrl_cfg.strIP;
	m_nLocalCtrlPort = ctrl_cfg.nPort;
	
	CtrlLayout(*this);
	btnRead <<= callback1(this, &RegionalCtrl::SendCmd, 1103);
	btnWrite <<= callback1(this, &RegionalCtrl::SendCmd, 1524);
	btnStart <<= callback(this, &RegionalCtrl::SpawnTasks);
	
	SetTimeCallback(-200, callback(this, &RegionalCtrl::DoTasksAndStatistics));
	
	udpRpcCmder.Start();
	tcpRpcCmder.Start();
}

void RegionalCtrl::SendCmd(int nCmd)
{
	UdpRpcCmd(m_LocalCtrlIP, m_nLocalCtrlPort, nCmd);
}

void RegionalCtrl::SaveRpcCmdResult(String string, int x2, String s)
{
	//Update to GUI
	String strLog = Format("RPC, %s, %d, %s", string,x2,s);
	log.Set(strLog + "\n" + log.Get());
	LOG(strLog);
	//Log data into a data file here
}

void RegionalCtrl::SaveTcpRpcCmdResult(String string, int x2, String s)
{
	//Update to GUI
	String strLog = Format("TCP, %s, %d, %s", string,x2,s);
	log.Set(strLog + "\n" + log.Get());
	LOG(strLog);
	//Log data into a data file here
}

void RegionalCtrl::SpawnTasks()
{
	//Start Thread Remote Request; The Server Portion of the UDP TCP Service for Incoming Service
	//Request
	Thread udprpc;
	udprpc.Run(callback(this, &RegionalCtrl::UDPRpcServerThread));
	
	Thread tcprpc;
	tcprpc.Run(callback(this, &RegionalCtrl::TCPRpcServerThread)); 
	
	btnStart.Disable();
}

// Listenning here to figure any execution is needed
void RegionalCtrl::UDPRpcServerThread()
{
	UrrServer urr;
	urr.Create(m_nServerPort); 
	//Cout() << "URR Ping server\n";
	//while(false)
	for(;;) 
	{
		UrrRequest r;
		if(urr.Accept(r)) 
		{
			UdpRpcCmd(r);
		}
		Sleep(500);
	}
}

void RegionalCtrl::TCPRpcServerThread()
{
	TcpSocket server;
	if(!server.Listen(m_nServerPort+100, 5)) {
		Cout() << "Unable to initialize server socket!\n";
		SetExitCode(1);
		return;
	}
	Cout() << "Waiting for requests..\n";
	for(;;) 
	{
		TcpSocket s;
		if(s.Accept(server)) {
			String w = s.GetLine();
			TcpRpcCmd(w);
//			Cout() << "Request: " << w << " from: " << s.GetPeerAddr() << '\n';
			if(w == "time")
				s.Put(AsString(GetSysTime()));
			else
				s.Put(AsString(3 * atoi(~w)));
			s.Put("\n");
		}
		Sleep(500);
	}
}

void RegionalCtrl::DoTasksAndStatistics()
{
	info.SetLabel(Format("GUI: %d     U: %d", GetTasksCount(), udpRpcCmder.GetTasksCount()));

	DoTasks();
}


#endif
