#ifndef _JCTControl_OtherThreadClasses_h_
#define _JCTControl_OtherThreadClasses_h_

#include <chrono>
#include <MtAlt/MtAlt.h>
#include <Urr/Urr.h>

using namespace Upp;
using namespace std::chrono;

class Reader : public CallbackThread
{
public: //thread GUI
	class Notify 
	{ 
		public: virtual void OnReplyRead(int nData, int x2, String s) = 0; 
	};
	
	Reader(Notify *n) :notify(n) {}
	
public: //thread 1
	void ReadSensors() 
	{
		//Sleep(500); //ReadSensors, gathering data here
		
		notify->OnReplyRead(500, 500, Format(GetSysTime()));
	}
private:
	Notify *notify;
};

class Writer : public CallbackThread
{
public: //thread GUI
	class Notify 
	{ 
		public: virtual void OnReplyWrite(int nData, int x2, String s) = 0; 
	};
	
	Writer(Notify *n) :notify(n) {}
	
public: //thread 1
	void WriteCtrl(int nData)
	{
		//Sleep(300); //Write out control data from algo
		//Time t = GetSysTime();
		
		notify->OnReplyWrite(nData, (int) Random(500), Format(GetSysTime())); //notify result
	}
private:
	Notify *notify;
};

class UdpRpcCmder : public CallbackThread
{
public: //thread GUI
	class Notify 
	{ 
		public: virtual void OnReplyUdpRpcCmd(String string, int x2, String s) = 0; 
	};
	
	UdpRpcCmder(Notify *n) :notify(n) {}
	
public: //thread 1
	void UdpRpcCmd(UrrRequest r)
	{
		int q = atoi(~r);
		String response = AsString(q);
		r.Return(response);
		
		//Do something account to RpcCmd request;
		notify->OnReplyUdpRpcCmd(response, (int) Random(500), Format(GetSysTime())); //notify result
	}

	void UdpCmd(String strIP, int nPort, int nCmd)
	{
		UrrClient urr;
		urr.SetServer(strIP, nPort);

		int tm = GetTickCount();
		String strCmd = AsString(nCmd);
		
		strCmd = urr.Call(strCmd);
		int tm2 = GetTickCount();
		
		String strMsg;
		if(strCmd.GetCount())
		{
			strMsg = Format("Request: %d, Response: %s in %d ms", nCmd, strCmd, tm2-tm);
		}
		else
		{
			strMsg = Format("Request: %d, Time out!", nCmd);
		}
		//Do something account to RpcCmd request;
		notify->OnReplyUdpRpcCmd(strMsg, (int) Random(500), Format(GetSysTime())); //notify result
	}

private:
	Notify *notify;
};

class TcpRpcCmder : public CallbackThread
{
public: //thread GUI
	class Notify 
	{ 
		public: virtual void OnReplyTcpRpcCmd(String string, int x2, String s) = 0; 
	};
	
	TcpRpcCmder(Notify *n) :notify(n) {}
	
public: //thread 1
	void TcpRpcCmd(String string)
	{
		//Do something account to RpcCmd request;
		notify->OnReplyTcpRpcCmd(string, (int) Random(500), Format(GetSysTime())); //notify result
	}

private:
	Notify *notify;
};

/*
template < typename T >
class Singleton {
  public:
    static T& GetInstance() {
      static MemGuard g; // clean up on program end
      if (!m_instance) {
        m_instance = new T(); 
      }
      return *m_instance;
    }

    Singleton(const Singleton&) = delete;
    Singleton& operator= (const Singleton) = delete;

  protected:
    Singleton() { };
    virtual ~Singleton() { }

  private:
    static T * m_instance = nullptr;

    class MemGuard {
      public: 
        ~MemGuard() {
          delete m_instance;
          m_instance = nullptr;
        }
    };
};
*/

#endif
