#include <plugin/sqlite3/Sqlite3.h>

using namespace Upp;

#define SCHEMADIALECT <plugin/sqlite3/Sqlite3Schema.h>
#define MODEL <SqLiteIssues/db.sch>
#include <Sql/sch_header.h>
#include <Sql/sch_schema.h>
#include <Sql/sch_source.h>

using namespace Upp;

// Set these to make them throw errors
//#define ISSUE1
//#define ISSUE2

CONSOLE_APP_MAIN
{
	Sqlite3Session session;
	if (!session.Open(ConfigFile("SqLiteIssues.db")))
		Cout() << "Can't open db";
	else
	{
		SQL = session;
		SqlSchema sch(SQLITE3);
		All_Tables(sch);
		SqlPerformScript(sch.Upgrade());
		SqlPerformScript(sch.Attributes());
		SQL.ClearError();
		session.SetTrace();
		
		Sql sql; Time t = GetSysTime();
		
		// insert some data
		for (int i=0; i<5; i++)
		{
			sql*Insert(MY_TABLE)
				(MT_TIME, t+i)
				(MT_BOOL, i%2==0)
			;
		}
		
		// Issue 1: SqlMax over a TIME_ column returns WSTRING_V with SqLite and TIME_V with MySql
		Value v = sql%Select(SqlMax(MT_TIME)).From(MY_TABLE); // latest time
		Cout() << "last time is: " << v << " (type " << v.GetType() << " = " << v.GetTypeName() << ")\n";
#ifdef ISSUE1
		t = v; // this works on MySql but generates an exception with SqLite
		Cout() << "last time is: " << t << "\n";
#endif
		
		// Issue2: A query over a BOOL_ column returns WSTRING_V with SqLite and TIME_V with MySql
		v = sql%Select(MT_BOOL).From(MY_TABLE).Where(MT_TIME==v);
		Cout() << "last bool is: " << v << " (type " << v.GetType() << " = " << v.GetTypeName() << ")\n";
#ifdef ISSUE2
		bool b = v; // this works on MySql but generates an exception with SqLite
		Cout() << "last bool is: " << b << "\n";
#endif
	}
}
