#ifndef _Referti_Referti_h
#define _Referti_Referti_h

#include <CtrlLib/CtrlLib.h>

using namespace Upp;

#define LAYOUTFILE <Referti/Referti.lay>
#include <CtrlCore/lay.h>
#include <plugin/pcre/Pcre.h>

class Referti : public WithRefertiLayout<TopWindow> {
public:
	typedef Referti CLASSNAME;
	Referti();
	virtual void ResetWidgets() {
		cf.Clear();
		prenotazione.Clear();
	}
	void CopiaCF() { cf.Copy();	}
	void IncollaCF() { ResetWidgets(); Refresh(); cf.Paste(); prenotazione.SetText(""); Cerca(); }
	void CopiaPrenotazione() { prenotazione.Copy();	}
	void IncollaPrenotazione() { ResetWidgets(); Refresh(); prenotazione.Paste(); cf.SetText(""); Cerca(); }
	void CopiaRisultato() { risultato.Copy();	}
	void Cerca();
	String ProcessaPrenotazione(const String pren, int n, int count);
	bool PresenteInVettore(const String pren, Vector<String> &prenotazioni);
};

#endif
