#include "GridCtrlTest.h"

static void RecordsAddColumns(GridCtrl &data) {
	data.Ready(false);
	data.Clear(true);
	data.AddColumn(ID).Hidden();
	data.AddColumn(IDName, t_("ID Name"));
	data.AddColumn(ShortName, t_("Short name"));
	data.AddColumn(Description, t_("Description"));
	data.Ready(true);
}


GridCtrlTest::GridCtrlTest() {
	CtrlLayout(*this, "Window title");

	records.RejectNullRow();
	records.ColorRows().GridColor(White);
	records.MultiSelect();
	records.Sorting();
	records.MultiSorting();
	records.Hiding();
	records.AutoHideSb();

	splitter.Add(records);
	splitter.Zoom(0);

	AddFrame(menuBar);
	menuBar.Set([=](Bar &bar) { MenuMain(bar); });

	RecordsAddData(records);
}

void GridCtrlTest::MenuMain(Bar &menu) {
	menu.Sub(t_("Data"), [=](Bar &bar) { MenuData(bar); });
}

void GridCtrlTest::MenuData(Bar &menu) {
	menu.Add(t_("Data 1"), [=] { RecordsAddData(records); });
	menu.Add(t_("Data 2"), [=] { RecordsAddData2(records); });
}

void GridCtrlTest::RecordsAddData(GridCtrl& data) {
	RecordsAddColumns(data);
	data.Ready(false);
	for (int x = 0; x < 40; x++) {
		data.Add(x, Format("ID %d", x), "SC", "Description");
	}
	data.Ready(true);
}

void GridCtrlTest::RecordsAddData2(GridCtrl& data) {
	RecordsAddColumns(data);
	data.Ready(false);
	for (int x = 0; x < 40; x++) {
		data.Add(x, Format("ID2 %d", x), "SC", "Description");
	}
	data.Ready(true);
}

GUI_APP_MAIN {
	GridCtrlTest().Run();
}
